/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.util.settings.swing.AbstractBasicEditorProvider;
import de.caff.util.settings.swing.SwingStringPreferenceProperty;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JTextField;

class StringEditor
extends AbstractBasicEditorProvider
implements PropertyChangeListener {
    private final SwingStringPreferenceProperty property;
    private final JTextField textField;

    public StringEditor(SwingStringPreferenceProperty property, Locale l) {
        super(property, l);
        this.property = property;
        this.textField = new JTextField(property.getValue(), 40);
        property.addValueChangeListener(this);
    }

    public JComponent getEditor() {
        return this.textField;
    }

    public void reset() {
        this.textField.setText(this.property.getValue());
    }

    public void save() {
        this.property.setValue(this.textField.getText());
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.textField.getText().equals(evt.getNewValue().toString())) {
            this.textField.setText(evt.getNewValue().toString());
        }
    }

    public void goodBye() {
        this.property.removeValueChangeListener(this);
    }
}

