/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.i18n.swing.RJCheckBoxMenuItem;
import de.caff.util.settings.BooleanPreferenceProperty;
import de.caff.util.settings.swing.AbstractBasicSimpleEditablePreferenceProperty;
import de.caff.util.settings.swing.BooleanEditor;
import de.caff.util.settings.swing.EditorProvider;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.swing.JMenuItem;

public class SwingBooleanPreferenceProperty
extends AbstractBasicSimpleEditablePreferenceProperty
implements BooleanPreferenceProperty {
    private boolean value;

    public SwingBooleanPreferenceProperty(String basicName, String baseTag, boolean value) {
        super(basicName, baseTag);
        this.value = value;
    }

    public void readFrom(Preferences preferences) {
        this.setValue(preferences.getBoolean(this.getBasicName(), this.value));
    }

    public void storeTo(Preferences preferences) {
        preferences.putBoolean(this.getBasicName(), this.value);
    }

    public EditorProvider getEditorProvider(Locale l) {
        return new BooleanEditor(this, l);
    }

    public boolean getValue() {
        return this.value;
    }

    public void setValue(boolean value) {
        if (this.value != value) {
            this.value = value;
            this.fireValueChange(this.getBasicName(), !value, value);
        }
    }

    public JMenuItem createMenuItem(Locale l) {
        SpecialMenuItem menuItem = new SpecialMenuItem();
        menuItem.setLocale(l);
        return menuItem;
    }

    private class SpecialMenuItem
    extends RJCheckBoxMenuItem
    implements PropertyChangeListener {
        public SpecialMenuItem() {
            super(SwingBooleanPreferenceProperty.this.getBaseTag(), SwingBooleanPreferenceProperty.this.getValue());
            this.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    SwingBooleanPreferenceProperty.this.setValue(SpecialMenuItem.this.isSelected());
                }
            });
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.setSelected((Boolean)evt.getNewValue());
        }

        public void addNotify() {
            super.addNotify();
            SwingBooleanPreferenceProperty.this.addValueChangeListener(this);
            this.setSelected(SwingBooleanPreferenceProperty.this.getValue());
        }

        public void removeNotify() {
            super.removeNotify();
            SwingBooleanPreferenceProperty.this.removeValueChangeListener(this);
        }
    }
}

