/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.util.settings.swing.EditablePreferenceGroup;
import de.caff.util.settings.swing.SwingBooleanPreferenceProperty;
import de.caff.util.settings.swing.SwingIntegerPreferenceProperty;
import de.caff.util.settings.swing.SwingStringPreferenceProperty;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;

public class SwingHttpProxyPropertySettings
extends EditablePreferenceGroup
implements PropertyChangeListener {
    public static final String PORT_SUFFIX = "-PORT";
    public static final String HOST_SUFFIX = "-HOST";
    public static final String USED_SUFFIX = "-USED";
    private final SwingBooleanPreferenceProperty useProxy;
    private final SwingStringPreferenceProperty proxyHost;
    private final SwingIntegerPreferenceProperty proxyPort;

    public SwingHttpProxyPropertySettings(String basicName, String baseTag) {
        super(baseTag, false);
        this.useProxy = new SwingBooleanPreferenceProperty(basicName + USED_SUFFIX, baseTag + USED_SUFFIX, false);
        this.proxyHost = new SwingStringPreferenceProperty(basicName + HOST_SUFFIX, baseTag + HOST_SUFFIX);
        this.proxyPort = new SwingIntegerPreferenceProperty(basicName + PORT_SUFFIX, baseTag + PORT_SUFFIX, 80, 1, 65535);
        String pUsed = System.getProperty("proxySet");
        String pHost = System.getProperty("http.proxyHost");
        String pPort = System.getProperty("http.proxyPort");
        if (pUsed != null && Boolean.valueOf(pUsed).booleanValue()) {
            this.useProxy.setValue(true);
            this.proxyHost.setValue(pHost);
            this.proxyPort.setValue(Integer.parseInt(pPort));
        }
        this.useProxy.addValueChangeListener(this);
        this.proxyHost.addValueChangeListener(this);
        this.proxyPort.addValueChangeListener(this);
        this.addProperty(this.useProxy);
        this.addProperty(this.proxyHost);
        this.addProperty(this.proxyPort);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.useProxy.getValue()) {
            System.setProperty("proxySet", "true");
            String host = this.proxyHost.getValue();
            System.setProperty("http.proxyHost", host != null ? host : "");
            System.setProperty("http.proxyPort", Integer.toString(this.proxyPort.getValue()));
        } else {
            Properties properties = System.getProperties();
            properties.remove("http.proxyHost");
            properties.remove("http.proxyPort");
            properties.remove("proxySet");
            System.setProperties(properties);
        }
    }
}

