/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.util.settings.StringPreferenceProperty;
import de.caff.util.settings.swing.AbstractBasicSimpleEditablePreferenceProperty;
import de.caff.util.settings.swing.EditorProvider;
import de.caff.util.settings.swing.StringEditor;
import java.util.Locale;
import java.util.prefs.Preferences;

public class SwingStringPreferenceProperty
extends AbstractBasicSimpleEditablePreferenceProperty
implements StringPreferenceProperty {
    private String value;

    public SwingStringPreferenceProperty(String basicName, String baseTag) {
        super(basicName, baseTag);
    }

    public void readFrom(Preferences preferences) {
        this.setValue(preferences.get(this.getBasicName(), null));
    }

    public void storeTo(Preferences preferences) {
        if (this.value == null) {
            preferences.remove(this.getBasicName());
        } else {
            preferences.put(this.getBasicName(), this.value);
        }
    }

    public EditorProvider getEditorProvider(Locale l) {
        return new StringEditor(this, l);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if (value != null ? !value.equals(this.value) : this.value != null) {
            String oldValue = this.value;
            this.value = value;
            this.fireValueChange(this.getBasicName(), oldValue, value);
        }
    }
}

