// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid;

/**
 *  Visitor pattern interface for {@link de.caff.asteroid.GameObject}s.
 */
public interface GameObjectVisitor
{
  /**
   *  Handle an asteroid.
   *  @param asteroid asteroid to handle
   */
  public void handle(Asteroid asteroid);

  /**
   *  Handle a bullet.
   *  @param bullet  bullet to handle
   */
  public void handle(Bullet bullet);

  /**
   *  Handle an explosion.
   *  @param explosion explosion to handle
   */
  public void handle(Explosion explosion);

  /**
   *  Handle a ship explosion.
   *  @param explosion  ship explosion to handle
   */
  public void handle(ShipExplosion explosion);

  /**
   *  Handle a space ship.
   *  @param ship  space ship to handle
   */
  public void handle(SpaceShip ship);

  /**
   *  Handle a text.
   *  @param text  text to handle
   */
  public void handle(Text text);

  /**
   *  Handle an ufo.
   *  @param ufo  ufo to handle
   */
  public void handle(Ufo ufo);

}
