// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2005  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.util.settings.swing;

import javax.swing.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;

/**
 *  Editor provider for boolean properties.
 *
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision$
 */
class BooleanEditor
        extends AbstractBasicEditorProvider
        implements PropertyChangeListener
{
  /** The property to edit. */
  private final SwingBooleanPreferenceProperty property;
  /** The checkbox representing the property. */
  private final JCheckBox checkBox;

  /**
   * Constructor.
   * @param property property to edit
   * @param l        locale to use
   */
  public BooleanEditor(SwingBooleanPreferenceProperty property, Locale l)
  {
    super(property, l);
    this.property = property;
    checkBox = new JCheckBox((String)null, property.getValue());
    property.addValueChangeListener(this);
  }

  /**
   * Get an component for editing .
   *
   * @return editor component
   */
  public JComponent getEditor()
  {
    return checkBox;
  }

  /**
   * Reset the value in the editor to the basic value.
   */
  public void reset()
  {
    checkBox.setSelected(property.getValue());
  }

  /**
   * Set the basic value from the editor.
   */
  public void save()
  {
    property.setValue(checkBox.isSelected());
  }

  /**
   * This method gets called when a bound property is changed.
   *
   * @param evt A PropertyChangeEvent object describing the event source
   *            and the property that has changed.
   */
  public void propertyChange(PropertyChangeEvent evt)
  {
    boolean newValue = ((Boolean)evt.getNewValue()).booleanValue();
    if (newValue != checkBox.isSelected()) {
      checkBox.setSelected(newValue);
    }
  }

  /**
   * Called when the editor provider is no longer used.
   */
  public void goodBye()
  {
    property.removeValueChangeListener(this);
  }
}
