// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2005  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.util.settings.swing;

import javax.swing.*;

/**
 *  A name and a component.
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision$
 */
public interface EditorProvider
{
  /**
   *  Get a label text for this editor component.
   *  If the text is null the editor component is inserted without a label.
   *  @return something to be displayed as a label
   */
  public String getLabelText();

  /**
   *  Get a title text for this editor component.
   *  @return a title text or <code>null</code> if a title makes no sense
   */
  public String getTitleText();

  /**
   *  Get a tool tip string for this editor component.
   *  @return tooltip text or <code>null</code> if no tooltip is used
   */
  public String getToolTipText();

  /**
   *  Get a description for the property used.
   *  @return description, possibly multi-line
   */
  public String getDescription();

  /**
   *  Get an component for editing .
   *  @return editor component
   */
  public JComponent getEditor();

  /**
   *  Is the value in the editor component valid?
   */
  public boolean isValid();

  /**
   *  Reset the value in the editor to the basic value.
   */
  public void reset();

  /**
   *  Set the basic value from the editor.
   */
  public void save();

  /**
   *  Called when the editor provider is no longer used.
   */
  public void goodBye();
}
