/*
 * Decompiled with CFR 0.152.
 */
package asteroid.model;

import asteroid.Operation;
import asteroid.model.FlyInfo;
import asteroid.model.GameModel;

public abstract class AFlyable
extends FlyInfo {
    public static final int STEP_SIZE = 8;
    public static final int STATE_HIDDEN = 0;
    public static final int STATE_VISIBLE = 1;
    public static final int STATE_EXPLOSION = 2;
    public static final int STATE_BLOCKED = 3;
    public static final int STATE_JUMP = 4;
    int mState;
    int mCreate;
    int mVanish;
    double mVelocity;
    double mBetha;
    private int mLastFrame;
    private int mModify;
    private int[] mStepX = new int[8];
    private int[] mStepY = new int[8];

    AFlyable() {
    }

    AFlyable(int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4, n5);
        this.mVelocity = Math.sqrt(n4 * n4 + n5 * n5);
        this.mBetha = Math.atan2(n5, n4);
    }

    final void addStep8(int n, int n2) {
        int n3 = this.getFrameDistance();
        if (n3 > 0) {
            int n4 = (Operation.signX8(n - this.mX8) >> 3) / n3;
            int n5 = (Operation.signY8(n2 - this.mY8) >> 3) / n3;
            if (Math.abs(n4) > 300 || Math.abs(n5) > 300) {
                n4 += 0;
                n5 += 0;
            }
            if (this.mMoveX8 == 0 && this.mMoveY8 == 0) {
                this.initStep(n4, n5);
            } else {
                int n6 = GameModel.sFrame & 7;
                this.mMoveX8 -= this.mStepX[n6];
                this.mMoveY8 -= this.mStepY[n6];
                this.mMoveX8 += n4;
                this.mMoveY8 += n5;
                this.mStepX[n6] = n4;
                this.mStepY[n6] = n5;
                this.mBetha = Math.atan2(this.mMoveY8, this.mMoveX8);
                this.mVelocity = Math.sqrt(this.mMoveX8 * this.mMoveX8 + this.mMoveY8 * this.mMoveY8);
            }
            this.mCreate = 0;
        }
    }

    public final double getBetha() {
        return this.mBetha;
    }

    public final boolean isBlocked() {
        return this.mState == 3;
    }

    public final int getCreate() {
        return this.mCreate;
    }

    public final boolean isExplosion() {
        return this.mState == 2;
    }

    final int getFrameDistance() {
        return GameModel.sFrame - this.mLastFrame;
    }

    public final boolean isHidden() {
        return this.mState == 0;
    }

    public abstract String getIdent();

    final void initStep(int n, int n2) {
        this.mModify = 0;
        for (int i = 0; i < 8; ++i) {
            this.mStepX[i] = n;
            this.mStepY[i] = n2;
        }
        this.mMoveX8 = n << 3;
        this.mMoveY8 = n2 << 3;
    }

    public final boolean isJump() {
        return this.mState == 4;
    }

    public final int getModify() {
        return this.mModify;
    }

    final void setPos8(int n, int n2, int n3) {
        this.mX8 = n;
        this.mY8 = n2;
        this.mZ = n3;
        this.mLastFrame = GameModel.sFrame;
        ++this.mModify;
    }

    void set(int n, int n2, int n3, int n4, int n5, int n6) {
        this.mX8 = n;
        this.mY8 = n2;
        this.mZ = n3;
        this.mMoveX8 = n4;
        this.mMoveY8 = n5;
        this.mCreate = this.isHidden() && n6 != 0 ? 1 : 0;
        this.mVanish = this.isVisible() && n6 != 1 ? 1 : 0;
        this.mState = n6;
        this.mModify = n6 == 1 ? ++this.mModify : 0;
    }

    public abstract int size();

    public abstract int sizeX();

    public abstract int sizeY();

    public final int getState() {
        return this.mState;
    }

    public final int[] getStepsX() {
        return this.mStepX;
    }

    public final int[] getStepsY() {
        return this.mStepY;
    }

    public final int getVanish() {
        return this.mVanish;
    }

    public final int getVelocity28() {
        return this.mMoveX8 * this.mMoveX8 + this.mMoveY8 * this.mMoveY8;
    }

    public final double getVelocity8() {
        return this.mVelocity;
    }

    public final boolean isVisible() {
        return this.mState == 1;
    }
}

