/*
 * Decompiled with CFR 0.152.
 */
package asteroid.model;

import asteroid.model.ACompute;
import asteroid.model.AFlyable;
import asteroid.model.Asteroid;
import asteroid.model.AsteroidVector;
import asteroid.model.Ship;
import asteroid.model.Shot;
import asteroid.model.ShotVector;
import asteroid.model.Ufo;

public class Collider
extends ACompute {
    private static final int SHIP_SAVE = 0;
    private AsteroidVector mAsts;
    private int mForward;
    private boolean mSave;
    private Ship mShip;
    private int mShipFak;
    private boolean mShipFly;
    private ShotVector mShots;
    private Ufo mUfo;

    Collider(Ship ship, Ufo ufo, AsteroidVector asteroidVector, ShotVector shotVector) {
        this.mShip = ship;
        this.mUfo = ufo;
        this.mAsts = asteroidVector;
        this.mShots = shotVector;
    }

    void detect(int n) {
        this.mForward = n + 1;
        this.mSave = true;
        if (this.mShip.isVisible()) {
            this.mShipFly = this.mShip.mMoveX8 != 0 || this.mShip.mMoveY8 != 0;
            this.mShipFak = this.mShip.mY8 * this.mShip.mMoveX8 - this.mShip.mX8 * this.mShip.mMoveY8;
            this.mUfo.doIt(this);
            if (this.mSave) {
                this.mAsts.forAll(this);
            }
            if (this.mSave) {
                this.mShots.forAll(this);
            }
        }
    }

    public void forAsteroid(Asteroid asteroid) {
        this.forFlyable(asteroid);
    }

    void forFlyable(AFlyable aFlyable) {
        if (this.mSave && aFlyable.isVisible()) {
            this.mSave = this.mShipFly ? !Collider.hitFirstFly(this.mShip, this.mShipFak, aFlyable, this.mForward) : !Collider.hitFirstStand(this.mShip, aFlyable, this.mForward);
        }
    }

    public void forShot(Shot shot) {
        if (!shot.isShip()) {
            this.forFlyable(shot);
        }
    }

    public void forUfo(Ufo ufo) {
        this.forFlyable(ufo);
    }

    public static boolean hitAtPos(AFlyable aFlyable, AFlyable aFlyable2, int n, int n2, int n3) {
        int n4 = aFlyable.sizeX() + aFlyable2.sizeX() + 0;
        if (Collider.isOutside(aFlyable.mX8, n3 * aFlyable.mMoveX8, n, n4)) {
            return false;
        }
        if (Collider.isOutside(aFlyable2.mX8, n3 * aFlyable2.mMoveX8, n, n4)) {
            return false;
        }
        int n5 = aFlyable2.sizeY() + aFlyable.sizeY() + 0;
        if (Collider.isOutside(aFlyable.mY8, n3 * aFlyable.mMoveY8, n2, n5)) {
            return false;
        }
        return !Collider.isOutside(aFlyable2.mY8, n3 * aFlyable2.mMoveY8, n2, n5);
    }

    public static boolean hitBy(AFlyable aFlyable, AFlyable aFlyable2, int n) {
        if (aFlyable.mMoveX8 != 0 || aFlyable.mMoveY8 != 0) {
            return Collider.hitFirstFly(aFlyable, aFlyable2, n);
        }
        return Collider.hitFirstStand(aFlyable, aFlyable2, n);
    }

    public static boolean hitFirstFly(AFlyable aFlyable, AFlyable aFlyable2, int n) {
        int n2 = aFlyable.mMoveX8 * aFlyable2.mMoveY8 - aFlyable.mMoveY8 * aFlyable2.mMoveX8;
        if (n2 == 0) {
            return false;
        }
        int n3 = aFlyable.mY8 * aFlyable.mMoveX8 - aFlyable.mX8 * aFlyable.mMoveY8;
        int n4 = aFlyable2.mY8 * aFlyable2.mMoveX8 - aFlyable2.mX8 * aFlyable2.mMoveY8;
        int n5 = n3 * aFlyable2.mMoveX8 / n2 - n4 * aFlyable.mMoveX8 / n2;
        int n6 = n3 * aFlyable2.mMoveY8 / n2 - n4 * aFlyable.mMoveY8 / n2;
        return Collider.hitAtPos(aFlyable, aFlyable2, n5, n6, n);
    }

    private static boolean hitFirstFly(AFlyable aFlyable, int n, AFlyable aFlyable2, int n2) {
        int n3 = aFlyable.mMoveX8 * aFlyable2.mMoveY8 - aFlyable.mMoveY8 * aFlyable2.mMoveX8;
        if (n3 == 0) {
            return false;
        }
        int n4 = aFlyable2.mY8 * aFlyable2.mMoveX8 - aFlyable2.mX8 * aFlyable2.mMoveY8;
        int n5 = n * aFlyable2.mMoveX8 / n3 - n4 * aFlyable.mMoveX8 / n3;
        int n6 = n * aFlyable2.mMoveY8 / n3 - n4 * aFlyable.mMoveY8 / n3;
        return Collider.hitAtPos(aFlyable, aFlyable2, n5, n6, n2);
    }

    public static boolean hitFirstStand(AFlyable aFlyable, AFlyable aFlyable2, int n) {
        int n2 = aFlyable2.mMoveY8 * aFlyable2.mMoveY8 + aFlyable2.mMoveX8 * aFlyable2.mMoveX8;
        if (n2 == 0) {
            return false;
        }
        int n3 = aFlyable.mX8 - aFlyable2.mX8;
        int n4 = aFlyable.mY8 - aFlyable2.mY8;
        int n5 = n4 * aFlyable2.mMoveX8 - n3 * aFlyable2.mMoveY8;
        int n6 = aFlyable.mX8 + n5 * aFlyable2.mMoveY8 / n2;
        int n7 = aFlyable.mY8 - n5 * aFlyable2.mMoveX8 / n2;
        return Collider.hitAtPos(aFlyable, aFlyable2, n6, n7, n);
    }

    public static boolean isInside(int n, int n2, int n3, int n4) {
        int n5 = n3 - n;
        if (n2 < 0) {
            return n5 < n4 && n5 > n2 - n4;
        }
        return n5 > -n4 && n5 < n2 + n4;
    }

    public int getKey() {
        if (this.mSave) {
            return 0;
        }
        return 1;
    }

    public static boolean isOutside(int n, int n2, int n3, int n4) {
        int n5 = n3 - n;
        if (n2 < 0) {
            return n5 > n4 || n5 < n2 - n4;
        }
        return n5 < -n4 || n5 > n2 + n4;
    }
}

