/*
 * Decompiled with CFR 0.152.
 */
package asteroid.model;

import asteroid.Operation;
import asteroid.model.AFlyable;
import asteroid.model.Angle;
import asteroid.model.FlyInfo;
import asteroid.model.GameModel;
import asteroid.model.ICompute;

public class Shot
extends AFlyable {
    public static final int MAX_LIFE = 72;
    public static final int MAX_SHIP_SHOTS = 4;
    public static final double SHIP_SHOT_SPEED = 8.0;
    public static final double UFO_SHOT_SPEED = 10.0;
    public static final double SHIP_SHOT_SPEED8 = 64.0;
    public static final double UFO_SHOT_SPEED8 = 80.0;
    public static int sLifeOffset;
    int mBirth;
    int mIndex;
    double mHitTime;
    FlyInfo mLast;
    private String mIdent;
    private boolean mShip;

    Shot(int n) {
        this.mIndex = n;
        this.mShip = n < 4;
        this.mIdent = "M" + n;
        this.mLast = new FlyInfo();
    }

    Shot(int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4, n5);
        this.mLast = new FlyInfo(n, n2, n3, n4, n5);
    }

    void setCreate(boolean bl) {
        if (bl) {
            this.mCreate = 1;
            this.mBirth = GameModel.sFrame;
        } else {
            this.mCreate = 0;
        }
    }

    public void doIt(ICompute iCompute) {
        iCompute.forShot(this);
    }

    public double getHitTime() {
        return this.mHitTime;
    }

    public String getIdent() {
        return this.mIdent;
    }

    public int getIndex() {
        return this.mIndex;
    }

    void init(int n) {
        int n2 = Angle.getMoveX(this.mShip ? 8.0 : 10.0, n);
        int n3 = Angle.getMoveY(this.mShip ? 8.0 : 10.0, n);
        this.initStep(n2, n3);
    }

    public FlyInfo getLast() {
        return this.mLast;
    }

    public int getLife() {
        return GameModel.sFrame - this.mBirth + sLifeOffset;
    }

    boolean match8(int n, int n2) {
        int n3;
        if (this.mMoveX8 == 0 && this.mMoveY8 == 0) {
            int n4 = Operation.signX8(n - this.mX8);
            int n5 = Operation.signY8(n2 - this.mY8);
            return Math.abs(n4) <= 136 && Math.abs(n5) <= 136;
        }
        int n6 = this.getFrameDistance();
        if (n6 <= 0) {
            return false;
        }
        int n7 = this.mMoveX8 * this.mMoveX8 + this.mMoveY8 * this.mMoveY8;
        int n8 = Operation.signX8(n - this.mX8 - this.mMoveX8 * n6);
        int n9 = n8 * n8 + (n3 = Operation.signY8(n2 - this.mY8 - this.mMoveY8 * n6)) * n3;
        return n9 < n7;
    }

    public boolean isShip() {
        return this.mShip;
    }

    public int size() {
        return 32;
    }

    public int sizeX() {
        return this.size();
    }

    public int sizeY() {
        return this.size();
    }

    void setVanish(boolean bl) {
        if (bl) {
            this.mVanish = 1;
            this.mLast.set(this);
            int n = this.getLife();
            if (n > 68) {
                sLifeOffset = sLifeOffset - n & 3;
            }
        } else {
            this.mVanish = 0;
        }
    }
}

