/*
 * Decompiled with CFR 0.152.
 */
package asteroid.model;

import asteroid.Operation;
import asteroid.SimpleLogging;
import asteroid.model.AFlyable;
import asteroid.model.FlyDetect;
import asteroid.model.ICompute;
import asteroid.model.Ship;
import asteroid.model.Shot;
import asteroid.model.Ufo;

public class ShotVector {
    public static final int MAX_SHOTS = 6;
    Shot[] mShots = new Shot[6];
    int mVanish;
    private FlyDetect[] mDetect = new FlyDetect[6];
    private Ship mShip;
    private int mShipShots;
    private int mSize;
    private Ufo mUfo;

    ShotVector(Ship ship, Ufo ufo) {
        this.mShip = ship;
        this.mUfo = ufo;
        for (int i = 0; i < 6; ++i) {
            this.mShots[i] = new Shot(i);
            this.mDetect[i] = new FlyDetect();
        }
    }

    void addShot(int n, int n2, int n3) {
        this.mDetect[this.mSize++].set8(n << 3, n2 << 3, n3, 4095, false);
    }

    void clearAll() {
        for (int i = 0; i < 6; ++i) {
            Shot shot = this.mShots[i];
            shot.mState = 0;
            shot.initStep(0, 0);
        }
    }

    void detect(int n) {
        Object object;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.mSize; ++n2) {
            if (n3 == 6) {
                SimpleLogging.addLog("to many shots");
                break;
            }
            object = this.mDetect[n2];
            Shot shot = this.findMatch(n3, (FlyDetect)object);
            if (shot != null) {
                shot.addStep8(((FlyDetect)object).mX8, ((FlyDetect)object).mY8);
                shot.setPos8(((FlyDetect)object).mX8, ((FlyDetect)object).mY8, ((FlyDetect)object).mZ);
                shot.mState = 1;
                shot.setVanish(false);
                this.remove(n3, shot.mIndex);
                n3 = shot.mIndex + 1;
                ((FlyDetect)object).mIndex = shot.mIndex;
                continue;
            }
            if (this.mUfo.isVisible() && n2 >= this.mSize - 2 && (n3 >= 4 || Operation.distX8(((FlyDetect)object).mX8 - this.mShip.mX8) > 320 || Operation.distY8(((FlyDetect)object).mY8 - this.mShip.mY8) > 320)) {
                if (n3 < 4) {
                    this.remove(n3, 4);
                    n3 = 4;
                }
                shot = this.mShots[n3];
                shot.setVanish(shot.isVisible());
                shot.setCreate(true);
                shot.initStep(0, 0);
                shot.setPos8(((FlyDetect)object).mX8, ((FlyDetect)object).mY8, ((FlyDetect)object).mZ);
                shot.mState = 1;
                ++n3;
                ((FlyDetect)object).mIndex = shot.mIndex;
                continue;
            }
            shot = this.mShots[n3];
            shot.setVanish(shot.isVisible());
            shot.setCreate(true);
            shot.init(n);
            shot.setPos8(((FlyDetect)object).mX8, ((FlyDetect)object).mY8, ((FlyDetect)object).mZ);
            shot.mState = 1;
            ((FlyDetect)object).mIndex = shot.mIndex;
            if (++n3 <= 4) continue;
            SimpleLogging.addLog("ufo shot expected");
        }
        this.remove(n3, 6);
        this.mShipShots = 0;
        this.mVanish = 0;
        for (n2 = 0; n2 < 4; ++n2) {
            object = this.mShots[n2];
            if (((AFlyable)object).isVisible()) {
                ++this.mShipShots;
            }
            if (((AFlyable)object).getVanish() != 1) continue;
            ++this.mVanish;
        }
    }

    private Shot findMatch(int n, FlyDetect flyDetect) {
        for (int i = n; i < 6; ++i) {
            Shot shot = this.mShots[i];
            if (!shot.isVisible() || !shot.match8(flyDetect.mX8, flyDetect.mY8)) continue;
            return shot;
        }
        return null;
    }

    void forAll(ICompute iCompute) {
        for (int i = 0; i < 6; ++i) {
            this.mShots[i].doIt(iCompute);
        }
    }

    void forAllDetect(ICompute iCompute) {
        for (int i = 0; i < this.mSize; ++i) {
            this.mDetect[i].doShot(iCompute);
        }
    }

    Shot get(int n) {
        return this.mShots[n];
    }

    void prepare() {
        this.mSize = 0;
    }

    private void remove(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            Shot shot = this.mShots[i];
            shot.setVanish(shot.isVisible());
            shot.setCreate(false);
            shot.mState = 0;
        }
    }

    void set(int n, int n2, int n3, int n4) {
        Shot shot = this.mShots[n];
        shot.initStep(0, 0);
        shot.setPos8(n2 << 3, n3 << 3, n4);
        shot.mState = 1;
    }

    void set(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.mShots[n].set(n2, n3, n4, n5, n6, n7);
    }

    void set8(int n, int n2, int n3, int n4) {
        Shot shot = this.mShots[n];
        shot.initStep(0, 0);
        shot.setPos8(n2, n3, n4);
        shot.mState = 1;
    }

    public int getShipShots() {
        return this.mShipShots;
    }

    public int getVanish() {
        return this.mVanish;
    }
}

