/*
 * Decompiled with CFR 0.152.
 */
package asteroid.model;

import asteroid.Operation;
import asteroid.model.AEnemy;
import asteroid.model.Angle;
import asteroid.model.GameModel;
import asteroid.model.Ship;

public class TargetInfo {
    private double mAlpha;
    private int mDirection;
    private int mRot;
    private int mWait;
    private int mFrameHit;
    private int mFrameShot;
    private boolean mLeftMove;
    private boolean mLeftRot;

    public void setAll(TargetInfo targetInfo) {
        this.mDirection = targetInfo.mDirection;
        this.mLeftMove = targetInfo.mLeftMove;
        this.mLeftRot = targetInfo.mLeftRot;
        this.mRot = targetInfo.mRot;
        this.mWait = targetInfo.mWait;
        this.mFrameHit = targetInfo.mFrameHit;
        this.mFrameShot = targetInfo.mFrameShot;
    }

    public double getAlpha() {
        return this.mAlpha;
    }

    void awayInit(int n, int n2) {
    }

    public void calculate(AEnemy aEnemy, Ship ship, int n, int n2, int n3) {
        int n4;
        int n5 = n2 - GameModel.sFrame + Angle.sForward;
        int n6 = 0;
        int n7 = 0;
        int n8 = TargetInfo.getX0(aEnemy, ship, n5, n6);
        this.mLeftMove = n8 * aEnemy.mMoveY8 > (n4 = TargetInfo.getY0(aEnemy, ship, n5, n7)) * aEnemy.mMoveX8;
        double d = Angle.toRadiant(Angle.signRot(n));
        this.mAlpha = Math.atan2(n4, n8);
        this.nextAlpha(aEnemy, n8, n4, d);
        double d2 = Angle.toAngle(Angle.signRot(this.mAlpha - d)) / 3.0;
        boolean bl = this.mLeftRot = d2 >= 0.0;
        this.mRot = this.mLeftRot ? (this.mLeftMove ? (int)Math.ceil(d2) : (int)Math.floor(d2)) : (this.mLeftMove ? -((int)Math.ceil(d2)) : -((int)Math.floor(d2)));
        this.rotBest(aEnemy, n8, n4, n, n2, n3);
        this.setTimes(aEnemy, n8, n4, n, n2);
    }

    public int getDirection() {
        return this.mDirection;
    }

    public int getFireTime() {
        return this.mFrameHit - this.mFrameShot;
    }

    public int getFrameHit() {
        return this.mFrameHit;
    }

    private void nextAlpha(AEnemy aEnemy, int n, int n2, double d) {
        int n3 = Angle.getAngle(this.mAlpha);
        double d2 = this.mAlpha - d;
        if (Angle.signRot(this.mAlpha - d) > 0.0) {
            if (d2 < -1.5707963267948966) {
                d2 += Math.PI * 2;
            }
        } else if (d2 > 1.5707963267948966) {
            d2 -= Math.PI * 2;
        }
        double d3 = Angle.toAngle(d2) / 3.0;
        double d4 = Math.abs(d3) + (double)Angle.sForward;
        double d5 = (double)n + d4 * (double)aEnemy.mMoveX8 - (double)Angle.posShotX(n3);
        double d6 = (double)n2 + d4 * (double)aEnemy.mMoveY8 - (double)Angle.posShotY(n3);
        double d7 = Angle.vShot(n3);
        double d8 = Math.atan2(d6, d5);
        double d9 = aEnemy.getBetha() - d8;
        double d10 = Math.asin(aEnemy.getVelocity8() * Math.sin(d9) / d7);
        if (d10 > 1.5707963267948966) {
            d10 = Math.PI - d10;
        } else if (d10 < -1.5707963267948966) {
            d10 = -Math.PI - d10;
        }
        this.mAlpha = d10 + d8;
    }

    public int getRot() {
        return this.mRot;
    }

    public int getRot(AEnemy aEnemy) {
        if (aEnemy.isVisible() && this.mRot != 0) {
            return this.mLeftRot ? 16 : 8;
        }
        return 0;
    }

    private int rotBackFar(AEnemy aEnemy, int n, int n2, int n3, int n4) {
        while (this.mWait > Math.max(n4, 0)) {
            --this.mRot;
            this.mWait = this.twBetween(aEnemy, n, n2, n3, ++n4);
        }
        return n4;
    }

    private int rotBackShort(AEnemy aEnemy, int n, int n2, int n3, int n4) {
        while (this.mWait < 0) {
            --this.mRot;
            this.mWait = this.twBetween(aEnemy, n, n2, n3, ++n4);
        }
        return n4;
    }

    private void rotBest(AEnemy aEnemy, int n, int n2, int n3, int n4, int n5) {
        int n6 = n5 - n4 - this.mRot;
        this.mWait = this.twBetween(aEnemy, n, n2, n3, n6);
        if (this.mLeftRot) {
            if (this.mLeftMove) {
                n6 = this.rotBackFar(aEnemy, n, n2, n3, n6);
                n6 = this.rotForwardShort(aEnemy, n, n2, n3, n6);
            } else {
                n6 = this.rotForwardFar(aEnemy, n, n2, n3, n6);
                n6 = this.rotBackShort(aEnemy, n, n2, n3, n6);
            }
        } else if (this.mLeftMove) {
            n6 = this.rotForwardFar(aEnemy, n, n2, n3, n6);
            n6 = this.rotBackShort(aEnemy, n, n2, n3, n6);
        } else {
            n6 = this.rotBackFar(aEnemy, n, n2, n3, n6);
            n6 = this.rotForwardShort(aEnemy, n, n2, n3, n6);
        }
        if (this.mWait < n6) {
            this.mWait = n6;
        }
        if (this.mRot < 0) {
            this.mLeftRot = !this.mLeftRot;
            this.mRot = -this.mRot;
        }
    }

    private int rotForwardFar(AEnemy aEnemy, int n, int n2, int n3, int n4) {
        while (this.mWait > Math.max(n4, 0)) {
            ++this.mRot;
            this.mWait = this.twBetween(aEnemy, n, n2, n3, --n4);
        }
        return n4;
    }

    private int rotForwardShort(AEnemy aEnemy, int n, int n2, int n3, int n4) {
        while (this.mWait < 0) {
            ++this.mRot;
            this.mWait = this.twBetween(aEnemy, n, n2, n3, --n4);
        }
        return n4;
    }

    private int timeColl(AEnemy aEnemy, int n, int n2) {
        int n3;
        int n4 = aEnemy.mMoveX8 - Angle.vShotX(this.mDirection);
        int n5 = n4 * n4 + (n3 = aEnemy.mMoveY8 - Angle.vShotY(this.mDirection)) * n3;
        if (n5 == 0) {
            return Short.MAX_VALUE;
        }
        int n6 = this.mRot + this.mWait;
        int n7 = n + n6 * aEnemy.mMoveX8 - Angle.posShotX(this.mDirection);
        int n8 = n2 + n6 * aEnemy.mMoveY8 - Angle.posShotY(this.mDirection);
        int n9 = -(n7 * n4 + n8 * n3);
        int n10 = n7 * n3 - n8 * n4;
        int n11 = aEnemy.size() * aEnemy.size() * n5 - n10 * n10;
        int n12 = (int)Math.sqrt((double)n11 + 0.5);
        int n13 = (n9 - n12) / n5;
        int n14 = (n9 + n12) / n5;
        if (n13 < 0 && n14 < 0) {
            return Short.MAX_VALUE;
        }
        if (n13 < 0) {
            return n14;
        }
        if (n14 < 0) {
            return n13;
        }
        return n13 < n14 ? n13 : n14;
    }

    private void setTimes(AEnemy aEnemy, int n, int n2, int n3, int n4) {
        this.mDirection = this.mLeftRot ? n3 + 3 * this.mRot : n3 - 3 * this.mRot;
        if (this.mWait < 0) {
            this.mWait = 0;
            this.mFrameShot = n4 + this.mRot;
            this.mFrameHit = this.mFrameShot + Short.MAX_VALUE;
        } else {
            this.mFrameShot = n4 + this.mRot + this.mWait;
            this.mFrameHit = this.mFrameShot + this.timeColl(aEnemy, n, n2);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.mLeftRot ? (char)'+' : '-');
        stringBuffer.append(this.mRot);
        stringBuffer.append(':');
        stringBuffer.append(this.mWait);
        stringBuffer.append(':');
        stringBuffer.append(this.mFrameShot);
        stringBuffer.append(':');
        stringBuffer.append(this.mFrameHit);
        return stringBuffer.toString();
    }

    private int twBetween(AEnemy aEnemy, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = this.mLeftRot ? n3 + 3 * this.mRot : n3 - 3 * this.mRot;
        int n7 = Angle.vShotX(n6);
        int n8 = aEnemy.mMoveY8 * n7 - aEnemy.mMoveX8 * (n5 = Angle.vShotY(n6));
        if (n8 == 0) {
            return 0;
        }
        int n9 = aEnemy.mMoveX8 - n7;
        int n10 = aEnemy.mMoveY8 - n5;
        int n11 = n9 * n9 + n10 * n10;
        int n12 = (int)Math.sqrt((double)n11 + 0.5);
        int n13 = n + this.mRot * aEnemy.mMoveX8 - Angle.posShotX(n6);
        int n14 = n2 + this.mRot * aEnemy.mMoveY8 - Angle.posShotY(n6);
        int n15 = n14 * n9 - n13 * n10;
        int n16 = aEnemy.size() * n12;
        int n17 = (n15 - n16) / n8;
        int n18 = (n15 + n16) / n8;
        if (n4 < 0) {
            n4 = 0;
        }
        if (n17 < n18) {
            if (n18 < 0) {
                return -1;
            }
            if (n18 < n4) {
                return n18;
            }
            if (n4 < n17) {
                return n17;
            }
            return n4;
        }
        if (n17 < 0) {
            return -1;
        }
        if (n17 < n4) {
            return n17;
        }
        if (n4 < n18) {
            return n18;
        }
        return n4;
    }

    public int getWait() {
        return this.mWait;
    }

    public static int getX0(AEnemy aEnemy, Ship ship, int n, int n2) {
        return Operation.signX8(aEnemy.getX8(n) - ship.mX8) + n2;
    }

    public static int getY0(AEnemy aEnemy, Ship ship, int n, int n2) {
        return Operation.signY8(aEnemy.getY8(n) - ship.mY8) + n2;
    }
}

