/*
 * Decompiled with CFR 0.152.
 */
package asteroid.strategy.measure;

import asteroid.PrintWriterFormat;
import asteroid.model.AEnemy;
import asteroid.strategy.measure.AMeasure;

public class FireTime
extends AMeasure {
    private double mFakt;

    public FireTime(double d) {
        this.mFakt = d;
    }

    protected void measure(AEnemy aEnemy) {
        int n = aEnemy.getInfo().getFireTime();
        if (n > 69) {
            aEnemy.mWeight += MAX_IGNORE;
        } else if (n > 32) {
            double d = this.mFakt * (double)(n -= 32);
            aEnemy.mWeight += d;
        }
    }

    protected void print(AEnemy aEnemy, PrintWriterFormat printWriterFormat) {
        int n = aEnemy.getInfo().getFireTime();
        if (n > 69) {
            printWriterFormat.print("max");
        } else if (n > 32) {
            printWriterFormat.print(n);
            printWriterFormat.print(':');
            printWriterFormat.print((double)Math.round(1000.0 * this.mFakt * (double)n) / 1000.0);
        } else {
            printWriterFormat.print('-');
        }
        printWriterFormat.fill(20);
    }
}

