/*
 * Decompiled with CFR 0.152.
 */
package asteroid.strategy.measure;

import asteroid.PrintWriterFormat;
import asteroid.model.AEnemy;
import asteroid.model.GameModel;
import asteroid.strategy.measure.AMeasure;
import asteroid.strategy.measure.Rating;

public class Stacker
extends AMeasure {
    private AMeasure[] mMeasure;
    private PrintWriterFormat mOut;
    private Rating mStack;

    public Stacker(Rating rating, AMeasure[] aMeasureArray, PrintWriterFormat printWriterFormat) {
        this.mStack = rating;
        this.mMeasure = aMeasureArray;
        this.mOut = printWriterFormat;
    }

    protected void measure(AEnemy aEnemy) {
        if (aEnemy.isVisible()) {
            if (this.mOut != null) {
                this.mOut.savePos();
                this.mOut.print(aEnemy.getID());
                this.mOut.fill(8);
            }
            aEnemy.mWeight = 0.0;
            for (int i = 0; i < this.mMeasure.length; ++i) {
                this.mMeasure[i].measure(aEnemy);
                if (this.mOut == null) continue;
                this.mMeasure[i].print(aEnemy, this.mOut);
            }
            if (this.mOut != null) {
                this.mOut.println();
            }
        } else {
            aEnemy.mWeight = MAX_IGNORE;
        }
        this.mStack.change(aEnemy);
    }

    protected void print(AEnemy aEnemy, PrintWriterFormat printWriterFormat) {
    }

    public void refresh(GameModel gameModel) {
        if (this.mOut != null) {
            this.mOut.println(GameModel.sFrame);
        }
        this.mStack.reset();
        gameModel.forUfo(this);
        gameModel.forAllAsteroids(this);
    }
}

