/*
 * Decompiled with CFR 0.152.
 */
package asteroid.udp;

import asteroid.SimpleLogging;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class GameSaver
implements Runnable {
    private FileChannel mChannel;
    private ByteBuffer mKey = ByteBuffer.allocate(1);

    public GameSaver() {
        Runtime.getRuntime().addShutdownHook(new Thread(this));
    }

    private void close() {
        if (this.mChannel != null) {
            try {
                this.mChannel.close();
                this.mChannel = null;
            }
            catch (Exception exception) {
                System.err.println("exception: " + exception.getMessage());
            }
        }
    }

    static ByteBuffer createHeader(InetAddress inetAddress, int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(57);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put("ctmame".getBytes());
        byteBuffer.put((byte)50);
        byteBuffer.put((byte)13);
        byteBuffer.put((byte)10);
        byteBuffer.putShort((short)2);
        byteBuffer.putShort((short)n);
        try {
            if (inetAddress != null) {
                inetAddress = InetAddress.getLocalHost();
            }
            byteBuffer.put(inetAddress.getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            SimpleLogging.addException(unknownHostException);
            byteBuffer.put(new byte[]{127, 0, 0, 1});
        }
        for (int i = 0; i < 8; ++i) {
            byteBuffer.put((byte)0);
        }
        byte[] byArray = "eraser".getBytes();
        byteBuffer.put(byArray);
        for (int i = byArray.length; i < 32; ++i) {
            byteBuffer.put((byte)0);
        }
        byteBuffer.clear();
        return byteBuffer;
    }

    public void setOutput(String string, InetAddress inetAddress, int n) {
        this.close();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            this.mChannel = fileOutputStream.getChannel();
            this.mChannel.write(GameSaver.createHeader(inetAddress, n));
        }
        catch (IOException iOException) {
            SimpleLogging.addException(iOException);
            this.close();
        }
    }

    public void run() {
        this.close();
    }

    public void writeData(ByteBuffer byteBuffer) {
        try {
            if (this.mChannel != null) {
                ByteBuffer byteBuffer2 = byteBuffer.duplicate();
                byteBuffer2.rewind().limit(1024);
                this.mChannel.write(byteBuffer2);
            }
        }
        catch (Exception exception) {
            SimpleLogging.addException(exception);
            this.close();
        }
    }

    public void writeKey(int n) {
        try {
            if (this.mChannel != null) {
                this.mKey.clear();
                this.mKey.put(0, (byte)n);
                this.mChannel.write(this.mKey);
            }
        }
        catch (Exception exception) {
            SimpleLogging.addException(exception);
            this.close();
        }
    }
}

