package asteroid.printer;

import java.io.PrintStream;

import asteroid.model.AFlyable;
import asteroid.model.Asteroid;
import asteroid.model.FlyInfo;
import asteroid.model.GameModel;
import asteroid.model.Ship;
import asteroid.model.Shot;
import asteroid.model.Ufo;

public class AnalyseHit1 extends APrinter {
	private GameModel mModel;

	public AnalyseHit1( GameModel model, PrintStream ps) {
		super( ps);
		mModel = model;
	}

	public AnalyseHit1( GameModel model, String file) {
		super( file);
		mModel = model;
	}

	public void forAsteroid( Asteroid ast) {
		forFlyable( ast);
	}

	void forFlyable( AFlyable fly) {
		if (fly.getVanish() > 0) {
			mOut.savePos();
			mOut.print( fly.getIdent());
			mOut.print( ':');
			mOut.print( fly.getX8());
			mOut.print( ',');
			mOut.print( fly.getY8());
			mOut.print( ',');
			mOut.print( fly.getZ());
			mOut.print( ',');
			mOut.print( fly.getMoveX8());
			mOut.print( ',');
			mOut.print( fly.getMoveY8());
			mOut.print( ',');
			mOut.print( fly.getVanish());
			mOut.fill( 26);
		}
	}

	public void forShip( Ship ship) {
		forFlyable( ship);
	}

	public void forShot( Shot shot) {
		if (shot.getVanish() > 0) {
			mOut.savePos();
			mOut.print( shot.getIdent());
			mOut.print( ':');
			FlyInfo last = shot.getLast();
			mOut.print( last.getX8());
			mOut.print( ',');
			mOut.print( last.getY8());
			mOut.print( ',');
			mOut.print( shot.getZ());
			mOut.print( ',');
			mOut.print( last.getMoveX8());
			mOut.print( ',');
			mOut.print( last.getMoveY8());
			mOut.print( ',');
			mOut.print( shot.getVanish());
			mOut.fill( 26);
		}
	}

	public void forUfo( Ufo ufo) {
		forFlyable( ufo);
	}

	public void print() {
		if (mModel.isVanished()) {
			mOut.savePos();
			mOut.print( "Frame ");
			mOut.print( GameModel.sFrame);
			mOut.fill( 16);
//			mOut.printKey( mKey);
			mOut.fill( 10);
			mModel.forShip( this);
			mModel.forUfo( this);
			mModel.forAllAsteroids( this);
			mModel.forAllShots( this);
			mOut.println();
		}
	}
}
