package asteroid.printer;

import asteroid.model.AFlyable;
import asteroid.model.Asteroid;
import asteroid.model.Ship;
import asteroid.model.Shot;
import asteroid.model.Ufo;

class Remember {
	boolean mActive, mExplosion;
	int mMoveX8, mMoveY8;
	int mX8, mY8, mZ, mType;

	public boolean isActive() {
		return mActive;
	}

	public boolean isExplosion() {
		return mActive && mExplosion;
	}

	public void saveAsteroid( Asteroid ast) {
		saveFlyable( ast);
		mActive = ast.isVisible();
		mExplosion = ast.isExplosion();
		mType = ast.getType();
	}

	public void saveFlyable( AFlyable fly) {
		mX8 = fly.getX8();
		mY8 = fly.getY8();
		mZ = fly.getZ();
		mMoveX8 = fly.getMoveX8();
		mMoveY8 = fly.getMoveY8();
	}

	public void saveShip( Ship ship) {
		saveFlyable( ship);
		mActive = ship.isVisible();
		mType = ship.getType();
	}

	public void saveShot( Shot shot) {
		saveFlyable( shot);
		mActive = shot.isVisible();
	}

	public void saveUfo( Ufo ufo) {
		saveFlyable( ufo);
		mActive = ufo.isVisible();
		mExplosion = ufo.isExplosion();
		mType = ufo.getType();
	}

	public boolean isVisible() {
		return mActive && !mExplosion;
	}
}
