package asteroid.strategy.measure;

import asteroid.PrintWriterFormat;
import asteroid.model.AEnemy;

public class Modify extends AMeasure {
	private static final int MIN_MODIFY = 4;
	private double mModWeight;

	public Modify( double modWeight) {
		mModWeight = modWeight;
	}

	protected void measure( AEnemy enemy) {
		if (enemy.getModify() < MIN_MODIFY) {
			enemy.mWeight += mModWeight * (MIN_MODIFY - enemy.getModify());
		}
	}

	protected void print( AEnemy enemy, PrintWriterFormat out) {
		if (enemy.getModify() < MIN_MODIFY) {
			out.print( enemy.getModify());
		}
		else {
			out.print( '-');
		}
		out.fill( 10);
	}
}
