package asteroid.udp;

import java.nio.ByteBuffer;

import asteroid.SimpleLogging;

class BlockedFiFo extends AReceiveFiFo {
	BlockedFiFo( int latenz) {
		super( latenz);
	}

	public synchronized ByteBuffer nextRead( boolean blocked) {
		while ((mWrite <= mLatenz) && blocked) {
			waitFor();
		}
		if ((mWrite <= mLatenz) || !blocked) {
			return null;
		}
		ByteBuffer data = mBuff[0];
		moveRead();
		notifyAll();
		return data;
	}

	public synchronized ByteBuffer nextWrite() {
		while (mWrite > mLatenz) {
			waitFor();
		}
		return mBuff[mWrite];
	}

	public synchronized void received() {
		if (frameOrder()) {
			moveWrite();
		}
		notifyAll();
	}

	private void waitFor() {
		try {
			wait();
		}
		catch (InterruptedException ex) {
			SimpleLogging.addException( ex);
		}
	}
}
