﻿using System;

namespace PlayerLogic
{
    [BehaviourAttribute("Alpha")]
    public class Alpha : Behaviour
    {
        private int tick = 0;
        private int fav_x = 0;
        private int fav_y = 0;
        private bool hasFired = false;

        public override byte AnalyzeFrame(GameStatus game, int frameFactor, FeedbackTarget feedback)
        {
            byte keys = 0;
            int min_dist = 0x7fffffff;
            int min_asteroid_dist = min_dist;
            int min_idx = -1;
            int min_dx = 0;
            int min_dy = 0;
            int framesToFire = 0;
            int minCollisionIdx = -1;
            double minCollisionDist = 10*60*60;

            if (game.hasShip)
            {
                for (int i = 0; i < game.numAsteroids; ++i)
                {   // nächstgelegenen Asteroiden suchen
                    if (!game.asteroids[i].HasDirection || !game.asteroids[i].IsHit)
                    {
	                    int dx = Utility.normalizeX(game.asteroids[i].X - game.shipX);
	                    int dy = Utility.normalizeY(game.asteroids[i].Y - game.shipY);
                        int dist = (int)(Math.Sqrt((double)dx * dx + (double)dy * dy) + 0.5 - game.asteroids[i].Radius);
                        if (dist < min_asteroid_dist)
                        {
                            min_asteroid_dist = dist;
                        }
                        Utility.InterceptCorrection2(game, dx, dy,
                                        game.asteroids[i].DX, game.asteroids[i].DY,
                                        out dx, out dy, out framesToFire);
                        dx = Utility.normalizeX(dx);
                        dy = Utility.normalizeY(dy);
                        dist = (int)((Math.Sqrt((double)dx * dx + (double)dy * dy) - game.asteroids[i].Radius) / 8 + 2 + 0.5);
                        if ( dist < 72 )
                        {
                            double angle = Utility.AngleBetween(dx, dy, game.shipAX, game.shipAY) / Utility.PI128;
                            dist = dist + (int)Math.Abs(angle) / 3;
                            if (dist < min_dist)
                            {
                                min_dist = dist;
                                min_idx = i;
                                min_dx = dx;
                                min_dy = dy;
                                fav_x = dx;
                                fav_y = dy;
                            }
                        }
                        double collDist = Utility.CalculateNextCollisionDistance(dx, dy, game.asteroids[i].DX, game.asteroids[i].DY, 0, 0, 27 + game.asteroids[i].Radius);
                        if (collDist >= 0 && collDist < 180 && collDist < minCollisionDist)
                        {
                            minCollisionDist = collDist;
                            minCollisionIdx = i;
                        }
                    }
                }

                if (minCollisionIdx>=0)
                {
                    min_dx = Utility.normalizeX(game.asteroids[minCollisionIdx].X - game.shipX);
                    min_dy = Utility.normalizeY(game.asteroids[minCollisionIdx].Y - game.shipY);
                    Utility.InterceptCorrection2(game, min_dx, min_dy,
                                        game.asteroids[minCollisionIdx].DX, game.asteroids[minCollisionIdx].DY,
                                        out min_dx, out min_dy, out framesToFire);
                    min_dx = Utility.normalizeX(min_dx);
                    min_dy = Utility.normalizeY(min_dy);
                    min_idx = minCollisionIdx;
                }

                if (min_idx >= 0 && game.asteroids[min_idx].HasDirection)
                {
                    // move target position to compensate time for bullets to reach target
                    //Utility.InterceptCorrection2(game, min_dx, min_dy,
                    //                    game.asteroids[min_idx].DX, game.asteroids[min_idx].DY,
                    //                    out min_dx, out min_dy, out framesToFire);
                    game.targetX = game.asteroids[min_idx].X;
                    game.targetY = game.asteroids[min_idx].Y;
                    game.interceptX = game.shipX + min_dx;
                    game.interceptY = game.shipY + min_dy;
                }

                if (game.hasSaucer && !game.saucer.IsHit)
                {
                    int dx = Utility.normalizeX(game.saucer.X - game.shipX);
                    int dy = Utility.normalizeY(game.saucer.Y - game.shipY);
                    int dist = (int)(Math.Sqrt((double)dx * dx + (double)dy * dy) + 0.5);
                    dist -= (int)game.saucer.Radius;
                    //                        if (dist < min_dist)
                    {
                        if (dist < min_asteroid_dist)
                        {
                            min_asteroid_dist = dist;
                        }
                        min_dx = dx;
                        min_dy = dy;
                        if (game.hadSaucer)
                        {
                            Utility.InterceptCorrection2(game, min_dx, min_dy,
                                                game.saucer.DX, game.saucer.DY,
                                                out min_dx, out min_dy, out framesToFire);
                        }
                    }
                    game.targetX = game.saucer.X;
                    game.targetY = game.saucer.Y;
                    game.interceptX = game.shipX + min_dx;
                    game.interceptY = game.shipY + min_dy;
                    min_idx = -1;
                }

                game.framesToFire = (int)game.frameNumber;

                double w = Utility.AngleBetween(min_dx, min_dy, game.shipEX, game.shipEY) / Utility.PI128;
                if (w >= 3.0)
                {
                    if (game.shipEX * min_dy - game.shipEY * min_dx > 0)
                        keys |= KEY_LEFT;
                    else
                        keys |= KEY_RIGHT;
                }

                if (!hasFired)
                {
                    if (game.WillHitSomething())
                    {
                        keys |= KEY_FIRE;
                        hasFired = true;
                    }
                }
                else
                {
                    hasFired = false;
                }

                if (/*min_dist < 27 ||*/ min_asteroid_dist < 27 || game.hasCriticalBullet)
                {
                    // Flucht, wenn Kollision oder Abschuss unausweichlich
                    keys |= KEY_HYPERSPACE;
                    feedback.HyperSpaceReason = (game.hasCriticalBullet ? "CBL" : "MDR");
                }
            }
            return keys;
        }
    }
}
