﻿
namespace PlayerLogic
{
    public struct Asteroid : GameObject
    {
        private int x;
        private int y;
        private int type;
        private int size;
        private bool hasDirection;
        private bool isHit;
        private double dx;
        private double dy;

        public int Size
        {
            get { return size; }
            set { size = value; }
        }

        public int Type
        {
            get { return type; }
            set { type = value; }
        }

        #region GameObject Members

        public int X
        {
            get
            {
                return x;
            }
            set
            {
                x = value;
            }
        }

        public int Y
        {
            get
            {
                return y;
            }
            set
            {
                y = value;
            }
        }

        public bool HasDirection
        {
            get
            {
                return hasDirection;
            }
            set
            {
                hasDirection = value;
            }
        }

        public bool IsHit
        {
            get
            {
                return isHit;
            }
            set
            {
                isHit = value;
            }
        }

        public double DX
        {
            get
            {
                return dx;
            }
            set
            {
                dx = value;
            }
        }

        public double DY
        {
            get
            {
                return dy;
            }
            set
            {
                dy = value;
            }
        }

        public double Radius
        {
//            get { return Size == 0 ? 40 : (Size == 15 ? 20 : 8); }
            get { return Size == 0 ? 33.0 : (Size == 15 ? 18.0 : 10.5); } // should be 10.5, 18, 33
        }

        #endregion
    }
}
