﻿using System;

[AttributeUsage(AttributeTargets.Class)]
public class BehaviourAttribute : Attribute
{
    private readonly string name;

    public BehaviourAttribute(string name)
    {
        this.name = name;
    }

    public string Name
    {
        get { return name; }
    }

    public override string ToString()
    {
        return string.Format("Is {0} Behavior", name);
    }
}
