﻿
namespace PlayerLogic
{
    public struct Bullet : GameObject
    {
        private int x;
        private int y;
        private bool hasDirection;
        public bool IsDangerous;
        public bool FromSaucer;
        public int LifeCounter;
        private double dx;
        private double dy;
        public int FramesLeft { get { return LifeCounter >= 70 ? 0 : 70 - LifeCounter; } }

        #region GameObject Members

        public int X
        {
            get
            {
                return x;
            }
            set
            {
                x = value;
            }
        }

        public int Y
        {
            get
            {
                return y;
            }
            set
            {
                y = value;
            }
        }

        public bool HasDirection
        {
            get
            {
                return hasDirection;
            }
            set
            {
                hasDirection = value;
            }
        }

        public bool IsHit
        {
            get
            {
                return false;
            }
            set
            {
            }
        }

        public double DX
        {
            get
            {
                return dx;
            }
            set
            {
                dx = value;
            }
        }

        public double DY
        {
            get
            {
                return dy;
            }
            set
            {
                dy = value;
            }
        }

        public double Radius
        {
            get { return 1; }
        }

        #endregion
    }

}
