#include "log.h"
#include <stdio.h>
#include <time.h>


#define DEF_LINE_LENGTH 70

//global variables
static FILE* plog = NULL;
static DWORD g_indention = 0;


void log_init(const char* name)
{
	char logname[256] = {0};
	DWORD linelength = DEF_LINE_LENGTH;
	DWORD pre = 0;
	DWORD post = 0;
	SYSTEMTIME systime;

	if(NULL == plog)
	{
		if(NULL == name)
		{
			name = "log";
		}
		else
		{
			// DO NOTHING HERE
		}

		GetSystemTime( &systime );
		_snprintf_s(logname
					, sizeof(logname)
					, ".\\%s_%d%d%d_%d%d%d.log"
					, name
					, systime.wYear
					, systime.wMonth
					, systime.wDay
					, systime.wHour
					, systime.wMinute
					, systime.wSecond
					);

		fopen_s(&plog,logname, "w");

		if(NULL != plog)
		{
			pre = (strlen(name) + 8) / 2;
			pre = (linelength / 2) - pre;
			pre -= 3;
	
			post = (strlen(name) + 8) / 2;
			post = (linelength / 2) - post;
			
			post += linelength - (pre + post + (strlen(name) + 8) + 2);

			for(DWORD i = 0; i < linelength; i++)
				fprintf(plog,"%s", "*");
			fprintf(plog,"\n");

			fprintf(plog,"*%*s%s", pre, "", name);
			fprintf(plog," logfile%*s*\n", post, "");
			fprintf(plog,"*");

			pre = 33 / 2;
			pre = (linelength / 2) - pre;
			pre -= 4;
	
			post = 33 / 2;
			post = (linelength / 2) - post;
			
			post += linelength - (pre + post + 33 + 2);

			fprintf(plog,"%*sDate: %d-%02d-%02d   Time: %02d:%02d:%02d%*s*\n"
					, pre
					, ""
					, systime.wYear
					, systime.wMonth
					, systime.wDay
					, systime.wHour
					, systime.wMinute
					, systime.wSecond
					, post
					, "");

			for(DWORD j = 0; j < linelength; j++)
				fprintf(plog,"%s", "*");
			fprintf(plog,"\n\n");


		}
		else
		{
			// DO NOTHING HERE
		}
	}
	else
	{
		// DO NOTHING HERE
	}
}


void log_exit()
{
	if(NULL != plog)
	{
		fprintf(plog, "\n-----   END OF LOG   -----\n\n");
		fclose(plog);
		plog = NULL;
	}
	else
	{
		// DO NOTHING HERE
	}
}


void log_function(const char* name, DWORD threadid)
{
	if(NULL == plog)
		log_init(NULL);
		
	if(NULL != plog)
	{
		log_indent(g_indention);
		fprintf(plog,"%s (ThreadID: %d)",(NULL != name)?name:"", threadid);
		log_newline();
	}
	else
	{
		// DO NOTHING HERE
	}
}


void log_type_data(const char* name, const void*lpdata, DWORD len)
{
	DWORD index = 0;

	if(NULL == plog)
		log_init(NULL);
		
	if(NULL != plog)
	{
		log_indent(g_indention);
		fprintf(plog,"%s:", (NULL != name)?name:"");

		if(NULL != lpdata)
		{
			for(index = 0; index < len; index++)
			{
				if(0 == (index % 8))
				{
					log_newline();
					log_indent(g_indention);
					log_indent(5);
				}
				else
				{
					// DO NOTHING HERE
				}
				
				fprintf(plog, "%02x ", ((LPBYTE)lpdata)[index]);
			}
			log_newline();
		}
		else
		{
			// DO NOTHING HERE
		}
	}
	else
	{
		// DO NOTHING HERE
	}
}


void log_type_text(const char* name, const char* ptext)
{
	if(NULL == plog)
		log_init(NULL);
		
	if(NULL != plog)
	{
		log_indent(g_indention);
		fprintf(plog,"%s: %s", (NULL != name)?name:"", (NULL != ptext)?ptext:"");
		log_newline();
	}
	else
	{
		// DO NOTHING HERE
	}
}


void log_type_unsigned(const char* name, unsigned int value)
{
	if(NULL == plog)
		log_init(NULL);
		
	if(NULL != plog)
	{
		log_indent(g_indention);
		fprintf(plog,"%s: %08x (%u)",(NULL != name)?name:"", value, value);
		log_newline();
	}
	else
	{
		// DO NOTHING HERE
	}
}


void log_type_signed(const char* name, int value)
{
	if(NULL == plog)
		log_init(NULL);
		
	if(NULL != plog)
	{
		log_indent(g_indention);
		fprintf(plog,"%s: %08x (%d)",(NULL != name)?name:"", value, value);
		log_newline();
	}
	else
	{
		// DO NOTHING HERE
	}
}


void log_newline()
{
	if(NULL == plog)
		log_init(NULL);
		
	if(NULL != plog)
	{
		fprintf(plog,"\n");
		fflush(plog);
	}
	else
	{
		// DO NOTHING HERE
	}
}


void log_indent(DWORD count)
{
	if(NULL == plog)
		log_init(NULL);
		
	if(NULL != plog)
	{
		if(0 != count)
		{
			fprintf(plog,"%*s", count, "");
		}
		else
		{
			// DO NOTHING HERE
		}
	}
	else
	{
		// DO NOTHING HERE
	}
}


void log_set_indention(DWORD indention)
{
	g_indention = indention;
}