﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Net;
using System.Net.Sockets;
using System.Drawing;


namespace AKTGR_Asteroids
{
    public class Player1
    {
        private Connection connection;
        private string name;
        private Graphics myG;
        private VectorMachine vm;
        private GameStatus game;
        private Boolean doGraphics;
        private Boolean doVectors;
        private Boolean doText;
        private Form1 myF;
        private Boolean doKeys;
        private Boolean doTarget;

        public Player1()
        {
            connection = new Connection();
            name = "Player1";
            doGraphics = false;
            doVectors = false;
            doText = false;
            doKeys = true;
        }

        public Player1(Connection connection)
        {
            this.connection = connection;
            this.name = "Player1";
            doGraphics = false;
            doVectors = false;
            doText = false;
            doKeys = true;
        }

        public Player1(Connection connection, string name)
        {
            this.connection = connection;
            this.name = name;
            doGraphics = false;
            doVectors = false;
            doText = false;
            doKeys = true;
        }

        public Player1(Connection connection, string name, Graphics g)
        {
            this.connection = connection;
            this.name = name;
            this.myG = g;
            doGraphics = true;
            doVectors = false;
            doText = false;
            doKeys = true;
        }

        public Player1(Connection connection, string name, Graphics g, Form1 f)
        {
            this.connection = connection;
            this.name = name;
            this.myG = g;
            this.myF = f;
            myF.actBooleans(ref doGraphics, ref doVectors, ref doText, ref doKeys, ref doTarget);
            myF.addText("Player created!");
        }

        internal void Run()
        {
            FramePacket frame = new FramePacket();
            KeysPacket keys = new KeysPacket();
            FlyingObject[] targets;
            FlyingObject[] objects;
            game = new GameStatus();

            char prevframe = (char)0;
            int t = 0;

            int sx;
            int sy;

            keys.clear();
            while (true)
            {
                Thread.Sleep(1);
                ++t;         // Zeit
                ++keys.ping; // jedes gesendete Päckchen erhält eine individuelle Nummer zur Latenzmessung
                if (keys.ping > 255) keys.ping = (char)0;
                connection.SendPacket(keys, name);
                frame = connection.ReceivePacket();

                if (frame == null) continue;

                if (doText)
                {
                    myF.actText(Convert.ToByte(frame.frameno).ToString());
                }

                if (frame.frameno != ++prevframe || frame.ping != keys.ping)
                {
                    if (doText)
                    {
                        //Console.WriteLine("Latenz " + (keys.ping - frame.ping).ToString() + ". " + (frame.frameno - prevframe).ToString() + " Frames verloren.\n");
                        myF.actText(Convert.ToByte(frame.frameno).ToString(), (keys.ping - frame.ping).ToString(), (frame.frameno - prevframe).ToString());
                    }

                    prevframe = frame.frameno;
                }

                myF.actBooleans(ref doGraphics, ref doVectors, ref doText, ref doKeys, ref doTarget);
                if (frame == null)
                    continue;
                if (frame.GameOver)
                {
                    if (doText == true)
                    {
                        //Console.WriteLine("Game Over");
                        myF.addText("Game over");
                    }
                    Exception e;
                    e = frame.Exception;
                    if (e != null)
                    {
                        if (doText == true)
                        {
                            //Console.WriteLine("Exception(s) caught:");
                            myF.addText("Exception(s) caught:");
                        }
                        while (e != null)
                        {
                            if (doText == true)
                            {
                                //Console.WriteLine("Exception-Message: {0}", e.Message);
                                myF.addText("Exception-Message:" + e.Message);
                            }
                            e = e.InnerException;
                        }
                    }
                    return;
                }
                keys.clear();
                if (doGraphics)
                {
                    if (myG != null)
                    {
                        if (vm == null)
                            vm = new VectorMachine(myG);
                    }
                    vm.drawArray(myG, frame.vectorram2);
                }
                this.InterpretScreen(frame, game);
                int min_dist = 0x7fffffff;
                int min_dx = 0;
                int min_dy = 0;
                if (game.ship_present)
                {
                    //for (int i = 0; i < game.nasteroids; ++i)
                    //{   // nächstgelegenen Asteroiden suchen
                    //    int dx = game.asteroids[i].x - game.ship_x;
                    //    while (dx < -512) dx += 1024; // dx normalisieren auf -512 ... 511
                    //    while (dx > 511) dx -= 1024;
                    //    int dy = game.asteroids[i].y - game.ship_y;
                    //    while (dy < -384) dy += 768;  // dy normalisieren auf -384 ... 383
                    //    while (dy > 383) dy -= 768;
                    //    int dist = dx * dx + dy * dy;  // Quadrat des Abstands zu diesem Asteroiden
                    //    switch (game.asteroids[i].sf)
                    //    {	// Abstand um den ungefähren Radius des Asteroiden korrigieren
                    //        case 0:  // großer Asteroid
                    //            dist -= 40 * 40;
                    //            break;
                    //        case 15: // mittlerer Asteroid
                    //            dist -= 20 * 20;
                    //            break;
                    //        case 14: // kleiner Asteroid
                    //            dist -= 8 * 8;
                    //            break;
                    //    }
                    //    if (dist < min_dist)
                    //    {
                    //        min_dist = dist;
                    //        min_dx = dx;
                    //        min_dy = dy;
                    //    }
                    //}
                    //if (game.saucer_present)
                    //{
                    //    int dx = game.saucer_x - game.ship_x;
                    //    while (dx < -512) dx += 1024;
                    //    while (dx > 511) dx -= 1024;
                    //    int dy = game.saucer_y - game.ship_y;
                    //    while (dy < -384) dy += 768;
                    //    while (dy > 383) dy -= 768;
                    //    int dist = dx * dx + dy * dy;
                    //    switch (game.saucer_size)
                    //    {	// Abstand um den ungefähren Radius des UFOs korrigieren
                    //        case 15: // großes UFO
                    //            dist -= 20 * 12;
                    //            break;
                    //        case 14: // kleines UFO
                    //            dist -= 10 * 6;
                    //            break;
                    //    }
                    //    if (dist < min_dist)
                    //    {
                    //        min_dist = dist;
                    //        min_dx = dx;
                    //        min_dy = dy;
                    //    }
                    //}

                    // Schiff in Richtung auf das nächstgelegene Objekt drehen
                    // mathematisch wird hier das Kreuzprodukt aus den Vektoren 
                    // ship_dx/y/0 und min_dx/y/0 berechnet

                    if (game.nTargets > 0)
                    {
                        targets = new FlyingObject[game.nTargets];
                        for (int i = 0; i < game.nTargets; i++)
                        {
                            targets[i] = game.targets[i];
                        }
                        objects = new FlyingObject[game.nFlyingObjects];
                        for (int i = 0; i < game.nFlyingObjects; i++)
                        {
                            objects[i] = game.flyingObjects[i];
                        }
                        FlyingObject.defcon = 1;
                        Array.Sort(targets);
                        FlyingObject.defcon = 0;
                        Array.Sort(objects);
                        if (targets[0] != null)
                        {
                            min_dy = targets[0].ndy;
                            min_dx = targets[0].ndx;
                            min_dist = targets[0].distance;
                            if (doTarget && doGraphics)
                            {
                                vm.DrawCircle(myG, Color.Orange, targets[0].x, targets[0].y, 46, 46);
                            }
                            for (int i = 0; i < game.nFlyingObjects; i++)
                            {
                                if (objects[i].distance < 80 * 80)
                                {
                                    if (doTarget && doGraphics)
                                    {
                                        vm.DrawCircle(myG, Color.Yellow, objects[i].x, objects[i].y, 40, 40);
                                    }
                                    if (objects[i].distance < 30 * 30 && objects[i].distance > 0)
                                    {
                                        if (doKeys) keys.hyperspace(true);
                                    }
                                }
                                if (objects[i].ObjType == "SHOT")
                                {
                                    if (doTarget && doGraphics)
                                    {
                                        vm.DrawCircle(myG, Color.Yellow, objects[i].x, objects[i].y, 40, 40);
                                        if (objects[i].distance < 35 * 35 && objects[i].distance > 0)
                                        {
                                            if (doKeys) keys.hyperspace(true);
                                        }
                                    }
                                }
                            }
                            double direction;
                            direction = (game.ship_dx * min_dy - game.ship_dy * min_dx);
                            if (direction > 0)
                            {
                                if (doKeys) keys.left(true);
                            }

                            else
                            {
                                if (doKeys) keys.right(true);
                            }
                            if (t % 4 == 0 && min_dist > 400 * 400 && game.nasteroids < 2 && game.saucer_present == false) // beschleunigen, wenn nichts in der Nähe
                            {
                                //if (doKeys) keys.hyperspace(true);
                            }
                            if (t % 2 == 0 && ((min_dist < 400 * 400) || targets[0].ObjType == "UFO"))  // Feuerknopf drücken, so schnell es geht
                            {
                                sx = 0;
                                sy = 0;
                                {
                                    if (doKeys) keys.fire(true);
                                }
                            }
                        }
                    }
                }
            }

        }


        private void InterpretScreen(FramePacket packet, GameStatus game)
        {
            ushort[] vector_ram = packet.vectorram2;
            int dx;
            int dy;
            int sf;
            int vx = 0;
            int vy = 0, vz = 0, vs = 0;
            int v1x = 0;
            int v1y = 0;
            int shipdetect = 0;
            int i;
            int max_acc_x = 200;
            int max_acc_y = 100;
            game.clear();
            if (packet.vectorram[1] != 0xe0 && packet.vectorram[1] != 0xe2)
                return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL

            int pc = 1;
            for (; pc < 513; )
            {
                int op = vector_ram[pc] >> 12; ;
                switch (op)
                {
                    case 0xa: // LABS
                        vy = vector_ram[pc] & 0x3ff;
                        vx = vector_ram[pc + 1] & 0x3ff;
                        vs = vector_ram[pc + 1] >> 12;
                        break;
                    case 0xb: // HALT
                        if (game.nasteroids > 0)
                        {
                            if (game.nasteroids == game.nasteroids_old)
                            {
                                for (i = 0; i < game.nasteroids; i++)
                                {
                                    if (game.asteroids[i].type == game.asteroids_old[i].type &&
                                        game.asteroids[i].sf == game.asteroids_old[i].sf)
                                    {
                                        if (Mathematicus.vectorGen(game.asteroids[i], game.asteroids_old[i], game.ship_x, game.ship_y, true))
                                        {
                                            game.targets[game.nTargets++] = game.asteroids[i];
                                        }
                                        if (doGraphics && doVectors)
                                        {
                                            vm.drawDirectionVector(myG, Color.AliceBlue,
                                                                   game.asteroids[i].x,
                                                                   game.asteroids[i].y,
                                                                   game.asteroids[i].dx * 10,
                                                                   game.asteroids[i].dy * 10);
                                        }
                                    }
                                    game.flyingObjects[game.nFlyingObjects++] = game.asteroids[i];
                                }
                            }
                        }
                        if (game.nshots > 0)
                        {
                            {
                                int x1;
                                int x2;
                                int y1;
                                int y2;
                                for (int i2 = 0; i2 < game.nshots; i2++)
                                {
                                    Boolean shot_matched = false;
                                    game.shots[i2].from_enemy = false;
                                    for (int j2 = 0; j2 < game.nshots_old; j2++)
                                    {
                                        if (game.shots_old[j2] != null)
                                        {
                                            if (game.shots[i2].x > game.shots_old[j2].x)
                                            {
                                                x1 = game.shots[i2].x;
                                                x2 = game.shots_old[j2].x;
                                            }
                                            else
                                            {
                                                x1 = game.shots_old[j2].x;
                                                x2 = game.shots[i2].x;
                                            }
                                            if (game.shots[i2].y > game.shots_old[j2].y)
                                            {
                                                y1 = game.shots[i2].y;
                                                y2 = game.shots_old[j2].y;
                                            }
                                            else
                                            {
                                                y1 = game.shots_old[j2].y;
                                                y2 = game.shots[i2].y;
                                            }
                                            if (x1 - x2 <= 10 && y1 - y2 <= 10)
                                            {
                                                if (Mathematicus.vectorGen(game.shots[i2], game.shots_old[j2], game.ship_x, game.ship_y, false)) { }
                                                shot_matched = true;
                                                game.shots_old[j2] = null;
                                                j2 = game.nshots_old;
                                            }
                                        }
                                    }
                                    if (shot_matched)
                                    {
                                        if (doGraphics && doVectors)
                                        {
                                            vm.drawDirectionVector(myG, Color.AliceBlue,
                                                                   game.shots[i2].x,
                                                                   game.shots[i2].y,
                                                                   game.shots[i2].dx * 10,
                                                                   game.shots[i2].dy * 10);
                                        }
                                    }
                                    else
                                    {
                                        if (game.saucer_present)
                                        {

                                            if (game.shots[i2].x > game.saucer_x)
                                            {
                                                x1 = game.shots[i2].x;
                                                x2 = game.saucer_x;
                                            }
                                            else
                                            {
                                                x2 = game.shots[i2].x;
                                                x1 = game.saucer_x;
                                            }
                                            if (game.shots[i2].y > game.saucer_y)
                                            {
                                                y1 = game.shots[i2].y;
                                                y2 = game.saucer_y;
                                            }
                                            else
                                            {
                                                y2 = game.shots[i2].y;
                                                y1 = game.saucer_y;
                                            }
                                            if (x1 - x2 <= 40 && y1 - y2 <= 40)
                                            {
                                                game.shots[i2].from_enemy = true;
                                            }
                                            else
                                            {
                                                game.shots[i2].from_enemy = false;
                                            }
                                        }
                                        else
                                        {
                                            game.shots[i2].from_enemy = false;
                                        }
                                    }
                                    if (game.shots[i2].from_enemy)
                                    {
                                        game.flyingObjects[game.nFlyingObjects++] = game.shots[i2];
                                    }
                                }
                            }
                        }
                        if (game.saucer_present)
                        {
                            if (game.saucer_old_x != 0 || game.saucer_old_y != 0)
                            {
                                if (Mathematicus.vectorGen(game.saucer, game.saucer_old, game.ship_x, game.ship_y, true))
                                {
                                    game.targets[game.nTargets++] = game.saucer;
                                }
                                if (doGraphics && doVectors)
                                {
                                    vm.drawDirectionVector(myG, Color.AliceBlue,
                                                           game.saucer.x,
                                                           game.saucer.y,
                                                           game.saucer.dx * 10,
                                                           game.saucer.dy * 10);
                                }
                                game.flyingObjects[game.nFlyingObjects++] = game.saucer;
                            }
                        }
                        if (game.ship_present)
                        {
                            if (game.ship_old_x != 0 || game.ship_old_y != 0)
                            {
                                if (Mathematicus.vectorGen(game.ship, game.ship_old, game.ship_x, game.ship_y, false))
                                {
                                    //game.targets[game.nTargets++] = game.ship;
                                }
                                if (doGraphics && doVectors)
                                {
                                    vm.drawDirectionVector(myG, Color.AliceBlue,
                                                           game.ship.x,
                                                           game.ship.y,
                                                           game.ship.dx * 10,
                                                           game.ship.dy * 10);
                                }
                                game.ship.angle = Mathematicus.calcAngle(game.ship_x, game.ship_y, game.ship_dx, game.ship_dy);
                                if (doText)
                                {
                                    myF.actAngle(game.ship.angle.ToString());
                                }
                            }
                        }
                        return;
                    case 0xc: // JSRL
                        switch (vector_ram[pc] & 0xfff)
                        {
                            case 0x8f3:
                                game.asteroids[game.nasteroids++].set(vx, vy, 1, vs);
                                break;
                            case 0x8ff:
                                game.asteroids[game.nasteroids++].set(vx, vy, 2, vs);
                                break;
                            case 0x90d:
                                game.asteroids[game.nasteroids++].set(vx, vy, 3, vs);
                                break;
                            case 0x91a:
                                game.asteroids[game.nasteroids++].set(vx, vy, 4, vs);
                                break;
                            case 0x929:
                                game.saucer_present = true;
                                game.saucer_x = vx;
                                game.saucer_y = vy;
                                game.saucer_size = vs;
                                game.saucer.set(vx, vy, vs);
                                break;
                        }
                        break;
                    case 0xd: // RTSL
                        return;
                    case 0xe: // JMPL
                        /*
                        pc = vector_ram[pc] & 0xfff;
                        break;
                        */
                        return;
                    case 0xf: // SVEC
                        /*
                        dy = vector_ram[pc] & 0x300;
                        if ((vector_ram[pc] & 0x400) != 0)
                            dy = -dy;
                        dx = (vector_ram[pc] & 3) << 8;
                        if ((vector_ram[pc] & 4) != 0)
                            dx = -dx;
                        sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
                        vz = (vector_ram[pc] & 0xf0) >> 4;
                        */
                        break;
                    default:
                        dy = vector_ram[pc] & 0x3ff;
                        if ((vector_ram[pc] & 0x400) != 0)
                            dy = -dy;
                        dx = vector_ram[pc + 1] & 0x3ff;
                        if ((vector_ram[pc + 1] & 0x400) != 0)
                            dx = -dx;
                        sf = op;
                        vz = vector_ram[pc + 1] >> 12;
                        if (dx == 0 && dy == 0 && vz == 15)
                            game.shots[game.nshots++].set(vx, vy);
                        if (op == 6 && vz == 12 && dx != 0 && dy != 0)
                        {
                            switch (shipdetect)
                            {
                                case 0:
                                    v1x = dx;
                                    v1y = dy;
                                    ++shipdetect;
                                    break;
                                case 1:
                                    game.ship_present = true;
                                    game.ship_x = vx;
                                    game.ship_y = vy;
                                    game.ship_dx = v1x - dx;
                                    game.ship_dy = v1y - dy;
                                    game.ship.x = vx;
                                    game.ship.y = vy;
                                    game.ship.gun_dx = dx;
                                    game.ship.gun_dy = dy;
                                    ++shipdetect;
                                    break;
                            }
                        }
                        else if (shipdetect == 1)
                            shipdetect = 0;

                        break;
                }
                if (op <= 0xa)
                    ++pc;
                if (op != 0xe) // JMPL
                    ++pc;
            }

        }

    }
}
