// player.h: Beispielspieler fr Asteroids
// Harald Bgeholz / c't
#pragma once

#if defined(WINDOWS)
#define ADDRESS DWORD
#else
#define SOCKET int
#define ADDRESS in_addr_t
// 3 Includes fr sockaddr_in
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif

#include <assert.h>
#include <math.h>
#include "game.h"
#ifdef USE_GUI
	#include <vcclr.h>
	#include "GUI.h"
#endif

typedef float speed_t;

#define PLAYER	"THR"	// player name
#define HIGHSCORESLEEPTIME 100

#define CONTROL_DELAY			1

#define TRACKING_MAX_DT			3	// max. time difference for tracking
#define MIN_TRACKS_SHOT			2	
#define MIN_TRACKS				1

#define MAX_TRACKED_RADIUS_SQ	3	// max. radius for tracked objects (squared)
//#define MAX_UNTRACKED_RADIUS_SQ	MAX_SPEED*MAX_SPEED	// max. radius for untracked objects (squared)

#define MAX_RANGE_SHOT			550	// max. range of a shot

#define MAX_SPEED_SAUCER_XY		2	// max. saucer speed
#define MAX_SPEED_SHIP_XY		8	// max. ship speed in x and/or y direction
#define MAX_SPEED_ASTEROID_XY	4	// max. asteroid speed
#define SHIP_SPEED_SHOT			8
#define MAX_SPEED_SHOT			(SHIP_SPEED_SHOT+MAX_SPEED_SHIP_XY-1)	// max. speed of a shot in x and/or y direction
#define SHIP_DECELERATON		-0.010f	//-0.0148 // ship deceleration when no thrust

#define MIN_SHIP_ANGLE			0.07363	// min. ship rotation angle [rad] = 2*pi/(256/3)
#define MAX_SHOOT_ANGLE_TOL		2.0		//max. angle tolerance to shoot
#define MIN_SHOOT_ANGLE_DEV		(MIN_SHIP_ANGLE*MAX_RANGE_SHOT/SHIP_SPEED_SHOT / 3)

#define MIN_DIST_HYPERSPACE		9 //12	// hyperspace for untracked objects
#define T_HYPERSPACE			1		// hyperspace for tracked objects
#define MIN_DIST_THRUST			(MAX_RANGE_SHOT*7/10)
#define MAX_SPEED_THRUST		(MAX_SPEED_SHIP_XY/4)

#define T_ATTACK_COLLI			200	// attack objects, when collision within next T_ATTACK_COLLI_FRAMES frames
#define MAX_DIST_COLLI			5
#define MAX_DIST_ATTACK_SAUCER	(MAX_RANGE_SHOT*8/10)	// max. saucer attack distance
#define T_ATTACK_ALL			30
#define MAX_DIST_ATTACK_ALL		(RADIUS_SHIP*10)
#define MAX_DIST_ATTACK			(MAX_RANGE_SHOT*9/10)

#pragma pack(1)
struct FramePacket
{
	char vectorram[1024];
	char frameno;  // wird bei jedem Frame inkrementiert
	char ping;     // Der Server schickt das letzte empfangene ping-Byte zurck
};

class KeysPacket
{
private:
	static const char KEY_HYPERSPACE = 1;
	static const char KEY_FIRE = 2;
	static const char KEY_THRUST = 4;
	static const char KEY_RIGHT = 8;
	static const char KEY_LEFT = 0x10;
	static const char KEY_START = 0x20;

	char signature[6];
	char keys;
public:
	char ping;     // wird vom Server bei nchster Gelegenheit zurckgeschickt. Fr Latenzmessung.

	KeysPacket(void);
	void clear(void);         // alle Tasten loslassen
	void start(bool b);       // Startbutton drcken (true) oder loslassen (false)
                              // (nur mit aktualisierter Mame)
	void hyperspace(bool b);  // Hyperspace drcken (true) oder loslassen (false)
	void fire(bool b);        // Feuerknopf drcken (true) oder loslassen (false)
	void thrust(bool b);      // Beschleunigen ...
	void right(bool b);       // rechts drehen ...
	void left(bool b);        // links drehen
};
#pragma pack()


class Player
{
public:
	Player(SOCKET sd, ADDRESS server_ip) : sd(sd), server_ip(server_ip)
#ifdef USE_GUI
		, gui(gcnew asteroid::GUI()) 
#endif
		{};

	~Player() { 
#ifdef USE_GUI
		delete gui; 
#endif
	};

	void Run(void);
	
	void InterpretScreen(FramePacket &packet, GameStatus& game);
	void UpdateObjectTracking(GameStatus& prevGame, GameStatus& game);

    bool InterpretHighscoreScreen(const FramePacket &packet, int pos, char* curchar);
    void WriteHighscore(const char *str);

	void ReceivePacket(FramePacket &packet);
	void SendPacket(KeysPacket &packet);
private:
	SOCKET sd;
	ADDRESS server_ip;
#ifdef USE_GUI
	gcroot<asteroid::GUI^> gui;
	//thread
#endif
};
