package hek.de.hinni.hek.asteroids;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.TreeSet;

import org.apache.log4j.Logger;
public class TonyStrategieBaumSuche extends Strategie implements ScreenChangedListener {
	
	public static final Logger logger = Logger.getLogger(TonyStrategieBaumSuche.class);
	public static final int MINTREEHEIGHT = 4;
	
	
	private MyShip myShip = null;
	private MySaucer mySaucer = null;
	private List<MyAsteroid> myAsteroids = null;
	private List<MyShot> myShots = null;
	
	
	private TreeSet<FireSolution> currentExecutedFS = new TreeSet<FireSolution>();
	//treesearch
	private int initDelay = 9; //in frames
	private final int treeHeightExtension = 1;  
	private int minSolutionQueueSize= 4; 
	private boolean screenChanged=true;
	private int minTreeHeight=Integer.MAX_VALUE; // changed-var
	
	//current execution queue
	private Stack<GameState> GSqueue = new Stack<GameState>(); 
	
	//debug
	private int worldLastChangedTime=0; //debug output
	
	public TonyStrategieBaumSuche() {
		World.addScreenChangedListener(this);
	}
	
	
	
	
	public TastenTyp getEingabe(WorldObjects objects, StatusFlags status, int aktTick) {
		
		if (aktTick<initDelay)
		{
			System.out.println("initDelay");
			return TastenTyp.LINKS;
		}
		

		this.myShip = objects.getMyShip();
		this.mySaucer = objects.getMySaucer();
		this.myAsteroids = objects.getMyAsteroids();
		this.myShots = objects.getMyShots();
		

		
		
		if (!status.ueberpruefe(StatusFlags.SHIP_EXISTS) || myShip==null)
		{
			if (status.ueberpruefe(StatusFlags.ASTEROIDS_EXIST))
//					for(MyAsteroid a:myAsteroids)
//						a.updateKillList();
				
			if (aktTick%1000==0)
				System.out.println("****************dead*************");
			return TastenTyp.NICHTS;
		}

		if (!status.ueberpruefe(StatusFlags.ASTEROIDS_EXIST) && 
				!status.ueberpruefe(StatusFlags.SAUCER_EXISTS))
		{
			if (aktTick%1000==0)
				System.out.println("****************Level Complete*************");
			return TastenTyp.NICHTS;
		}
		
		//fs-aktualisieren
		updateCurrentExecutedFS(aktTick);
		
		//coll test
		for(MyAsteroid a:myAsteroids)
		{
			Collision c = new Collision(myShip,a);
			if (c.isConsistent())
			{
				a.setDrawColor(Color.magenta);
				a.setDrawStringWithObject("tHit="+c.getHitTimeOuter());
				logger.fatal("Found Ship-Collision at "+c.getHitTimeOuter()+" with "+c.getObject2().getId()+"   coll:"+c);
			} else
			{
				a.setDrawColor(Color.black);
				a.setDrawStringWithObject(null);
			}
		}
		
		
		if (GSqueue.isEmpty())
		{
			Stack<GameState> cb = GameState.getBestCurrentExecutionQueue();
			
			//initialer fall
			if (cb.isEmpty())
			{
				logger.fatal("Init search-tree!");
				
				//full init tree
				GameState.initGameStateTree(myShip,mySaucer,myAsteroids,currentExecutedFS,null);

				//raise tree level to min size
				GameState.extendGameStateTree(minSolutionQueueSize-treeHeightExtension); //TODO, evtl. performanzproblem hier wenn viele asteroiden da sind
				
				//fill execution queue
				GSqueue = GameState.getBestCurrentExecutionQueue();
				if (GSqueue.isEmpty())
				{
					logger.warn("couldnt init queue!"+aktTick);
					return TastenTyp.NICHTS;
				}
				
				//set search tree to further search (set new root)
				//GameState.initGameStateTree(myShip,mySaucer,myAsteroids,currentExecutedFS,GSqueue.peek());
				GameState.setNewTreeRoot(GSqueue.peek());
				
				screenChanged=false;
//				minTreeHeight = MINTREEHEIGHT;
				
			} else
			{
//				logger.debug("here");
				GSqueue = cb;
			}
		}
		
		//initialer fall:
		if (screenChanged) //TODO:aktuelle ausfhrung wird unterbrochen!!!! -> vermeiden
		{
			logger.debug("Screen Changed, flushing execution queue");
			
			GameState temp = GSqueue.peek();
			GSqueue.clear();
			//leave last in the queue
			GSqueue.push(temp); 
			
			//setup new tree, with last as root
			GameState.initGameStateTree(myShip,mySaucer,myAsteroids,currentExecutedFS,temp);
		}
		
		
		//verbessere die solution bei jedem durchlauf
		GameState.extendGameStateTree(treeHeightExtension);
		

		logger.debug("(t="+aktTick+")CurrStack(size="+GSqueue.size()+"): "+(GSqueue.empty()?null:GSqueue.peek())+"");
		logger.debug("(t="+aktTick+")CurrTree :" +GameState.getGameTreeStats());
		
		
		//verbesserte loesung verfuegbar?
		int currlev = GameState.getCurrentBestLevel()+1; //+1 weil von null an gezaehlt, +1 weil root node 1 ehoeht
		if (currlev>GSqueue.size()) //|| minTreeHeight<currlev entweder besser, oder es hat sich was gendert
		{
			int oldSize=GSqueue.size(); //debug
			//save current executed
			GameState pending = GSqueue.peek();
			//get next without current executed
			GSqueue = GameState.getBestCurrentExecutionQueue();
			//add current executed
			GSqueue.push(pending); //add the currently executed node
			
			logger.debug("bessere loesung verfuegbar! oldSize="+oldSize+", newSize="+GSqueue.size()+"  Stacktop: "+GSqueue.peek());
//			minTreeHeight=Integer.MAX_VALUE;

		}
		
		if (GSqueue.peek().getNumberOfInvalidTargetsAt()!=0)
			logger.debug("#Root_Invalids: "+GSqueue.peek().getNumberOfInvalidTargetsAt());
		
		if (GSqueue.peek().getShipCollisionProb(aktTick)>0)
		{
			logger.debug("Kollision next pHit="+GSqueue.peek().getShipCollisionProb(aktTick));
			
		}
		
		return execute(GSqueue,myShip);
	}			
		
	
	public void draw(Graphics2D g)
	{
		
//		if (GameState.getTreeLevel(1)!=null) 
//			for(GameState gg:GameState.getTreeLevel(1))
//				gg.draw(g);

		if (GameState.getBestCurrentGameState()!=null)
			GameState.getBestCurrentGameState().draw(g);
		
//		TreeSet<FireSolution> gg= GSqueue.isEmpty()?null:GSqueue.peek().getBullets();
//		
//		if (gg!=null)
//			for(FireSolution fs:gg)
//				fs.draw(g);
		
		for(FireSolution fs:currentExecutedFS)
			fs.draw(g);
		
	}
	
	
	//bentigt nach zeit sortierte schussreihenfolge
	private TastenTyp execute(Stack<GameState> queue, MyShip s)
	{
		if (queue==null || queue.empty())
		{
			logger.warn("nothing to execute!");
			return TastenTyp.NICHTS;
		}
		
		GameState g = queue.peek();
		FireSolution fs = g.getStateCreator();
		int time = s.getCurrentTime();
		
		if (fs.canBeExecuted(s))
		{
			TastenTyp t = fs.execute(s);
			if (t.ordinal()==TastenTyp.FEUER.ordinal())
			{


				if (World.gameStatus.shots.size()<=3)
				{

					logger.debug("firing(ct="+time+", ft="+fs.getFireTime()+"):"+g+"   fs:"+fs);
					
					//fuege erwarteten (neuen) shot hinzu, so dass kein screenChange auftritt
					myShots.add(fs.getBullet());

					//fuege ausgefuehtere firesolution zu den aktiven hinzu
					currentExecutedFS.add(fs);
					//dannach ist der baum noch 1 frame aktiv, da der schuss nicht sofort sichtbar ist!

					//loesche den aktuell ausgefuehrten GameState vom stack
					queue.pop();
					
					if (!queue.isEmpty())
					//setze neuen rootnode, fuer die Weiterberechnung
						GameState.setNewTreeRoot(queue.peek());
					
				}
				else
				{
					logger.debug("ERRORcould not kill object!"+World.gameStatus.shots.size()+"   "+g);
					return TastenTyp.NICHTS;
				}
			}
			return t;

		} else
		{
			logger.warn("FireSolution could not be executed! going to next: fireIn="
					+(fs.getFireState().getCurrentTime()-myShip.getCurrentTime())
					+" turn="+(myShip.getTurnTime(fs.getFireState().angleIndexByte))
					+" data:"+fs+"  current"+myShip);
			
			//irgendwas stimmt nicht
			logger.warn("ScreenChanged");
			World.notifyScreenChangedListener();

			queue.clear();
			GameState.initGameStateTree(myShip,mySaucer,myAsteroids,currentExecutedFS,null);
			
			//da eh init im naechsten frame
			return TastenTyp.NICHTS;//execute(queue,s);
		}

	}
	
	public void screenChanged()
	{
		logger.debug("screenChanged t="+World.getTick());
		screenChanged = true;
	}		
	
	
	private void updateCurrentExecutedFS(int aktTick)
	{
		TreeSet<FireSolution> aktuell = new TreeSet<FireSolution>();
		
		List<Position> shots = new LinkedList<Position>();
		
		for(MyShot s:myShots)
			shots.add(s.estimatePosition(aktTick));
		
		int count =0;
		for(FireSolution f:currentExecutedFS)
		{
			//zeitliche aktualitaet && oerlich wiedergefunden
			if (f.willEndConsistentlyAfter(aktTick) &&
					(new MyShot(f.getBullet())).findeMyObject(shots)) //TODO: speicherverscchwendung
			{
				count++;
				aktuell.add(f);
			} else {
				logger.debug("shot nicht gefunden:"+f.getBullet()+"   in "+myShots);
			}
			
			//myAsteroids.contains - nicht, da auf knstlich erzeugte geschossen wird
			
		}
		
		logger.warn("SHOTS: myShots="+myShots.size()+" oldFS="+currentExecutedFS.size()+" newFS:"+aktuell.size());
		
		currentExecutedFS = aktuell;

		
	}
	
	
}
