package hek.de.hinni.hek.asteroids;

//import org.apache.log4j.Logger;


/*
 * 
 * describes motion
 * 
 */
public class Vector {
	
//	public static final Logger logger = Logger.getLogger(Vector.class);
	
	private int 			dx;
	private int 			dy;
	private static final int 	dt = 1;
	/**
	 * Ortsunsicherheits nderung pro frame 
	 * Sollte negativ oder 0 sein!
	 * Falls NaN, dann ungltig
	 */
	private final float d_C;  //-> wenn NaN, dann nicht gesetzt
	/**
	 * Zeitpunkt, ab dem die certainty verndert werden soll
	 */
	private final int t0_C;

	/**
	 * Unsicherheit bei t0_C
	 */
	private final float c0_C; 

	
	//Formel: = c0_C + d_C * ( time - t0_C )
	//	if time>=dCertaintyStart && time <maxCertTime
	
	public int getX() {return dx;	}
	public int getY() {return dy; }
	
	public float getCertaintyAt(int time)
	{
		return Math.min(c0_C,
				Math.max(0, 
						c0_C + d_C*(time-t0_C)));
	}

	//time of certainty = 0
	public int getTimeOfMinCertainty()
	{
		return (d_C==0)
				? Integer.MAX_VALUE
				: (int)Math.floor(getTimeOfCertainty(0f));
	}

	//time of certainty = initPositionCertainty
	public int getTimeOfMaxCertainty()
	{
		return (d_C==0)
				? Integer.MIN_VALUE
				: (int)Math.ceil(getTimeOfCertainty(c0_C));
	}
	
	public boolean isValidCertaintyAt(int time)
	{
		float c = getCertaintyAt(time);
		return !Float.isNaN(c) && (c!=0);
	}
	
	//mit floor gerundet
	private float getTimeOfCertainty(float c)
	{
		return (d_C==0)
				? Float.NaN
				: (c-c0_C)/ d_C + t0_C;
	}
	
	public Vector(int dx, int dy, float dCertainty, int dCertaintyStart, float initPositionCertainty) { 
		 this.dx = dx;
		 this.dy = dy;
		 this.d_C = dCertainty;
		 this.t0_C = dCertaintyStart;
		 this.c0_C = initPositionCertainty;
	}

	public Vector(Vector v) {
		dx = v.dx;
		dy = v.dy;
		d_C = v.d_C;
		t0_C = v.t0_C;
		c0_C = v.c0_C;
	}
	
//	public static Vector plus(Vector a, Vector b) {
//		return new Vector(a.getX() + b.getX(), a.getY() + b.getY());
//	}
//	//public Vector minus(Vector a) {
//		//return Vector(this.getX() - a.getX(), this.getY() - a.getY());
//	//}
//	public static Vector minus(Vector a, Vector b) {
//		return new Vector(a.getX() - b.getX(), a.getY() - b.getY());
//	}
//	public boolean equals(Vector a) {
//		return (Math.abs(a.getX()-this.getX()) < 1 && Math.abs(a.getY()-this.getY())<1);
//	}
//	/*
//	 * berechnet Winkel zwischen Vektor und horizontal nach rechts gerichtetem Vector entgegen dem Uhrzeigersinn
//	 */
//	public float getWinkelRad() {
//	
//		/*float tmp = (float)(Math.asin(getY()/(length())));
//		if (getX() < 0)
//			return (float)Math.PI - tmp;
//		else if (getY() < 0)
//			return (float)(Math.PI*2) + tmp;
//*/			
//	//	return tmp;
//		return (float)Math.atan2(getY(),getX());
//	}
//	public float getWinkelDeg() {
//		float winkel = (float)(getWinkelRad()*180/Math.PI);
//		if (winkel < 0) 
//			return 360 + winkel;
//		return winkel;
//	}
	/*
	 * multipliziert mit Skalar
	 */
//	public static Vector multiplizier(Vector v, int faktor) {
//		return new Vector(v.getX() * faktor, v.getY() * faktor);
//	}
	
	public static Vector multiplizier(Vector v, float faktor) {
		return new Vector((int)(v.dx * faktor), (int)(v.dy * faktor)
				,v.d_C,v.t0_C,v.c0_C);
	}
	
	public String toString() {
		return "dir(dx="+dx + ", dy=" + dy+") d_C="+d_C+", t0_C="+t0_C+", c0_C="+c0_C+")";
	}
	/*
	 * gibt Vektor zwischen zwei Positionen zurück
	 */
	public Vector(Position p0, Position p1, float d_C, int t0_C, float c0_C) {
	
		if (Float.isNaN(c0_C) && t0_C!=Integer.MAX_VALUE)
		{
//			logger.debug("shit");
			
			
		}
		
		dx = (p0.getX() - p1.getX());
		if (dx > Position.screenSizeX/2)
			dx = Position.screenSizeX - dx;
		if (dx < -Position.screenSizeX/2)
			dx = -Position.screenSizeX -dx;
		dy = (p0.getY() - p1.getY());
		if (dy > Position.screenSizeY/2)
			dy = Position.screenSizeY - dy;
		if (dy < -Position.screenSizeY/2)
			dy = -Position.screenSizeY -dy;
		
		
		this.c0_C = c0_C;
		this.d_C = d_C;
		this.t0_C = t0_C;
	}

	public void add(int addX, int addY) {
		dx += addX;
		dy += addY;
	}
	
	public void setXY(int dx, int dy)
	{
		this.dx=dx;
		this.dy=dy;
	}
	
	public int getSpeedSqr()
	{
		return dx*dx+dy*dy;
	}

}
