
/*
  c't creativ-Wettbewerb 2008 / Asteroids.

  Dirk Farin / dirk.farin@gmail.com
 */

#ifndef AI_H
#define AI_H

#include "player.h"
// #include <libvideogfx.hh>
#include <iostream>
#include <assert.h>
#include <algorithm>

// using namespace videogfx;
using namespace std;

struct Position
{
  int x,y;

  Position operator*(int f) const { Position p; p.x=x*f; p.y=y*f; return p; }
  void operator*=(int f) { x*=f; y*=f; }

  Position operator/(int f) const { Position p; p.x=x/f; p.y=y/f; return p; }
  void operator/=(int f) { x/=f; y/=f; }
};

inline ostream& operator<<(ostream& ostr, const Position& p)
{
  ostr << p.x << ";" << p.y;
  return ostr;
}

struct Vector
{
  int x,y;

  Vector operator*(int f) const { Vector p; p.x=x*f; p.y=y*f; return p; }
  Vector operator/(int f) const { Vector p; p.x=x/f; p.y=y/f; return p; }
};

inline Position operator+(const Position& p, const Vector& v)
{
  Position n;
  n.x = p.x+v.x;
  n.y = p.y+v.y;
  return n;
}

inline int sqrDistance(const Position& a,const Position& b)
{
  int dx = a.x-b.x;
  int dy = a.y-b.y;
  return dx*dx+dy*dy;
}

void checkParticleOrigin(const Position& particle_pos,
			 const Vector&   particle_v8,
			 const Position& potential_source,
			 Position& closest_point,
			 double&   travel_time);


enum { HISTORY_SIZE=75 };

class PositionHist
{
 public:
  PositionHist() : histlen(0) { v8.x=v8.y=0; }
  virtual ~PositionHist() { }

  const Position& Pos(int idx=0) const { assert(idx<histlen); return pos[idx]; }
  const Position& StartPos() const { return pos[histlen-1]; }  // TODO: not really startpos

  Position predictPosition(int nFramesInAdvance=1) const;

  void pushPosition(const Position& p, int nFrameDrops=0, int maxHistLen=HISTORY_SIZE);
  void pushPosition(int x,int y, int nFrameDrops=0, int maxHistLen=HISTORY_SIZE);
  void clear() { histlen=0; v8.x=v8.y=0; }

  Vector estimSpeed8() const { return v8; }  // *8 for accuracy
  int historyLen() const { return histlen; }

 private:
  void estimSpeed();

  Position pos[HISTORY_SIZE];
  int histlen;
  Vector v8;
};

struct Target
{
  Target() : underFire(0) { }

  PositionHist p;
  char radius;
  int  underFire;  // set to the timestamp of the shot aiming this asteroid
};

struct AIAsteroid : public Target
{
  AIAsteroid();

  char sf, type;

  int  newcnt;
};


struct AIShot : public PositionHist
{
  AIShot() : origin(AIShot::unknown) { }

  enum { unknown, saucer, ship } origin;
  int  startframe;
};

// sizes: 7,15,31,8,12

struct AIGameStatus
{
  bool ship_present;
  PositionHist shipPos;

  bool saucer_present;
  Target saucer;

  AIAsteroid asteroid[MAX_ASTEROIDS];
  int nAsteroids;

  AIShot shotPos[MAX_SHOTS]; // TODO rename
  int nShots;

  int timestep;

  // ---------------------------

  AIGameStatus();

  void updateGameStatus(const class GameStatus& newStatus, int framedrops);
};


#define ANGLE_BUF_SIZE 100

struct Plan
{
  Plan() : valid(false) { }

  int time() const { return abs(nRotate) + nWaitFrames; }

  int  nRotate;
  int  nWaitFrames;
  int  nShotFrames;   // how long shot will fly
  int  nShotSeq;    // 1 - 1 shot / 3 - 2 shot / 5 - 3 shot / 7 - 4 shot

  bool valid;
};


class AIControl
{
 public:
  AIControl();

  KeysPacket process(const class GameStatus& newStatus, int framedrops);

 private:
  AIGameStatus status;

  // AI

  enum
  {
    state_dead,
    state_calibrating,
    state_normalplay
  } state;
  bool fired_last_frame;

  double angle;
  bool angleValid;
  bool nofire;
  int  last_calibration_shot; // startframe of calibration shot
  unsigned char angle_byte;

  unsigned char anglebuf[ANGLE_BUF_SIZE]; // expected angle at timestep

  int salve[4];  // times when to shoot a "salve"
  int nSalve;

  //bool checkCollision(const Position& ship, double angle,
  //	      const Target& target) const;
  bool checkCollisionTab(const Position& ship, unsigned char angle_byte,
			 const Target& target) const;
  bool aimCollision(const Position& ship, double angle,
		    const Target& target,
		    double& time_shot, double& time_target) const;
  int collisionTime(const Target& target, const Position& ship) const;


  Plan plan;

  //Plan planShot(const Position& ship, double current_angle,
  //	const Target& target);
  Plan planShotTab(const Position& ship, unsigned char current_angle,
		   const Target& target, int besttime=99);

  // debug

#if 0
  X11Win win;
  Image<Pixel> img;
#endif
  void showDebugImg();

  Position mark[100];
  int nMarks;
  int markcnt;

  int offsetX, offsetY;
  int game2scrX(int x) { return (x+offsetX+10240)%1024; }
  int game2scrY(int y) { return 767-((y+offsetY+7680)%768); }

#if 0
  void drawHist(Image<Pixel>& img, const PositionHist& hist, const Color<Pixel>& col);
#endif

  void showExpectedFirePath() const;
};


inline void doOverflow(Position& p)
{
  const int xMin = 0;
  const int xMax = 1023;
  const int yMin = 128;  // unten
  const int yMax = 895;  // oben

  if (p.x<0)    p.x += 1024;
  if (p.x>xMax) p.x -= 1024;
  if (p.y<yMin) p.y +=  768;
  if (p.y>yMax) p.y -=  768;
}

#endif
