// -*- mode:C++; -*-
// Zoltan Zomotor
// exampleplayer.cpp: Beispielspieler fr Asteroids
// Original: Harald Bgeholz / c't


#include "exampleplayer.h"
#include "game.h"
#include "output.h"
#include<iostream>
#include<math.h>
#include<gsl/gsl_poly.h>
void ExamplePlayer::MakeTurn (const GameStatus& state, KeysPacket &keys)
{
  double min_dist = MIN_DIST_DANGER;
  int ittd     = -1;
  int i2ttd     = -1;
  int iMinDist = -1;
  int iMinDistId = MAXINT;
  double saucer_shot_ttc = MAX_PRAED;
  isaucer  = -1;
  
  iSaucerExplosion = saucer.set(state,nBigSaucers,nSmallSaucers);
  if(saucer.IsPresent()){
    isaucer = state.nasteroids;
    saucer.nTags=0;
    cflag[isaucer]=false;
  }

  TrackAsteroids(state);
  TrackShots(state);   // Mit reset tta
  ship.set(state);
  km1 = M(state.keysPing - 1);
  km2 = M(state.keysPing - 2); // wird in GetCflag verwendet
  //  ship.Speed(state,thrust);

  thrust = false;
  for(int i=0;i<4;i++) ttns[i] = 0;

  // Attribute zurcksetzen, 
  for (int i = 0; i < state.nasteroids; ++i){  // Alle Asteroiden
    cflag[i] = false;      // cflag zurcksetzen
    asteroids[i].nTags=0;  // nTags zurcksetzen
    asteroids[i].ttd = MAXINT;
    if (state.ship.IsPresent()){
      asteroids[i].Dist(ship);  // Aktueller Abstand zum Schiff
      ttc[i].t=asteroids[i].Ttc(ship);   // Time to collision mit Schiff    
      ttc[i].i=i;
      ship.Aim(asteroids[i],i,state); // Zielen
    }
  }
  
  // Geburtenrate und nTags bestimmen
  births=0;

  // Im letzten oder vorletzten Frame gefeuert --> Schuss erscheint im nchsten Frame
  int aktTaggedId1 = ship.taggedId[km1];
   if(aktTaggedId1 != MAXINT ){ 
    for(int i=0; i<state.nasteroids;i++){
      if(asteroids[i].id == aktTaggedId1 ) {
	asteroids[i].nTags++;
	asteroids[i].ttd = ship.ts[i];
	switch(asteroids[i].sf){
	  case AST_GROSS:
	    births += 2;
	    break;
	  case AST_MITTEL:
 	    if(asteroids[i].nTags==0) births += 2;
	    break;
	  case AST_KLEIN:
	  default:
	    break;
	}
      }
    }
    if(saucer.IsPresent() && (saucer.id == aktTaggedId1 )){
      saucer.nTags++;
      cflag[isaucer]=true;
    }
  }

  // Alle eigenen Schsse
  for(int s=0; s < state.nshots; s++){
    shots[s].tta = MAXFLOAT;
    ttns[s] = 72;
    int iTagged = MAXINT;
    
    if(saucer.IsPresent() && shots[s].taggedIdAimed == saucer.id ){
      double ttc = shots[s].Ttc(saucer);
      if(ttc < shots[s].sls - shots[s].age){
	shots[s].tta = ttns[s] = ttc;
	shots[s].taggedId = shots[s].taggedIdAimed;
	saucer.nTags++;
	cflag[isaucer]=true;
	iTagged = isaucer;
      }
    }else{
      for(int i=0; i<state.nasteroids;i++) {  // geht der Schuss ins geplante Ziel?
	if(shots[s].taggedIdAimed == asteroids[i].id){
	  iTagged = i;
	  double ttc = shots[s].Ttc(asteroids[i]);
	  if(ttc<shots[s].sls-shots[s].age){
	    asteroids[i].nTags++;
	    asteroids[i].ttd = shots[s].tta =  ttns[s] =ttc;
	  }
	  break;
	}
      }
    }
    
    for(int i=0; i<state.nasteroids;i++) {  
      double ttc = shots[s].Ttc(asteroids[i]);
      if(ttc < shots[s].sls-shots[s].age && ttc < asteroids[i].ttd){            // Schuss geht ggf. vorher in ein anderes Ziel
	asteroids[i].ttd = shots[s].tta =  ttns[s] = ttc;
	iTagged = i;
	asteroids[iTagged].nTags++;
	
      }
    }
    if(iTagged != MAXINT && iTagged != isaucer){
      switch(asteroids[iTagged].sf){
	case AST_GROSS:
	  births += 2;
	  break;
	case AST_MITTEL:
	  if(asteroids[iTagged].nTags==0) births += 2;
	  break;
	case AST_KLEIN:
	default:
	  break;
      }
      shots[s].taggedId = asteroids[iTagged].id;
    }
  }
      
  for(int s=0; s < nownshots; s++){
    ttns[s] = shots[s].tta<72?shots[s].tta:72;
  }
  int nObj = state.nasteroids;

  if(saucer.IsPresent()){
    nObj++;
    if (state.ship.IsPresent()){
      ship.Aim(saucer,isaucer,state);      // Auf UFO zielen
      ttc[nObj].t=saucer.Ttc();
      ttc[nObj].i=isaucer;
      ttc[nObj].ttd = int(ship.ttd[isaucer]);
    }
  }

  bubble_sort(ttns,4); // ttns (time to next shot) sortieren
  bubble_sort(ttc,nObj);
   
  // Kollisionsasteroiden:

  int tmp=0;
  ttcDanger=TTC_DANGER;
  int lnDPH=0;
  for(int it=0;it<nObj;it++){
    double _ttc=ttc[it].t;
    int ittc = ttc[it].i;
    if(_ttc<MAXFLOAT ){
      tmp++;
      if(tmp==1) lnDPH=ship.nDPH[ittc];
      ttcDanger += ship.fd[ittc] + 2*int(fabs(ship.nDPH[ittc] - lnDPH));
      lnDPH=ship.nDPH[ittc];
    }
  }
#ifdef SIMULATION
  OutputInfo2(" ttcDanger=%d ",ttcDanger);
#endif
  int nttc=0;
  for(int it=0; it<tmp; it++){
    if(ttc[it].t<=ttcDanger) {
#ifdef VERBOSE
      int ittc=ttc[it].i;
      if(ittc!=isaucer) OutputInfo2("(%d:%3.1f)",asteroids[ittc].id,ttc[it].t);
      else              OutputInfo2("(%d:%3.1f)",saucer.id,ttc[it].t);
#endif
      nttc++;
    }
  }
       


  // nownshots prdizieren
  if(int(ttns[0]) == 0){     
    nownshots--; 
    nHit++;
    if(loaded) ttns[0]=0;
    else       ttns[0]=1;
  }
  for(int s=1; s < state.nshots; s++){
    if(int(ttns[s]-0.1)<= 0){
      nownshots--; 
      nHit++;
      ttns[s]=ttns[s-1]+2;
    }
  }


  // Schsse auf das Schiff bestimmen
  int iSaucerShot=-1;
  if (state.ship.IsPresent()){
    for(int s = 0; s < state.nshots; s++){          // Schleife ber alle Shots
      shots[s].Ttc(ship);                           // Time to collision mit Schiff
      if(shots[s].ttc < saucer_shot_ttc ){
	saucer_shot_ttc = shots[s].ttc; 
	iSaucerShot = s;
      }

      // cflag bestimmen                                                                                   
      for (int i = 0; i < state.nasteroids; ++i){
	GetCflag(i, s, state, ship.ts[i]);
      } 

    } // alle shots

    // getagged-te Kollisionsasteroiden zhlen
    int nCflagTtc=0;
    for(int it=nttc-1;it>=0;it--) 
      if(cflag[ttc[it].i]) nCflagTtc++;
      else {
	if(ittd > -1) i2ttd=ittd;
	ittd = ttc[it].i;
      }
    int nUntaggedTtc = nttc-nCflagTtc;

    // Bestimmung min_dist, ittd, i2ttd
    if(saucer.IsPresent()){
      min_dist = saucer.d;
      iMinDist = isaucer;
      iMinDistId = saucer.id;
    }
    for (int i = 0; i < state.nasteroids; ++i){   
      // Mindestabstand 
      if (asteroids[i].d<min_dist){  
	min_dist = asteroids[i].d;
	iMinDist = i;
	iMinDistId = asteroids[i].id;
      }

      if(cflag[i] ) continue;

      // Mindest-ttd
      switch(nUntaggedTtc){
	case 0:
	  if       (ittd ==-1 || ship.ttd[i] < ship.ttd[ittd]  || (ship.ttd[i] == ship.ttd[ittd]  && ship.ts[i] < ship.ts[ittd])){
	    i2ttd=ittd;
	    ittd =  i;
	  } else if(i2ttd==-1 || ship.ttd[i] < ship.ttd[i2ttd] || (ship.ttd[i] == ship.ttd[i2ttd] && ship.ts[i] < ship.ts[i2ttd])){
	    i2ttd =  i;
	  }
	  break;
	case 1:
	  if(ship.ttd[i] < ship.ttd[i2ttd] || (ship.ttd[i] == ship.ttd[i2ttd] && ship.ts[i] < ship.ts[i2ttd])){
	    i2ttd =  i;
	  }
	  //	  }
	  break;
	default:
	  break;
      }
    } // Alle Asteroiden
    
    // Entscheidung, ob vor UFO-Schuss noch ein Asteroid abgeschossen werden kann
    if(saucer.IsPresent() && !cflag[isaucer]){
      switch(nUntaggedTtc){
	case 0:
	  if(state.nasteroids>1 && state.score>=36000){ // UFO-Prioritt ab 36000 Punkten
	    shootThisFirst(isaucer,state.nasteroids,ittd); // Prfen, ob vor einem UFO-Schuss noch was geht
	    if(ittd!=isaucer) i2ttd=isaucer;
	    else {          
	      i2ttd=ittd;
	      ittd =isaucer;
	    }
	  } else { // UFO wie einen Asteroiden einsortieren
	    if       (ittd ==-1 || ship.ttd[isaucer] < ship.ttd[ittd]  || (ship.ttd[isaucer] == ship.ttd[ittd]  && ship.ts[isaucer] < ship.ts[ittd])){
	      ittd =  isaucer;
	      i2ttd=ittd;
	    } else if(i2ttd==-1 || ship.ttd[isaucer] < ship.ttd[i2ttd] || (ship.ttd[isaucer] == ship.ttd[i2ttd] && ship.ts[isaucer] < ship.ts[i2ttd])){
	      i2ttd =  isaucer;
	    }

	  }
	  break;
	case 1: // Kollisionsasteroiden haben immer Vorrang
	  if(state.nasteroids>1 && state.score>=36000){
	    i2ttd=isaucer;
	  } else {
	    if(ship.ttd[isaucer] < ship.ttd[i2ttd] || (ship.ttd[isaucer] == ship.ttd[i2ttd] && ship.ts[isaucer] < ship.ts[i2ttd])){
	      i2ttd =  isaucer;
	    }
	  }
	  //	  }
	  break;
	default:
	  break;
      }
    }
    
    if(state.nasteroids>0 || state.saucer.IsPresent() || state.nshots>0 ){ // Nur bei vorhandenen Objekten reagieren
      int ishot = ittd; // default
      
      if (ittd>-1 && nUntaggedTtc==1){        // Es gibt noch genau einen ungetaggedten Kollsionsasteroiden, es sollte ittd = ittc gelten!
	shootThisFirst(ittd,state.nasteroids,ishot); // Prfen, ob vor einem ttc-Schuss noch was geht
	if(ishot!=ittd) i2ttd=ittd;
      }
	
      if(ishot>-1){
	if (ship.nDPH[ishot] > 0) keys.left(true);
	if (ship.nDPH[ishot] < 0) keys.right(true);
 
	fire = ship.fire[ishot] 
	  || (ship.oofFire[ishot] );
#ifndef SIMULATION
	if(ship.oofFire[ishot])OutputInfo2(" oofFire %d ",ship.oofFire[ishot]);
#endif
	
      } else fire = false;


      if(!fire && loaded){ // Schieen, wenn was vor die Kanone kommt
        for(int i=0;i<state.nasteroids+1;i++)
	  if( (ship.fire[i] || ship.oofFire[i])&& !cflag[i]){ 
	    fire =true;
	    ishot = i;
#ifndef SIMULATION
	    OutputInfo2(" instant shot ");
#endif
	    break;
	  }
      }
#ifdef SIMULATION
#ifdef OUTPUT
      if(ishot>-1){
	double xxx=ship.ix+ship.ts[ishot]*shotdxp[ship.indphkd[ishot]];
	double yyy=ship.iy+ship.ts[ishot]*shotdyp[ship.indphkd[ishot]];
	normxy(xxx,yyy);
	double ttc=ishot!=isaucer?asteroids[ishot].ttc:saucer.ttc;
	char cttc[20];
	if(ttc<100)sprintf(cttc,"ttc=%3.1f",ttc);
	else       sprintf(cttc,"ttc=---");
	OutputInfo2("Aim %15s %d nTags=%d x=%3d y=%3d, xp=%3.1f, yp=%3.1f, %s, xd=%4.1f, yd=%4.1f, ts=%3d, fd=%3d ",
		    ishot!=isaucer?asteroids[ishot].name:saucer.name,
		    ishot!=isaucer?asteroids[ishot].id:saucer.id,
		    asteroids[ishot].nTags,
		    ishot!=isaucer?asteroids[ishot].ix:saucer.ix,
		    ishot!=isaucer?asteroids[ishot].iy:saucer.iy,
		    ishot!=isaucer?asteroids[ishot].xp:saucer.xp,
		    ishot!=isaucer?asteroids[ishot].yp:saucer.yp,
		    cttc,
		    xxx,yyy,
		    ship.ts[ishot],ship.fd[ishot], ship.sls[ishot]
		    );
      }
      if(state.nshots>0) OutputInfo("(Id,IdAim): ");
      for (int s=0;s<state.nshots;s++) {
	OutputInfo2("(%4d,%4d)",shots[s].taggedId,shots[s].taggedIdAimed);
      }

#endif
#endif

      if (nownshots>=4) loaded=false;
      ship.taggedId[state.keysPing]=MAXINT;
      if (loaded && fire ){  // Feuerknopf drcken, so schnell es geht
#ifdef VERBOSE
	if(ishot!=isaucer) OutputInfo2("Target %s ID %4d at (%4d,%4d) Tags %d ",
				       asteroids[ishot].name,asteroids[ishot].id,
				       asteroids[ishot].ix,asteroids[ishot].iy,asteroids[ishot].nTags);
	else               OutputInfo2("Target %s ID %4d at (%4d,%4d) Tags %d ",saucer.name,saucer.id,
				       saucer.ix,saucer.iy,saucer.nTags);
	if(ship.oofFire[ishot]){
	  OutputInfo("oofFire");
	}
#endif

 	if(i2ttd >-1){
 	  if (ship.nDPH[i2ttd] > 0)  keys.left(true);
 	  if (ship.nDPH[i2ttd] < 0)  keys.right(true);
 	}
	keys.fire(true);
	nOwnShotsTotSoll++;
	
	if(ishot!=isaucer){
	  iLshotId = asteroids[ishot].id;
	  tLshot   = state.t;
	}else {
	  iLshotId = saucer.id;
	  tLshot   = state.t;
	}

	ship.taggedId[state.keysPing] = iLshotId;
	if(ishot==isaucer){
	  nSaucerShot++;
	} else if(ishot==ittd){
	  nTtdShot++;
	  for(int it=0;it<nttc;it++){
	    if(ttc[it].i == ishot){
	      nTtcShot++;
	      nTtdShot--;
	      break;
	    }
	  }
	} else nOtherShot++;

	loaded = !loaded;
      } else{
	loaded = true;
      }      

#ifdef VERBOSE
      for(int s=0;s<state.nshots;s++)  OutputInfo2("(%d,%d, %3.1f) ",shots[s].taggedId,shots[s].taggedIdAimed,shots[s].tta);
#endif

#ifdef SIMULATION
      if(saucer_shot_ttc<100) OutputInfo2("  ttc=%3.1f, own=%d ",saucer_shot_ttc,shots[iSaucerShot].own_shot);
#endif
      if (min_dist  < 1 ){
#ifdef SIMULATION
#ifdef OUTPUT
	OutputInfo2("d=%3.1f %s %d, x=%3d y=%3d",asteroids[iMinDist].d, asteroids[iMinDist].name,asteroids[iMinDist].id,
		    asteroids[iMinDist].ix,asteroids[iMinDist].iy);
#endif
#endif
	keys.hyperspace(true);
#ifdef OUTPUT
	OutputInfo2("Hyper d=%f",min_dist);
#endif
	if(tlhyper < state.t-2){ 
	  if(iMinDist==isaucer) nHyperSaucerDist++;
	  else                  nHyperAsteroid++;
	}
      }
      int ittc=ttc[0].i;
      if(ttc[0].t <= 2 && asteroids[ittc].nTags==0 ){
#ifdef SIMULATION
#ifdef OUTPUT
	int ittc=ttc[0].i;
	OutputInfo2("ttc=%3.1f %s %d, x=%3d y=%3d",ttc[0].t, asteroids[ittc].name,asteroids[ittc].id,asteroids[ittc].ix,asteroids[ittc].iy);
#endif
#endif
	keys.hyperspace(true);
#ifdef OUTPUT
	OutputInfo2("Hyper ttc=%f",ttc[0].t);
#endif
	if(tlhyper < state.t-2) nHyperTtc++;
      } 
      if(saucer_shot_ttc < 4 && shots[iSaucerShot].age < 65 ){// Flucht, wenn Kollision unausweichlich
	OutputInfo2("shot[%d] ttc=%3.1f",iSaucerShot,shots[iSaucerShot].ttc);
	keys.hyperspace(true);
#ifdef OUTPUT
	OutputInfo2("shot_ttc=%f",saucer_shot_ttc);
#endif

	if(tlhyper < state.t-2) nHyperSaucerShot++;
      } 
      if(keys.hyperspace()){
	keys.left(false);
	keys.right(false);
	tlhyper=state.t;
      }

      if(keys.right()) ship.TurnRight(state.keysPing);
      if(keys.left() ) ship.TurnLeft(state.keysPing);


    } else{ // keine Objekte --> zur nchste Grenze drehen
//       int dx = 1024-ship.ix;
//       int dy = 768 - ship.iy;
//       normWrap(dx,dy);
//       if(fabs((dx) > 256) && state.pauseLeft == 164 && state.lifes>2 ) keys.hyperspace(true);
//      else 
	TurnToNextBorders(state,keys);
    }


    //    ship.Speed(state,thrust);

  } // Ship present
}

bool collCheck(const double& dx, const double& dy, const double& radius){
  bool coll = abs(dx) < radius && abs(dy) < radius && (abs(dx)+abs(dy)) < 1.5*radius;
  return coll;
}
void ExamplePlayer::GetCflag(const int& i, const int& s, const GameStatus& state, const int& ts){
  if((state.nObj+births>=26 && asteroids[i].sf!=AST_KLEIN && asteroids[i].ttc>ttcDanger) // Schussverbot grere Asteroiden, auer Kollisions-Asteroiden
     || asteroids[i].nTags>=asteroids[i].requiredShots // getagged
     || (state.gameFrameNo>17750 && state.gameFrameNo<17920 && state.nasteroids==1 && asteroids[0].sf==AST_KLEIN) // Hoffnung auf ein UFO am Ende des Spiels
     ||
     ((asteroids[i].id == shots[s].taggedId || asteroids[i].id == ship.taggedId[km1])
      &&(ttns[0] > 2                // Nchster Schuss nicht schnell verfgbar
	 || iLshotId != asteroids[i].id // Vorheriger Schuss nicht auf diesen Asteroiden --> keine Salve
	 || state.t-tLshot > 2         // Vorheriger Schuss schon zu lange her
	 || ship.fd[i] > 2             // Dauert zu lange bis zum nchsten Schuss
	 || (ship.ts[i] > 35 && state.nEnemy > 11) // Schuss ist zu lange unterwegs
	 || ship.oofFire[i] // out of focus 
	 || (asteroids[i].nTags>1 && state.nBigAsteroids>1 && ts>30 )
	 )
      )
     ){
    cflag[i] = true;
  } 
}

void ExamplePlayer::CalcDest(const unsigned char& ping, int &nDPH){
  const int D2BORDER = 150;
  const int DELTA = 30;
  double lnlam = log(1-1./1024.);
  double dxr = 1023 - D2BORDER - ship.x[ping];
  double dxl = ship.x[ping] - D2BORDER;
  double dyo = 768+128 -D2BORDER - ship.y[ping];
  double dyu = ship.y[(int)ping] - 128 - D2BORDER;
  double dxdest = fabs(dxr)<fabs(dxl)? dxr:dxl;
  double dydest = fabs(dyo)<fabs(dyu)? dyo:dyu;
  double dist = sqrt(dxdest*dxdest+dydest*dydest);

  int dind=0;

  dind = kToInd(dxdest,dydest);
  dind -= ship.ind[ping];

  while(dind>  128) dind-=256;
  while(dind<=-128) dind+=256;
  nDPH = dind /3;             // Ganzahlanteil der notwendigen Turns
  if(     dind > 0 &&  dind %3 > 1) nDPH++;  // Nicht genau erreichber -->
  else if(dind < 0 &&(-dind)%3 > 1) nDPH--;  // nchstmglichen Schiffswinkel ansteuern

  double sbrake = -(sqrt(ship.v2[ping]) + 0.24)/lnlam; 
  
  thrust = false;
  if(sbrake < dist -DELTA){
    if( fabs(nDPH)<2) thrust =true;
  }else{
    dxdest = ship.x[ping]     > 512? 1023:0;
    dydest = ship.y[ping]-128 > 384?  768:0;
    dind = kToInd(dxdest,dydest);
    dind -= ship.ind[ping];
    
    while(dind>  128) dind-=256;
    while(dind<=-128) dind+=256;
    nDPH = dind /3;             // Ganzahlanteil der notwendigen Turns
    if(     dind > 0 &&  dind %3 > 1) nDPH++;  // Nicht genau erreichber -->
    else if(dind < 0 &&(-dind)%3 > 1) nDPH--;  // nchstmglichen Schiffswinkel ansteuern
  }
}

void ExamplePlayer::TurnToNextBorders(const GameStatus& state, KeysPacket &keys){
  double dxdest = ship.ix     > 512? 1023-ship.ix :  -ship.ix;
  double dydest = ship.iy-128 > 384?  896-ship.iy:128-ship.iy;
  if(fabs(dxdest)<fabs(dydest)&&dxdest!=0)dydest=0;
  else if(dydest!=0)                      dxdest=0;
  int dind=0;
  dind = kToInd(dxdest,dydest);
  dind -= ship.ind[state.keysPing];
  
  while(dind>  128) dind-=256;
  while(dind<=-128) dind+=256;
  int nDPH = dind /3;             // Ganzahlanteil der notwendigen Turns
  if(     dind > 0 &&  dind %3 > 1) nDPH++;  // Nicht genau erreichber -->
  else if(dind < 0 &&(-dind)%3 > 1) nDPH--;  // nchstmglichen Schiffswinkel ansteuern

  if (nDPH > 0){
    keys.left(true);
    ship.TurnLeft(state.keysPing);
  }
  if(nDPH<0){
    keys.right(true);
    ship.TurnRight(state.keysPing);
  }
}

ExamplePlayer::ExamplePlayer(void)
  :   nTrackedShots(0),
      nTrackedAst(0),
      slsSetFlag(false),
      slsGetFlag(false),
      slsShot(0),
      nSlsOff(0),
      ShotHS(0),
      sMinDistHS(0),
      aMinDistHS(0),
      TtcHS(0),
      allHS(0),
      nextShotID(0),
      nextAstID(0),
      lSaucerID(0x7FFFFFFF),
      fire(true),
      iLshotId(0x7FFFFFFF),
      loaded(true),
      thrust(false),
      tlhyper(0),
      nownshots(0){
  for(int i=0;i<MAX_ASTEROIDS;i++) ttc[i].t=MAXFLOAT;
  for(int i=0;i<4;i++)slsPraed[i]=0;
}
void ExamplePlayer::TrackShots(const GameStatus& state ){
  bool raw_matched;
  int  cleared;
  int  nshots;

  cleared=0;
  nshots = state.nshots;

  for(int i=0;i<nTrackedShots;i++)  shots[i].matched=false;

  for (int i = 0; i < nshots; i++){     //Schleife ber alle raw_shots
    const Shot *r_a = &state.raw_shots[i];
    raw_matched=false;                  // aktueller Schuss noch nicht getracked
    for(int j = 0; j < nTrackedShots; j++) {  //Schleife ber alle bereits vorhandenen tracks
      TrackedShot *t_a = &shots[j];
      if(t_a->matched) continue;
      if (t_a->Match(*r_a,state.latenz)){   
	//	OutputInfo2("Matched Shot t=%d, id = %d\n",state.t, t_a->id);
	raw_matched = true;   
	break;
      }
    }
    if(!raw_matched) {                  // Keinen Track fr Schuss gefunden --> neuer Track
      TrackedShot *t_a = &shots[nTrackedShots];
      t_a->init(*r_a, ship, saucer, state, nextShotID++);
      if(t_a->own_shot) nOwnShotsTotIst++;
      t_a->matched=true;
      incTrackedShots();
    }
  }

  for(int i = 0; i < nTrackedShots; i++) {
    if(!shots[i].matched)cleared++;
  }

  for(int i = 0; i < nTrackedShots; i++){ // Schleife ber alle bereits vorhandenen Tracks
    for(int j = i; j < nTrackedShots; j++)
      if(!shots[i].matched){
	for(int k=i; k < nTrackedShots-1; k++){
	  shots[k] = shots[k+1];
	}
	shots[nTrackedShots-1].clear();
      }
  }

  subTrackedShots(cleared);

  if(nTrackedShots!=nshots){
    OutputError2("Shot Tracking Error %d|%d matched: %d\n",nTrackedShots,nshots,shots[nTrackedShots].matched);
  }
  nownshots=0;
  for(int i =0; i< nshots; i++){
    shots[i].tta = MAXFLOAT;
    shots[i].taggedId = MAXINT;
    if (shots[i].own_shot ) nownshots++;
  }
  //  nOwnShotsTot = nextShotID;
}

void TrackedAsteroid::Dist(const Ship& ship){
  dist((double)x,(double)y,(int)ship.ix,(int)ship.iy,dx,dy,d);
  double r=radius+RADIUS_SCHIFF;
  d = d-r;
}
void ExamplePlayer::incTrackedShots(){
  nTrackedShots++;
  if(nTrackedShots>MAX_SHOTS){
    OutputError("Zu viele Tracked Shots, clipping!!!\n");
    nTrackedShots = MAX_SHOTS;
  }
}
void ExamplePlayer::subTrackedShots(const int& cleared){
  nTrackedShots -= cleared;
  if(nTrackedShots<0){
    OutputError("Zu viele Tracked Shots gelscht, clipping auf 0!!!\n");
    nTrackedShots = 0;
  }
}

void ExamplePlayer::incTrackedAst(){
  nTrackedAst++;
  if(nTrackedAst>MAX_ASTEROIDS){
    OutputError("Zu viele Tracked Asteroids, clipping!!!\n");
    nTrackedShots = MAX_SHOTS;
  }
}
void ExamplePlayer::subTrackedAst(const int& cleared){
  nTrackedAst -= cleared;
  if(nTrackedAst<0){
    OutputError("Zu viele Tracked Asteroids gelscht, clipping auf 0!!!\n");
    nTrackedAst = 0;
  }
}

void ExamplePlayer::TrackAsteroids(const GameStatus& state){
  bool raw_matched;
  int  cleared;
  int nasteroids;

  cleared = 0;
  nasteroids = state.nasteroids;

  for(int i=0;i<nTrackedAst;i++){
    asteroids[i].matched=false;
    asteroids[i].exploded=false;
  }
  
  for(int iex=0; iex<state.nexplosions;iex++){
    if(iex == iSaucerExplosion) continue;
    for(int i = 0; i < nTrackedAst; i++) {  //Schleife ber alle bereits vorhandenen tracks
      TrackedAsteroid *t_a = &asteroids[i];
      if(!t_a->exploded
	 && t_a->ix==state.explosion[iex].ix 
	 && t_a->iy==state.explosion[iex].iy){
	t_a->exploded = true;
	break;
      }
    }
  }

  for(int i=0;i<nTrackedAst;i++)  asteroids[i].matched=false;


  for (int i = 0; i < nasteroids; i++){ //Schleife ber alle raw_asteroids
    const Asteroid *r_a = &state.raw_asteroids[i];
    raw_matched = false;  // aktueller Asteroid noch nicht getracked
    for(int j = 0; j < nTrackedAst; j++) {  //Schleife ber alle bereits vorhandenen tracks
      TrackedAsteroid *t_a = &asteroids[j];
      if(t_a->matched || t_a->exploded) continue;  // Track schon gematched oder explodiert --> continue
      if (t_a->Match(*r_a,state)){      // 
	raw_matched = true;       // Track fr Messung gefunden
	break;
      }
    }

    if(!raw_matched) { // Keinen Track fr Asteroid gefunden --> neuer Track
      TrackedAsteroid *t_a = &asteroids[nTrackedAst];
      t_a->init(*r_a,state, nextAstID++);
      t_a->matched=true;
      nTrackedAst++;
    }
  }
  for(int i = 0; i < nTrackedAst; i++){
    if(!asteroids[i].matched){
      if(!asteroids[i].exploded) OutputInfo("Asteroid nicht explodiert! ");
      cleared++;
      trackedPoints += asteroids[i].points;
    }
  }

  for(int i = 0; i < nTrackedAst; i++){ // Schleife ber alle bereits vorhandenen Tracks
    for(int j = i; j < nTrackedAst; j++)
      if(!asteroids[i].matched){
	for(int k=i; k < nTrackedAst-1; k++){
	  asteroids[k] = asteroids[k+1];
	}
	asteroids[nTrackedAst-1].clear();
      }
  }
  subTrackedAst(cleared);
  if(nTrackedAst!=nasteroids){
    OutputError2("Asteroid Tracking Error %d | %d, matched: %d\n",nTrackedAst,nasteroids, asteroids[nTrackedAst].matched);
  }
  nTotTrackedAst = nextAstID;
}

bool TrackedShip::shootThisFirst(int curr, int reqShots, int other){
  bool yes=false;
  yes = fd[curr] < fd[other] + fabs(nDPH[curr]-nDPH[other]);
  return yes;
}
bool ExamplePlayer::shootThisFirst(const int& curr, const int& nasteroids, int& iShootThis){ 
  bool yes = true;
  iShootThis=curr;
  for(int i=0;i<nasteroids;i++){
    if(i!=curr && !cflag[i]
       && ship.fd[curr] > ship.fd[i] +fabs(ship.nDPH[curr]) + 2*fabs(ship.nDPH[curr]-ship.nDPH[i])  
       && (curr == isaucer || asteroids[curr].ttc > ship.fd[i] + fabs(ship.nDPH[curr]-ship.nDPH[i] + 3))
       && ttns[1]<=ship.fd[curr]){ 
      iShootThis=i;
      yes = false;
#ifdef OUTPUT
      OutputInfo2("Shoot first %s %d before %s %d ",asteroids[i].name, asteroids[i].id, 
		  curr==isaucer?saucer.name:asteroids[curr].name,
		  curr==isaucer?saucer.id:asteroids[curr].id);
      break;
#endif
    }
  }
  return yes;
}

void TrackedShip::Turn(const unsigned char& keysPing){
  unsigned char kp1 = M(keysPing+1); // wird erst mit dem nchsten keysPing gesendet
  ind[kp1] = ind[keysPing] + 3 * turn[keysPing] ;
  indWrap(ind[kp1]);
  //OutputInfo2("Turn ind[%d]=%d=%d + 3 * (%d) ", kp1,ind[kp1],ind[keysPing], turn[keysPing]);
}
void TrackedShip::TurnLeft(const unsigned char& keysPing){
  turn[keysPing] = 1;
  Turn(keysPing);
}
void TrackedShip::TurnRight(const unsigned char& keysPing){
  turn[keysPing] = -1;
  Turn(keysPing);
}

#if 0
void TrackedShip::predict(const GameStatus& state, const int& frames){
  if(state.ping>=frames){
    unsigned char ping = M(state.framePing+frames);
    xpd = xp[ping];
    ypd = yp[ping];
    xd  =  x[ping];
    yd  =  y[ping];
  } else{
    unsigned char ping = M(state.framePing+frames);
    double f=exp(ping*LNLAM);
    xpd = floor(xp[state.keysPing] * f * 8) / 8.;
    ypd = floor(yp[state.keysPing] * f * 8) / 8.;
    xd  = x[state.keysPing] + floor(xp[state.keysPing]/LNLAM*(f-1)*8)/8.;
    yd  = y[state.keysPing] + floor(yp[state.keysPing]/LNLAM*(f-1)*8)/8.;
  }
}
#endif 
void TrackedShip::set(const GameStatus& state){
  ix = state.ship.ix;
  iy = state.ship.iy;
  dx = state.ship.dx;
  dy = state.ship.dy;
  //  OutputInfo2(" Ship %s present, ix=%d, iy=%d\n",present?"IS":"NOT",ix,iy);
  if(state.ship.IsPresent()){
    if(!present) {
      lx=ix;
      ly=iy;
      
      x[(state.keysPing)] = ix; // TODO: Nachkommastellen bewahren
      y[(state.keysPing)] = iy;
      //OutputInfo2("coord reset x[%d]=%6.3f, y[%d]=%6.4f\n",state.framePing,x[state.framePing],state.framePing,y[state.framePing]);
    }
    dx = state.ship.dx;
    dy = state.ship.dy;
    turn[state.keysPing] = 0; 
    Align(state);
    for(int i=0;i<state.nasteroids+1;i++){
      indphkd[i]=
	ts     [i]=
	fd     [i]=
	nDPH   [i]= // 0 no turn, >0 left, <0 right
	sls    [i]= MAXINT;
      fire   [i]=
	oofFire[i]=false;
      ttd    [i]= MAXFLOAT;// Time to destruct, auer UFO!
    }
    
  } else if(present){    // War im vorherigen Frame noch da
    unsigned char km1 = M(state.keysPing - 1); // Winkelbyte merken
#ifdef VERBOSE
    OutputInfo2("Hyper-save km1=%d: vorher: ",km1);
    for (int u=0;u<INDSIZE;u++){
      OutputInfo2("%3d ", ind[u]);
      if((u+1)%32==0) OutputInfo("\n");
    }
#endif
    for(int u=0; u<INDSIZE; u++) {
      ind[M(km1+u)] = ind[km1];
    }

    OutputInfo2("nacher: ");
    for (int u=0;u<INDSIZE;u++){
      OutputInfo2("%3d ", ind[u]);
      if((u+1)%32==0) OutputInfo("\n");
    }
    
  }
  present = state.ship.IsPresent();
}

void indWrap(int& _ind){
  if (_ind >= 256) _ind -= 256;
  if (_ind <    0) _ind += 256;
  if (_ind >= 256 || _ind<0){
    OutputError2("Fehler in indWrap ind=%d ---------------\n",_ind);
    _ind=0;
  }
}

void angWrap(double &ang){
  while (ang >= M_PI) ang -= M_TWOPI;
  while (ang < -M_PI) ang += M_TWOPI;
}

double octWrap(const double &_ang){
  double ang=_ang;
  while (ang >= M_PI/8.) ang -= M_PI/4.;
  while (ang < -M_PI/8. ) ang += M_PI/4.;
  return ang;
}


double fastatan2(const double& y, const double& x){ // doppelt so schnell wie atan2 in math.h
  double erg=0;
  if(x==0)
    if(y==0)      erg =  0;
    else if(y>0)  erg =  M_PI_2;
    else          erg = -M_PI_2;
  else{
    double z = y/x;
    if(fabs(z)<=1) erg = z/(1+0.28*z*z);
    else if(z>1)   erg =  M_PI_2 - z/(z*z+0.28);
    else           erg = -M_PI_2 - z/(z*z+0.28);
    if(x<0)
      if(y>0)       erg = erg + M_PI;
      else          erg = erg - M_PI; // Unterschied zu atan2
  }
  return erg;
}

int kToInd(const double& kx, const double& ky){
  double ph=fastatan2(ky,kx);
  int ind=phToInd(ph);
  return ind;
}

int phToInd(const double& ph){
  int ind=-1;
  double minDPH=MAXFLOAT;
  int indf = int(ph/DPH) - 64;
  for(int i=-2;i<=2;i++){
    int iind = indf+i;
    indWrap(iind);
    double dph=fabs(shotph[iind]-ph);
    if(dph<minDPH){
      minDPH=dph;
      ind=iind;
    }
  }
  return ind;
}

void TrackedShip::Align(const GameStatus& state){
  int newind;
  unsigned char fp  = state.keysPing;
  unsigned char fm1 = M(fp-1);
  unsigned char fm2 = M(fp-2);
  //  unsigned char fp1 = M(fp+1);
  
  if(dx==0){
    if(dy==1536)        ind[fm1] = 0;
    else if(dy==-1536)  ind[fm1] = 128;
  }

  // Kleiner Offset
  if(dx != phx[ind[fm1]] || dy != phy[ind[fm1]]){
    if(dx==phx[ind[fm2]] && dy == phy[ind[fm2]]){      // 1 Frame Delay:
      OutputInfo2("%6d: Frame-Delay ind[%d]=%d, ind[%d]=%d dx=%d, dy=%d ",state.frameno, fm2,ind[fm2],fm1,ind[fm1],dx,dy);
      for (int u=0;u<INDSIZE;u++){
       	OutputInfo2("%3d ", ind[u]);
       	if((u+1)%32==0) OutputInfo("\n");
      }
      OutputInfo("\n");
      ind[fm1]= ind[fm2];
    }else{
      int ii[12];
      int nii;
      if(state.ping!=0){
	nii = 4;
	ii[0] = -3;
	ii[1] = 3;
	ii[2] = -6;
	ii[3] = 6;
      } else{
	nii = 12;
	for(int iii=0; iii < nii/2; iii++) {
	  ii[iii] = iii+1;
	  ii[iii+nii/2] = -ii[iii];
	}
      }
      for(int i = 0; i <nii ; i++){
	newind = ind[fm1] + ii[i];
	indWrap(newind);
	if (dx == phx[newind] && dy == phy[newind]){
	  OutputInfo2("%6d: Kleiner Offset %d!=%d || %d!=%d, fp=%d, fm1=%d, fm2=%d,  ",state.frameno,dx, phx[ind[fm1]],dy,phy[ind[fm1]],fp,fm1,fm2);
	  OutputInfo2("framePing=%d, ind[%d]=%d newind=%d ",state.framePing, fm1,ind[fm1],newind);
	  ind[fm1] = newind;
	  OutputInfo2("Kleiner Offset: newind=%d, fm1=%d ",newind,fm1);
	  for (int u=0;u<INDSIZE;u++){
	    OutputInfo2("ind[%d]:%3d ",u, ind[u]);
	    if((u+1)%32==0) OutputInfo("\n");
	  }
	  OutputInfo("\n");
	  break;
	}
      } 
    } 
  }
  // Groer Offset
  if(dx != phx[ind[fm1]] || dy != phy[ind[fm1]]){
    for(int i=0; i<256*3; i += 3){
      newind = i;
      indWrap(newind);
      if(dx == phx[newind] && dy ==phy[newind]){
	OutputInfo2("Groer Offset %d!=%d || %d!=%d ",dx, phx[ind[fm1]],dy,phy[ind[fm1]]);
	OutputInfo2("framePing=%d, ind[%d]=%d newind=%d ",state.framePing, fm1,ind[fm1],newind);
	ind[fm1]=newind;
	ind[fp] = ind[fm1] + 3*turn[fm1];
	OutputInfo2("Groer Offset: newind=%d, fm1=%d ",newind,fm1);
	for (int u=0;u<INDSIZE;u++){
	  OutputInfo2("%3d ", ind[u]);
	  if((u+1 )%32==0&&u>0) OutputInfo("\n");
	}
	OutputInfo("\n");
	break;
      }
    }
  }


  for(int i=0; i <= state.ping;i++){
    //     OutputInfo2("Align: ping = %d, framePing=%d, keysPing=%d\n",state.ping,state.framePing, state.keysPing);
    unsigned char ping1 = M(fp + i - 1);
    unsigned char ping2 = M(fp + i);
    ind[ping2] = ind[ping1] + 3*turn[ping1];
    indWrap(ind[ping2]);
  }


}
#if 1
double subRound(const double& z){
  return (floor(z*8)/8.);
}
#else
double subRound(double z){
  return double(int(z*8)/8.);
}
#endif
void TrackedShip::Speed(const GameStatus& state, const bool& _thrust){
  ixp = (ix-lx)/(1+state.latenz);
  iyp = (iy-ly)/(1+state.latenz);

  normWrap(ixp,iyp);
  unsigned char kp  = state.keysPing;
  unsigned char kp1 = M(kp + 1);
  
  thrust[kp] = _thrust;
  if(thrust[kp]){
    if(state.accFrame){

      OutputInfo2("---------------- THRUST -----------------\n");
      xpp = astcos[ind[kp]];
      ypp = astsin[ind[kp]];
      xp[kp1] = xp[kp] + xpp;
      yp[kp1] = yp[kp] + ypp;
    } else{
      xp[kp1] = xp[kp]+xpp;
      yp[kp1] = yp[kp]+ypp;
      xpp=ypp=0;
    }    
  } else {
    xp[kp1] = xp[kp] - floor(xp[kp])/128;
    if(xp[kp] > 0){
      xp[kp1] -= 1./256.;
      if(xp[kp] < 1.25 && xp[kp] >1) xp[kp] -= 0.25;
    }

    yp[kp1] = yp[kp] - floor(yp[kp])/128;
    if(yp[kp] > 0) yp[kp1] -= 1./256.;
    
  }

  x [kp1] =  x[kp] + floor(xp[kp1])/8;
  y [kp1] =  y[kp] + floor(yp[kp1])/8;

  v2[kp] = xp[kp]*xp[kp]+yp[kp]*yp[kp];
  lx = ix;
  ly = iy;


  //  OutputInfo2("xp[%d]=%f, yp[%d]=%f, x[%d]=%f, y[%d]=%f, ix=%d,iy=%d\n",
  //      kp1,xp[kp1],kp1,yp[kp1],kp1,x[kp1],kp1,y[kp1],ix,iy);



}
void TrackedShip::Aim(const TrackedAsteroid& a,const int& i, const GameStatus& state){

  aim.xobj     = a.x;
  aim.yobj     = a.y;
  
  aim.obj_xp = a.xp;
  aim.obj_yp = a.yp;
  aim.obj_v2 = a.v2;
  aim.radius = a.radius;
  aim.deltaX = a.deltaX;
  aim.deltaY = a.deltaY;
  Aim(i,state);

}
void TrackedShip::Aim(const TrackedSaucer& a, const int& i, const GameStatus& state){

  aim.xobj     = a.ix;
  aim.yobj     = a.iy;

  aim.obj_xp = a.xp;
  aim.obj_yp = a.yp;
  aim.obj_v2 = a.v2;
  aim.radius = a.radius;
  aim.deltaX = 2;
  aim.deltaY = 2;
  Aim(i,state);

}
void TrackedShip::Aim(const int& iObject, const GameStatus& state){

  unsigned char kp1 = M(state.keysPing);

  aim.indphs = ind[kp1];
  nDPH[iObject]=MAXINT;
  aim.ping = 2*state.ping + FRAME_DELAY;
  for (int i  = 0; i < MAX_PRAED; i++){
    //    predict(state, aim.ping + FRAME_DELAY); // TODO
    aim.fd   = i + aim.ping;
    //    aim.sls  = state.shotLifeSpan[(aim.fd+1) %4]  ; // ShotLifeSpan zum Zeitpunkt des Schusses
    aim.sls  = state.shotLifeSpan[(aim.fd+1) &3]  ; // ShotLifeSpan zum Zeitpunkt des Schusses

    double xobjPraed = aim.xobj + aim.fd*aim.obj_xp;
    double yobjPraed = aim.yobj + aim.fd*aim.obj_yp;
    normxy(xobjPraed, yobjPraed);
    double ixobjPraed = aim.xobj + FRAME_DELAY*aim.obj_xp;
    double iyobjPraed = aim.yobj + FRAME_DELAY*aim.obj_yp;
    normxy(ixobjPraed, iyobjPraed);
    aim.idx =  ixobjPraed - ix;
    aim.idy =  iyobjPraed - iy;
    aim.dx  =  xobjPraed  - ix; 
    aim.dy  =  yobjPraed  - iy ;
    normWrap(aim.dx, aim.dy);
    aim.d2  = aim.dx*aim.dx + aim.dy*aim.dy;

    if(!aim.AimF()){
      double xabs=ix+round(aim.ts*shotdxp[aim.indphkd]);
      double yabs=iy+round(aim.ts*shotdyp[aim.indphkd]);
      if(fabs(xabs     ) > 1      // Grenze x=0
	 && fabs(xabs-1023) > 1   // Grenze x=1023
	 && fabs(yabs-128 ) > 1   // Grenze y=128
	 && fabs(yabs-895 ) > 1 ) // Grenze y=896
	break; // Nur Schsse, die nicht am Rand landen abgeben
    }
  }

  indphkd[iObject] = aim.indphkd;
  nDPH[iObject]    = aim.nDPH;               
  ts  [iObject]    = int(aim.ts+0.01);
  fd  [iObject]    = aim.fd;
  fire[iObject]    = aim.fire;
  oofFire[iObject] = aim.oofFire;
  ttd [iObject]    = aim.fd /*+ aim.ts*/;  // time to destruct
  sls [iObject]    = aim.sls;
}

bool AimC::AimF(void){
  int ind;

  bool again = true;

  // Lsung Ax^2+Bx+C--> x = -C/B fr A=0, x=(-B+-sqrt(B^2-4AC))/2A, x=0 fr A=B=0;
  // d + t.dp = 



  fire = false;
  oofFire = false;
  ind=indphs; // Startwert

  for(int i=0;i<2;i++){ // Iteration fr exakte Schussgeschwindigkeit notwendig

    double vschuss2 = shotSpeed2[ind];
    
    ts=0;
    double A = obj_v2 - vschuss2;           // wg. A<0, C>0, D=B-4AC gilt: B<sqrt(D) --> ts1<0, ts2>0, 
    double B = 2*(dx*obj_xp + dy*obj_yp); //      
    double C = d2;                           
    
    double ts1, ts2;
    switch(gsl_poly_solve_quadratic (A, B, C, &ts1, &ts2)){
      case 0:
	ts=-1;
	nDPH=MAXINT;
	break;
      case 1:
	ts = ts1;
	break;
      case 2:
	ts = ts2;
	break;
    }	
    if(ts<0){
      indphkd= 0;
      nDPH   = MAXINT;               
      fd     = MAXINT;
      fire   = false;
      oofFire= false;
      sls    = 0;
      return false;
    }
	
    ts=round(ts);
    kx = dx + ts*obj_xp;
    ky = dy + ts*obj_yp;
    
    indphkd = kToInd(kx,ky);
    if(ind==indphkd) break;  // Schiff steht schon richtig --> keine Iteration notwendig
    ind=indphkd;
  }

  int dind = indphkd - indphs;    // Index-Abstand
  while(dind>  128) dind-=256;
  while(dind<=-128) dind+=256;
  nDPH = dind / 3;                            // Ganzahlanteil der notwendigen Turns zum optimalen Vektor
  if(     dind > 0 &&  dind - 3*nDPH > 1) nDPH++;  // Nicht genau erreichber -->
  else if(dind < 0 &&(-dind)+ 3*nDPH > 1) nDPH--;  // nchstmglichen Schiffswinkel ansteuern
  
  indphkd = indphs + 3*nDPH;
  indWrap(indphkd);

#if 1
  double kxd  = ts*shotdxp[indphkd]; // Schiffs-Schussvektor mit exakter Geschindigkeit 
  double kyd  = ts*shotdyp[indphkd]; 
  double fx = abs(kx-kxd)+deltaX;
  double fy = abs(ky-kyd)+deltaY;
  if(ts<=sls && collCheck(fx,fy,radius)){ 
    if( fabs(nDPH) + ping <= fd){
      again=false;
      if( nDPH==0 && fd == ping ){
	fire = true; // Schiff steht richtig --> Fire
      }
    }
  } else {
    double nts=calcTtc(idx,idy,obj_xp-shotdxp[indphs],obj_yp-shotdyp[indphs],radius);
    kx = idx + nts*obj_xp;
    ky = idy + nts*obj_yp;
    kxd  = nts*shotdxp[indphs]; // Schiffs-Schussvektor mit exakter Geschindigkeit 
    kyd  = nts*shotdyp[indphs]; 
    fx = abs(kx-kxd)+deltaX;     
    fy = abs(ky-kyd)+deltaY;     
    if(nts<=sls && collCheck(fx,fy,radius)){ 
      again=false;
      oofFire = true; // Schiff steht richtig --> Fire
    }
  }
#else
  int sdph;
  if(nDPH>=0) sdph= 1;
  else        sdph=-1;
  for(int i=0;i<=abs(nDPH);i++){
    int idph = i*sdph;
    indphkd = indphs + 3*idph;
    indWrap(indphkd);

    double kxd  = ts*shotdxp[indphkd]; // Schiffs-Schussvektor mit exakter Geschindigkeit 
    double kyd  = ts*shotdyp[indphkd]; 
    double fx = kx-kxd;
    double fy = ky-kyd;
    if(ts<=sls && collCheck(fx,fy,radius)){ 
      if( fabs(idph) + ping <= fd){
	again=false;
	if( idph==0 && fd == ping ){
	  if(idph!=nDPH) oofFire=true;
	  else 	    fire = true; // Schiff steht richtig --> Fire
	  break;
	}
      }
    }
  }
#endif
  return again;
}

TrackedShip::TrackedShip(void){
  OutputInfo("Game started ");
  present = false;
  dx = 1536;
  dy = 0;
  naccel = t=0;
  xpp=ypp=lx=ly=0;
  accelFrame = false;

  for(int i=0;i<INDSIZE;i++){
    ind     [i] = 192;
    thrust  [i] = false;
    taggedId[i] = MAXINT;
    turn    [i] = 0;
    xp      [i] = 0;
    yp      [i] = 0;
    v2      [i] = 0;
    x       [i] = 0;
    y       [i] = 0;
  }
  for(int i=0; i<MAX_ASTEROIDS+1;i++){
    indphkd[i] = 192;
    ts     [i] = 0       ;
    fd      [i] = MAXINT;
    fire    [i] = false;
    oofFire [i] = false;
    nDPH    [i] = MAXINT;
    ttd     [i] = MAXINT;
    sls    [i] = 0       ;

    
  }
}              

TrackedShip& TrackedShip::operator=(const TrackedShip& p){
  if (this != &p){
    dx = p.dx;
    dy = p.dy;
    present = p.present;
    xpp = p.xpp;
    ypp = p.ypp;
    lx = p.lx;
    ly = p.ly;
    xd = p.xd;
    yd = p.yd;
    lixp = p.lixp;
    liyp = p.liyp;
    lxp = p.lxp;
    lyp = p.lyp;
    ixp = p.ixp;
    iyp = p.iyp;
    xpd = p.xpd;
    ypd =p.ypd;
    t = p.t;
    accelFrame = p.accelFrame;
    naccel = p.naccel;
    aim = p.aim;
    for( int i=0;i<INDSIZE;i++){
      ind   [i] = p.ind   [i];
      turn  [i] = p.turn  [i];
      thrust[i] = p.thrust[i];
      xp    [i] = p.xp    [i];
      yp    [i] = p.yp    [i];
      v2    [i] = p.v2    [i];
      x     [i] = p.x     [i];
      y     [i] = p.y     [i];
      taggedId[i]=p.taggedId[i];
    }
    for(int i=0; i<MAX_ASTEROIDS+1;i++){
      indphkd[i]= p.indphkd[i];
      ts     [i]= p.ts     [i];
      fire   [i]= p.fire   [i];
      nDPH   [i]= p.nDPH   [i];
      fd     [i]= p.fd     [i];
      ttd    [i]= p.ttd    [i];
      sls    [i]= p.sls    [i];
    } 
  }
  return *this;
}


// Schneller aber ungenauer, bei Bedarf wieder aktivieren
double ncalcTtc(const double& dx, const double& dy, const double& dxp, const double& dyp, const int& radius){
  double ttc = MAXFLOAT;
  if(dxp == 0 && dyp == 0) return ttc; 
  double wx[3] = {0,-1024,1024};
  double wy[3] = {0, -768, 768};
  double minD2=MAXFLOAT;
  for(int ix=0;ix<1;ix++){
    for(int iy=0;iy<1;iy++){
      double wdx = dx + wx[ix];
      double wdy = dy + wy[iy];
      double tmpttc = -(dxp*wdx+dyp*wdy)/(dxp*dxp+dyp*dyp); // least square d+ttc.dp=0 --> ttc = -(dpT.d)/(dpT.dp)
      if(tmpttc>=0 && tmpttc < ttc){
	double x = wdx + tmpttc*dxp; // Minimaler
	double y = wdy + tmpttc*dyp; // Abstand
	double tmpD2=x*x+y*y;
	if(tmpD2 < minD2){
	  minD2 = tmpD2;
	  ttc = tmpttc;
	}
      }
    }
  }
  if(minD2 > (radius+1)*(radius+1) || ttc < -1) ttc = MAXFLOAT ; // no collision
  else {
    double dttc = (radius-sqrt(minD2))/sqrt(dxp*dxp+dyp*dyp);
    ttc -= dttc;
  }

  return ttc;
}

double icalcTtc(const int& dx, const int& dy, const double& dxp, const double& dyp,const int& radius2){
  double ttc = MAXFLOAT;
  if(dxp == 0 && dyp == 0) return ttc; 
  double A  = dxp*dxp+dyp*dyp;
  double B  = 2*(dx*dxp+dy*dyp);
  double C  = dx*dx+dy*dy-radius2;
  double D2 = B*B-4*A*C;
  if(C<=0) ttc = 0;
  else if(D2>=0){
    double tmp=(-B-sqrt(D2))/(2*A);
    if (tmp>=0)  ttc=tmp;
  }
  return ttc;
}
#if 1

double calcTtc(const double& _dx, const double& _dy, 
	       const double& dxp, const double& dyp,
	       const double& radius){
  double ttc = MAXFLOAT;
  double dx = _dx;
  double dy = _dy;
  double tmin, tmax;
  double txmin=0, tymin=0;
  double txmax=0, tymax=0;
  if(dxp == 0 && dyp == 0) return ttc; // Relativgeschwindigkeit 0 --> ttc=inf

  if(collCheck(dx,dy,radius)){
    ttc = 0;
    return ttc;
  }
  if(dxp==0){
    txmin=0;
    txmax=MAXFLOAT;
  }else if(abs(dx) <= radius){
    txmin = 0;
    txmax = abs(2*radius/dxp);
  } else if (dx < 0 && dxp > 0){
    txmin = -(dx+radius)/dxp;
    txmax = -(dx-radius)/dxp+abs(2*radius/dxp);
  } else if (dx < 0 && dxp < 0){
    dx += 1024;
    txmin = -(dx-radius)/dxp;
    txmax = -(dx+radius)/dxp+abs(2*radius/dxp);
  } else if (dx > 0 && dxp >0){
    dx -= 1024;
    txmin = -(dx+radius)/dxp;
    txmax = -(dx-radius)/dxp+abs(2*radius/dxp);
  } else if (dx > 0 && dxp <0){
    txmin = -(dx-radius)/dxp;
    txmax = -(dx+radius)/dxp+abs(2*radius/dxp);
  } 
  if(dyp==0){
    tymin=0;
    tymax=MAXFLOAT;
  }else if(abs(dy) <= radius){
    tymin = 0;
    tymax = abs(2*radius/dyp);
  } else if (dy < 0 && dyp > 0){
    tymin = -(dy+radius)/dyp;
    tymax = -(dy-radius)/dyp+abs(2*radius/dyp);
  } else if (dy < 0 && dyp < 0){
    dy += 1024;
    tymin = -(dy-radius)/dyp;
    tymax = -(dy+radius)/dyp+abs(2*radius/dyp);
  } else if (dy > 0 && dyp >0){
    dy -= 1024;
    tymin = -(dy+radius)/dyp;
    tymax = -(dy-radius)/dyp+abs(2*radius/dyp);
  } else if (dy > 0 && dyp <0){
    tymin = -(dy-radius)/dyp;
    tymax = -(dy+radius)/dyp+abs(2*radius/dyp);
  } 
      
  tmin = txmin>tymin? txmin:tymin;
  tmin = tmin>0?tmin:0;
  tmax = txmax<tymax? txmax:tymax;
  if(tmin<=tmax){
    double dt = (tmax-tmin)/100;
    if(dt<0.1) dt = 0.1;
    for(double t=floor(tmin);t<=ceil(tmax);t+=0.1){
      double dxd=fabs(dx+t*dxp);
      double dyd=fabs(dy+t*dyp);
      if(collCheck(dxd,dyd, radius)){
	ttc=t;
	break;
      }
    }
  }


  return ttc;
}
#else
double calcTtc(const double& dx, const double& dy, const double& dxp, const double& dyp,const double& radius){
  double ttc = MAXFLOAT;
  if(dxp == 0 && dyp == 0) return ttc; // Relativgeschwindigkeit 0 --> ttc=inf

  if(collCheck(dx,dy,radius)){
    ttc = 0;
    double ottc=ocalcTtc(dx, dy, dxp, dyp,  radius);
    if(ottc<MAXFLOAT || ttc<MAXFLOAT) OutputInfo2(" |ttc=%3.1f, ottc=%3.1f| ",ttc,ottc); 
    return ttc;
  }

  double radius2=radius*radius;

  double A  = dxp*dxp+dyp*dyp;
  double B  = 2*(dx*dxp+dy*dyp);
  double C  = dx*dx+dy*dy-(radius2);

  if(B < 0){                 // Objekte bewegen sich aufeinander zu
    double D2 = B*B-4*A*C;   // = 4(rdp - (d x dp))
    double ttc1=MAXFLOAT;
    double ttc2=MAXFLOAT;
    if(D2 >= 0) ttc1 = (-B - sqrt(D2))/(2*A); // nur die linke Nullstelle   
    if(ttc1 == MAXFLOAT || !collCheck(dx+ttc1*dxp,dy+ttc1*dyp,radius)){
      C  = dx*dx+dy*dy-2.25*2.25*radius2 ;
      D2 = B*B-4*A*C;
      if(D2>=0) ttc2 = (-B - sqrt(D2))/(2*A); 
      if(ttc2 != MAXFLOAT && collCheck(dx+ttc2*dxp,dy+ttc2*dyp,radius)) 
	ttc=ttc2;
    }else ttc=ttc1;
    
    if(ttc<=0) OutputError("TTC-Fehler!!!!!!!!!\n");
  }
  double ottc=ocalcTtc(dx, dy, dxp, dyp,  radius);
  if(ottc<MAXFLOAT || ttc<MAXFLOAT || ottc<5) OutputInfo2(" |ttc=%3.1f, ottc=%3.1f| ",ttc,ottc); 
  return ottc;
}
#endif

int calcMinDist(const Track& a, const Track &s, const int& radius2 ){
  int ttc = MAXINT;
  int dx = int(a.x + 0.5) - int(s.x + 0.5);
  int dy = int(a.y + 0.5) - int(s.y + 0.5);
  normWrap(dx,dy);
  int d2 = dx*dx + dy*dy;
  int mind2 = d2;
  
  if(d2 <= radius2){
    ttc = 0;
  }else{
    for(int t=1; t<72; t++){
      int ax = int(a.x + t*a.xp + 0.5);
      int ay = int(a.y + t*a.yp + 0.5);
      //normxy(ax,ay);
      int sx = int(s.x + t*s.xp + 0.5);
      int sy = int(s.y + t*s.yp + 0.5);
      //normxy(sx,sy);
      dx = ax - sx;
      dy = ay - sy;
      normWrap(dx,dy);
      d2 = dx*dx + dy*dy;
      if (d2 < mind2){
	mind2 = d2;
	if(d2 <= radius2){
	  ttc = t;
	  break;
	}
      }
    }
  }
  return ttc;
} 

void Track::Ttc(const double& radius, const Ship& ship){
  double dx=x-ship.ix;
  double dy=y-ship.iy;
  normWrap(dx,dy);
  ttc = calcTtc(dx,dy,xp,yp,radius + RADIUS_SCHIFF);
}

// int TrackedShot::Ttc(const TrackedAsteroid& a){
//   int ttc = calcMinDist(a,*this,a.korr2+ 2*a.korr + 1);
//   return ttc;
// }
// int TrackedShot::Ttc(const TrackedSaucer& a){
//   Track at;
//   at.x = a.ix;
//   at.y = a.iy;
//   at.xp= a.xp;
//   at.yp= a.yp;
//   int ttc = calcMinDist(at,*this,a.korr2+ 2*a.korr + 1);
//   return ttc;
// }

 double TrackedShot::Ttc(const TrackedAsteroid& a){
   double dxa;  
   double dya;  
   double dxap; 
   double dyap; 
   if(age < 8){
     dxa  = ix - a.x;
     dya  = iy - a.y;
     dxap = xp0 - a.xp;
     dyap = yp0 - a.yp;
   } else{
     dxa  = x - a.x;
     dya  = y - a.y;
     dxap = xp - a.xp;
     dyap = yp - a.yp;
   } 
   normWrap(dxa,dya);
   normWrap(dxap,dyap);
   double ttc = calcTtc(dxa,dya,dxap,dyap,a.radius); // Time to asteroid
   return ttc;
 }

 double TrackedShot::Ttc(const TrackedSaucer& a){
   double dxa;  
   double dya;  
   double dxap; 
   double dyap; 
   if(age < 8){
     dxa = ix - a.ix;
     dya = iy - a.iy;
     dxap = xp0 - a.xp;
     dyap = yp0 - a.yp;
   } else{
     dxa = x - a.ix;
     dya = y - a.iy;
     dxap = xp-a.xp;
     dyap = yp-a.yp;
   }
   normWrap(dxa,dya);
   normWrap(dxap,dyap);
   double ttc = calcTtc(dxa,dya,dxap,dyap,a.radius); // Time to saucer
   return ttc;
 }
double TrackedAsteroid::Ttc(const TrackedShip& ship){
  Track::Ttc(radius, ship);
  return ttc;
}
void TrackedShot::Dist(const Ship& ship){
  dist(x,y,ship.ix,ship.iy,dx,dy,d);
  double r=RADIUS_SCHIFF;
  d = d - r;
}
void TrackedShot::Dist(const Saucer& saucer){
  dist(x,y,saucer.ix,saucer.iy,sdx,sdy,sd);
  sd = sd - saucer.radius;
}

void TrackedShot::init(const Shot& shot, const TrackedShip& ship, const TrackedSaucer& saucer, const GameStatus& state, const int& _id){
#ifdef SIMULATION
  OutputInfo(" Init Shot ");
#endif
  age=0;
  dsigma_init = 12*12;
  dsigma     =  2*2;
  id = _id;

  Shot::set(shot.ix,shot.iy);
  xp0=yp0=0;
  x=ix;
  y=iy;
  Dist(ship);
  own_shot=true;
  if(saucer.IsPresent()){
    Dist(saucer);
#ifdef SIMULATION
    if(sd<=d)OutputInfo(" Init Saucershot ");
#endif
    if(sd<=d) own_shot=false;
  }

  if(own_shot){
    int km2=M(state.keysPing-2);
    taggedIdAimed = taggedId= ship.taggedId[km2];
    if(taggedId==MAXINT) OutputInfo2("Shot without Tag");
    int fp = M(state.framePing-2);
    shipind = ship.ind[fp];
    xp0 = shotdxp[shipind];
    yp0 = shotdyp[shipind];
  } else taggedId = MAXINT;

#ifdef OUTPUT
  if(own_shot) strcpy(name,"own");
  else         strcpy(name,"saucer");
#endif

  set(shot,state.latenz);
  sls=state.shotLifeSpan[0];
}
void TrackedShot::clear(){
  Track::clear(ix,iy);
}
void TrackedShot::set(const Shot& shot,const int& latenz){
  Shot::set(shot.ix,shot.iy);
  Track::set(shot.ix,shot.iy,latenz,x,y);
}

void TrackedShot::Ttc(const Ship& ship){
  if(age<8){
    double dx=ix-ship.ix;
    double dy=iy-ship.iy;
    normWrap(dx,dy);
    ttc = calcTtc(dx,dy,xp0,yp0,RADIUS_SCHIFF);
  }else  Track::Ttc(0,ship);
}
bool Track::Match(const int& ix, const int& iy, const int& xn, const int& yn,const int& latenz){
  matched = false;
  double dxd = ix + (latenz+1)*xp - xn;
  double dyd = iy + (latenz+1)*yp - yn;
  normWrap(dxd,dyd);
  double dd=dxd*dxd+dyd*dyd;
  double ds=8;

	  
  if (age<2)     ds=(1+latenz)*dsigma_init;
  else if(age<4) ds=(1+latenz)*dsigma_init/4;
  else           ds=(1+latenz)*dsigma;
  if(dd < ds){
    matched=true;   // Prdiktion passt, max. 1 Pixel 
  }  
  return matched;
}

bool TrackedShot::Match(const Shot& shot, const int& latenz){
  if(Track::Match(ix, iy, shot.ix,shot.iy,latenz)) set(shot,latenz);
  return matched;
}
void TrackedAsteroid::init(const Asteroid& asteroid,const GameStatus& state,const int& _id){
  age=0;
  dsigma_init=16*16;
  dsigma=4;
  id=_id;
  xp0=0;
  yp0=0;
  set(asteroid, state);
}

void TrackedAsteroid::AllowedShots(const GameStatus& state){
  if(state.nasteroids+state.nshots<19){
    switch (sf){  
      case AST_GROSS:  // gro
	requiredShots = 4;
	break;
      case AST_MITTEL:// mittel 
	requiredShots = 3;
	break;
      case AST_KLEIN: // klein
	requiredShots = 1;
	break;
    }
  } else if(state.nObj+state.nshots<21){
    switch (sf){  
      case AST_GROSS:  // gro
	requiredShots = 3;
	break;
      case AST_MITTEL:// mittel 
	requiredShots = 2;
	break;
      case AST_KLEIN: // klein
	requiredShots = 1;
	break;
    }

  } else if(state.nObj+state.nshots<23){
    switch (sf){  
      case AST_GROSS:  // gro
	requiredShots = 2;
	break;
      case AST_MITTEL:// mittel 
	requiredShots = 2;
	break;
      case AST_KLEIN: // klein
	requiredShots = 1;
	break;
    }

  } else {
    switch (sf){  
      case AST_GROSS:  // gro
	requiredShots = 1;
	break;
      case AST_MITTEL:// mittel 
	requiredShots = 1;
	break;
      case AST_KLEIN: // klein
	requiredShots = 1;
	break;
    }
  }    
} 

void TrackedAsteroid::clear(){
  type=sf=0;
  Track::clear(ix,iy);
}

void Track::clear(int &x, int &y){
  age=0;
  matched=false;
  x=y=lx=ly=0;
  xp=yp=0;
  //  xperiod=yperiod=0;
  //ixakt=iyakt=0;
}   

void Track::set(const int& ix, const int& iy, const int& latenz, double &x, double &y){
  //void Track::set(int ix, int iy){
  int ixpsum, iypsum;
  if(age==0) {
    lx=ix;
    ly=iy;
    for(int i=0;i<8;i++) ixp[i]=iyp[0]=0;
    if(xp0!=0 || yp0!=0){
      xp=xp0;
      yp=yp0;
    }else xp=yp=0;
    x = ix;
    y = iy;
    deltaX=deltaY=8;
  }else if(age<=8){
    ixp[age-1]=(ix-lx)/(1+latenz);
    iyp[age-1]=(iy-ly)/(1+latenz);
    normWrap(ixp[age-1],iyp[age-1]);
    lx=ix;
    ly=iy;
    if(xp0!=0 || yp0!=0){
      xp=xp0;
      yp=yp0;
    }else{
      xp=yp=0;
      for(int i=0;i<age;i++){
        xp+=ixp[i];
        yp+=iyp[i];
      }
      xp/=age;
      yp/=age;
    }
    x = ix;
    y = iy;
    deltaX=deltaY=2;
  }else{
    for(int i=0;i<7;i++){
      ixp[i]=ixp[i+1];
      iyp[i]=iyp[i+1];
    }
    ixp[7]=(ix-lx)/(1+latenz);
    iyp[7]=(iy-ly)/(1+latenz);
    normWrap(ixp[7],iyp[7]);
    ixpsum = iypsum = 0;
    for(int i=0;i<8;i++){
      ixpsum+=ixp[i];
      iypsum+=iyp[i];
    }
    
    xp=ixpsum/8.; // Geschwindigkeitsauflsung 1/8 Pixel/Frame
    yp=iypsum/8.;
    normWrap(xp,yp);
    fraction(ix, ixp, ixpsum, xp, x);
    fraction(iy, iyp, iypsum, yp, y);
    deltaX = 2;
    deltaY = 2;
    normxy(x,y);
  }

  v2  = xp*xp+yp*yp;
  lx = ix;
  ly = iy;
  age++;
  //  if(t>MAX_PERIOD)t=MAX_PERIOD;
}
void fraction(const int& ixy, const int ip[], int ipsum, const double& p, double &xy){
  double frac=1;
  if(round(xy+p)!=ixy){
    frac = precision(ipsum);
    while(round(xy+p) < ixy) xy+=frac;  // Latenz fehlt noch
    while(round(xy+p) > ixy) xy-=frac; // Latenz fehlt noch
  }
  xy += p;
}
double precision(int ipsum){
  double prec=1;
  if (ipsum<0) ipsum = -ipsum;
  switch(ipsum%8){
    case 0:
    default:
      prec=1.0;
      break;
    case 1:  // 1/8
    case 3:  // 3/8
    case 5:  // 5/8
    case 7:  // 7/8
      prec = 1./8.;
      break;
    case 2:
    case 6:
      prec = 2./8.;
      break;
    case 4:
      prec = 4./8.;
      break;
  }
  return prec;
}


TrackedShot& TrackedShot::operator=(const TrackedShot& p){
  if (this != &p){
    hit     = p.hit;
    id      = p.id;
    own_shot= p.own_shot;
    sd      = p.sd;     // Absoluter Abstand^2
    sdx     = p.sdx;
    sdy     = p.sdy; // x,y-Abstand zum Schiff
    shipind = p.shipind;
    sls     = p.sls;
    taggedId= p.taggedId;
    taggedIdAimed= p.taggedIdAimed;
    tta     = p.tta;  
    age     = p.age;
    x       = p.x;;
    y       = p.y;;      // aktuelle Koordinaten
    lx      = p.lx;
    ly      = p.ly;
    xp      = p.xp;
    yp      = p.yp;
    v2      = p.v2;
    xp0     = p.xp0;
    yp0     = p.yp0;
    ttc     = p.ttc;  
    dtc_x   = p.dtc_x;
    dtc_y   = p.dtc_y;
    dc      = p.dc;
    dtc     = p.dtc;   // distance^2 to collision
    matched = p.matched; // Asteroid konnte zugeordnet werden
    dsigma_init=p.dsigma_init;
    dsigma  = p.dsigma;
    dx      = p.dx;
    dy      = p.dy; // x,y-Abstand zum Schiff
    d       = p.d;     // Absoluter Abstand^2
    ix      = p.ix;;
    iy      = p.iy;;      // aktuelle Koordinaten
    for(int i=0;i<8;i++){
      ixp[i]=p.ixp[i];
      iyp[i]=p.iyp[i];
    }
#ifdef OUTPUT
    strcpy(name,p.name);
#endif
  }
  return *this;
}

TrackedAsteroid& TrackedAsteroid::operator=(const TrackedAsteroid &p){
  if (this != &p){
    id      = p.id;
    exploded= p.exploded;
    requiredShots = p.requiredShots;
    nTags   = p.nTags;
    age     = p.age;
    lx      = p.lx;
    ly      = p.ly;
    x       = p.x;;
    y       = p.y;;      // aktuelle Koordinaten
    xp      = p.xp;
    yp      = p.yp;
    xp0     = p.xp0;
    yp0     = p.yp0;
    v2      = p.v2;
    ttc     = p.ttc;  
    dtc_x   = p.dtc_x;
    dtc_y   = p.dtc_y;
    dc      = p.dc;
    dtc     = p.dtc;   // distance^2 to collision
    matched = p.matched; // Asteroid konnte zugeordnet werden
    dsigma_init=p.dsigma_init;
    dsigma  = p.dsigma;
    radius  = p.radius;
    type    = p.type; // 1 ... 4, uere Form
    sf      = p.sf;   // scale factor: 0 = gro, 15 = mittel, 14 = klein
    points  = p.points;
    dx      = p.dx;
    dy      = p.dy; // x,y-Abstand zum Schiff
    d       = p.d;     // Absoluter Abstand^2
    ix      = p.ix;;
    iy      = p.iy;;      // aktuelle Koordinaten
    for(int i=0;i<8;i++){
      ixp[i]=p.ixp[i];
      iyp[i]=p.iyp[i];
    }
#ifdef OUTPUT
    strcpy(name,p.name);
#endif

  }

  return *this;
}

void TrackedAsteroid::set(const Asteroid& asteroid, const GameStatus& state){
  Asteroid::set(asteroid.ix,asteroid.iy,asteroid.type,asteroid.sf);
  Track::set(asteroid.ix,asteroid.iy,state.latenz,x,y);
  AllowedShots(state);
  nTags = 0;
}


bool TrackedAsteroid::Match(const Asteroid& asteroid, const GameStatus& state){
  if (type == asteroid.type &&
      sf   == asteroid.sf){ // Mutmalicher match
    if(Track::Match(ix, iy, asteroid.ix,asteroid.iy,state.latenz)) set(asteroid,state);
  }
  return matched;
}

int TrackedSaucer::set(const GameStatus& state, unsigned int& nBigSaucers, unsigned int& nSmallSaucers){
  int iSaucerExplosion=-1;
  nTags = 0;
  if(state.saucer.IsPresent()){
    Saucer::set(state.saucer.ix, state.saucer.iy, state.saucer.size);
    Speed();
    if(state.ship.present){
      Dist(state.ship);
      Ttc();
    }
    if(!lpresent){
      id=iNextSaucerID--; // Negativ zur Unterscheidung von Asteroiden
      switch (size){  
	case UFO_GROSS: // groes UFO
	  nBigSaucers++;
	  break;
	case UFO_KLEIN: // kleines UFO
	  nSmallSaucers++;
	  break;
	default:
	  break;
      }
    }
  } else  {
    size=0;
    if(lpresent){
      for(int iex=0; iex<state.nexplosions; iex++)
	if(ix==state.explosion[iex].ix &&
	   iy==state.explosion[iex].iy){
	  iSaucerExplosion = iex;
	  break;
	}
    }
  }
  lpresent=state.saucer.IsPresent();

  return iSaucerExplosion;
}
double TrackedSaucer::Ttc(void){
  ttc = calcTtc(dx,dy,xp,yp,radius+RADIUS_SCHIFF);
  return ttc;
}

void TrackedSaucer::Speed(){
  if(!lpresent){
    lx=ix;
    ly=iy;
    if(ix>512)xp=-2;
    else      xp= 2;
    yp=0;
  }else{
    xp=ix-lx;
    yp=iy-ly;
    lx=ix;
    ly=iy;
  }
  normWrap(xp,yp);
  v2=xp*xp+yp*yp;
}

TrackedSaucer::TrackedSaucer(void){
  lpresent=false;
  iNextYP=0;
  iNextSaucerID=0;
}
void swap(double& x,double& y){
  double _t = (x); 
  (x) = (y); 
  (y) = _t; 
}

void swap(TtcC& x,TtcC& y){
  TtcC _t = (x); 
  (x) = (y); 
  (y) = _t; 
}


/* Simple bubble sort */
void
bubble_sort(double a[], const int& size)
{
  int nswaps,i;

  do {
    for (nswaps = i = 0 ; i < size - 1 ; i++)
      if (a[i] > a[i+1]) {
	swap(a[i],a[i+1]);
	++nswaps;
      }
  } while (nswaps > 0);
}

void
bubble_sort(TtcC a[], const int& size)
{
  int nswaps,i;

  do {
    for (nswaps = i = 0 ; i < size - 1 ; i++)
      if (a[i].t > a[i+1].t) {
	swap(a[i],a[i+1]);
	++nswaps;
      }
  } while (nswaps > 0);
}


