import std.stdio;
import asteroids;

void main()
{
	Game game;
	game.ClearVars();
	bool[256][256] been;
	int[ubyte[]] placements;
	int max;
	while (!been[game.RandomSeed1][game.RandomSeed2])
	{
		been[game.RandomSeed1][game.RandomSeed2] = true;
		Game clone = game;
		clone.PlaceAsteroids();
		ubyte[] placement;
		foreach (t;clone.ObjType[MAX_ASTEROIDS-4..MAX_ASTEROIDS])
			assert((t&0b100) == 0b100 && (t&0b11100011) == 0);
		foreach (t;clone.ObjType[MAX_ASTEROIDS-4..MAX_ASTEROIDS])
			placement ~= t;
		foreach (x;clone.ObjX[MAX_ASTEROIDS-4..MAX_ASTEROIDS])
			placement ~= x >> 8;
		foreach (y;clone.ObjY[MAX_ASTEROIDS-4..MAX_ASTEROIDS])
			placement ~= y >> 8;
		foreach (x;clone.ObjSpeedX[MAX_ASTEROIDS-4..MAX_ASTEROIDS])
			placement ~= x;
		foreach (y;clone.ObjSpeedY[MAX_ASTEROIDS-4..MAX_ASTEROIDS])
			placement ~= y;
		if (placement in placements)
		{
			placements[placement]++;
			if (placements[placement] > max)
				max = placements[placement];
		}
		else
			placements[placement] = 1;

		game.Random();
	}

	int[100] distribution;
	foreach (placementCount; placements)
		distribution[placementCount]++;
	for (int d=0; d<100; d++)
		if (distribution[d])
			writefln("%2d ... %5d", d, distribution[d]);
}
