// This file is part of "Omniroid", an Asteroids bot written for the 2008 c't anniversary contest
// Omniroid was written by Vladimir "CyberShadow" Panteleev <thecybershadow@gmail.com>
// This file is written in the D Programming Language ( http://digitalmars.com/d/ )

/// A sample that allows you to play Asteroids in a console window.
module runconsole;

import std.stdio;
import std.c.time;
import asteroids;
import textoutput;
import std.c.windows.windows;
import display, vgadebug;

void main()
{
	Game game;
	DisplayParser parser = new DisplayParser();
	game.Initialize();
	//game.MakeNewGame();
	while(true)
	{
		printGame(game);
		parser.interpret(game.VectorRAM);
		writef("Frame = %04X   Random seed = %02X%02X   Score = %5d   ship_thrust=%d", game.FrameCount, game.RandomSeed1, game.RandomSeed2, game.Score, parser.ship_thrust);
		fflush(stdout);
		msleep(1000/60);
		game.Input_Start = GetKeyState('1')<0;
		// I use the Dvorak keyboard layout.
		game.Input_Clockwise = GetKeyState(0xBC)<0;        // '
		game.Input_CounterClockwise = GetKeyState(0xDE)<0; // .
		game.Input_Fire = GetKeyState('R')<0;
		game.Input_Thrust = GetKeyState('C')<0;
		game.Input_HyperSpace = GetKeyState(VK_SPACE)<0;
		if (GetKeyState('X')<0)
			game.ClearObstacles();
		if (GetKeyState(VK_SNAPSHOT)<0)
			dumpScreen("screen.txt", game.VectorRAM);
		game.Step();
	}
}
