import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.StringTokenizer;

public class AsteroidsTester 
{
	static class StderrThread
	{
		BufferedReader br;
		public StderrThread(Process proc)
		{
			br = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
		}
		
		public void run()
		{
			try
			{
				String line;
				while(br != null && (line = br.readLine()) != null)
				{
					System.err.println(line);
				}
			}
			catch(Exception exc)
			{
			}
		}
	}
	
	public static void main(String[] args) throws Exception
	{
		System.out.println("Run\tScore\tShipsLost\tJumps\tShotsFired\tShotsHit\tShotsMissed"
				+ "\tALarge\tAMedium\tASmall\tULarge\tUSmall\tFToHit\tShAct\tTime");
		int runs = 100;
		for(int i = 1; i <= runs; i++)
		{
			Process proc = Runtime.getRuntime().exec("java -ea -Xmx256M -classpath bin Asteroids 127.0.0.1 -visu");
			BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
			StderrThread t = new StderrThread(proc);
			t.run();
			
			proc.waitFor();
			
			t.br.close();
			t.br = null;
			
			String line = br.readLine();
			StringTokenizer st = new StringTokenizer(line);
			st.nextToken();

			System.out.print(i);
			
			while(st.hasMoreTokens())
			{
				System.out.print("\t" + st.nextToken());
			}
			System.out.print("\t" + new Date());
			System.out.println();
		}
	}
}
