import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.PriorityQueue;
import java.util.StringTokenizer;
import java.util.Vector;

public class Player
{
	DatagramSocket socket = new DatagramSocket();
	
	byte[] bufIn = new byte[1026];
	DatagramPacket packetIn = new DatagramPacket(bufIn, bufIn.length);

	byte[] bufOut = new byte[8];
	DatagramPacket packetOut = new DatagramPacket(bufOut, bufOut.length);
	
	byte[] bufOutName = new byte[38];
	DatagramPacket packetOutName = new DatagramPacket(bufOutName, bufOutName.length);
	
	VisuFrame visu = null;
	
	static long nanoTimeStart = System.nanoTime();
	
	class V2d
	{
		int x;
		int y;
		
		
		public V2d(int x, int y) 
		{
			this.x = x;
			this.y = y;
		}

		@Override
		public boolean equals(Object obj) 
		{
			V2d v = (V2d) obj;
			
			return v.x == x && v.y == y;
		}

		@Override
		public int hashCode() 
		{
			return new Integer(y * 100000 + x).hashCode();
		}
	}
	
	public static Point[] shipAngles = new Point[]
        {
			new Point(0, 1536),
			new Point(152, 1528),
			new Point(296, 1504),
			new Point(440, 1472),
			new Point(440, 1472),
			new Point(584, 1416),
			new Point(720, 1360),
			new Point(856, 1280),
			new Point(856, 1280),
			new Point(976, 1192),
			new Point(1088, 1088),
			new Point(1192, 976),
			new Point(1192, 976),
			new Point(1280, 856),
			new Point(1360, 720),
			new Point(1416, 584),
			new Point(1416, 584),
			new Point(1472, 440),
			new Point(1504, 296),
			new Point(1528, 152),
			new Point(1528, 152),
			new Point(1536, 0),
			new Point(1536, 0),
			new Point(1528, -152),
			new Point(1504, -296),
			new Point(1504, -296),
			new Point(1472, -440),
			new Point(1416, -584),
			new Point(1360, -720),
			new Point(1360, -720),
			new Point(1280, -856),
			new Point(1192, -976),
			new Point(1088, -1088),
			new Point(1088, -1088),
			new Point(976, -1192),
			new Point(856, -1280),
			new Point(720, -1360),
			new Point(720, -1360),
			new Point(584, -1416),
			new Point(440, -1472),
			new Point(296, -1504),
			new Point(296, -1504),
			new Point(152, -1528),
			new Point(-152, -1528),
			new Point(-152, -1528),
			new Point(-296, -1504),
			new Point(-440, -1472),
			new Point(-584, -1416),
			new Point(-584, -1416),
			new Point(-720, -1360),
			new Point(-856, -1280),
			new Point(-976, -1192),
			new Point(-976, -1192),
			new Point(-1088, -1088),
			new Point(-1192, -976),
			new Point(-1280, -856),
			new Point(-1280, -856),
			new Point(-1360, -720),
			new Point(-1416, -584),
			new Point(-1472, -440),
			new Point(-1472, -440),
			new Point(-1504, -296),
			new Point(-1528, -152),
			new Point(-1536, 0),
			new Point(-1536, 0),
			new Point(-1536, 0),
			new Point(-1528, 152),
			new Point(-1504, 296),
			new Point(-1472, 440),
			new Point(-1472, 440),
			new Point(-1416, 584),
			new Point(-1360, 720),
			new Point(-1280, 856),
			new Point(-1280, 856),
			new Point(-1192, 976),
			new Point(-1088, 1088),
			new Point(-976, 1192),
			new Point(-976, 1192),
			new Point(-856, 1280),
			new Point(-720, 1360),
			new Point(-584, 1416),
			new Point(-584, 1416),
			new Point(-440, 1472),
			new Point(-296, 1504),
			new Point(-152, 1528),
			new Point(-152, 1528),
			new Point(152, 1528),
			new Point(296, 1504),
			new Point(296, 1504),
			new Point(440, 1472),
			new Point(584, 1416),
			new Point(720, 1360),
			new Point(720, 1360),
			new Point(856, 1280),
			new Point(976, 1192),
			new Point(1088, 1088),
			new Point(1088, 1088),
			new Point(1192, 976),
			new Point(1280, 856),
			new Point(1360, 720),
			new Point(1360, 720),
			new Point(1416, 584),
			new Point(1472, 440),
			new Point(1504, 296),
			new Point(1504, 296),
			new Point(1528, 152),
			new Point(1536, 0),
			new Point(1536, 0),
			new Point(1528, -152),
			new Point(1528, -152),
			new Point(1504, -296),
			new Point(1472, -440),
			new Point(1416, -584),
			new Point(1416, -584),
			new Point(1360, -720),
			new Point(1280, -856),
			new Point(1192, -976),
			new Point(1192, -976),
			new Point(1088, -1088),
			new Point(976, -1192),
			new Point(856, -1280),
			new Point(856, -1280),
			new Point(720, -1360),
			new Point(584, -1416),
			new Point(440, -1472),
			new Point(440, -1472),
			new Point(296, -1504),
			new Point(152, -1528),
			new Point(0, -1536),
			new Point(-152, -1528),
			new Point(-296, -1504),
			new Point(-440, -1472),
			new Point(-440, -1472),
			new Point(-584, -1416),
			new Point(-720, -1360),
			new Point(-856, -1280),
			new Point(-856, -1280),
			new Point(-976, -1192),
			new Point(-1088, -1088),
			new Point(-1192, -976),
			new Point(-1192, -976),
			new Point(-1280, -856),
			new Point(-1360, -720),
			new Point(-1416, -584),
			new Point(-1416, -584),
			new Point(-1472, -440),
			new Point(-1504, -296),
			new Point(-1528, -152),
			new Point(-1528, -152),
			new Point(-1536, 0),
			new Point(-1536, 0),
			new Point(-1528, 152),
			new Point(-1504, 296),
			new Point(-1504, 296),
			new Point(-1472, 440),
			new Point(-1416, 584),
			new Point(-1360, 720),
			new Point(-1360, 720),
			new Point(-1280, 856),
			new Point(-1192, 976),
			new Point(-1088, 1088),
			new Point(-1088, 1088),
			new Point(-976, 1192),
			new Point(-856, 1280),
			new Point(-720, 1360),
			new Point(-720, 1360),
			new Point(-584, 1416),
			new Point(-440, 1472),
			new Point(-296, 1504),
			new Point(-296, 1504),
			new Point(-152, 1528),
			new Point(152, 1528),
			new Point(152, 1528),
			new Point(296, 1504),
			new Point(440, 1472),
			new Point(584, 1416),
			new Point(584, 1416),
			new Point(720, 1360),
			new Point(856, 1280),
			new Point(976, 1192),
			new Point(976, 1192),
			new Point(1088, 1088),
			new Point(1192, 976),
			new Point(1280, 856),
			new Point(1280, 856),
			new Point(1360, 720),
			new Point(1416, 584),
			new Point(1472, 440),
			new Point(1472, 440),
			new Point(1504, 296),
			new Point(1528, 152),
			new Point(1536, 0),
			new Point(1536, 0),
			new Point(1536, 0),
			new Point(1528, -152),
			new Point(1504, -296),
			new Point(1472, -440),
			new Point(1472, -440),
			new Point(1416, -584),
			new Point(1360, -720),
			new Point(1280, -856),
			new Point(1280, -856),
			new Point(1192, -976),
			new Point(1088, -1088),
			new Point(976, -1192),
			new Point(976, -1192),
			new Point(856, -1280),
			new Point(720, -1360),
			new Point(584, -1416),
			new Point(584, -1416),
			new Point(440, -1472),
			new Point(296, -1504),
			new Point(152, -1528),
			new Point(152, -1528),
			new Point(-152, -1528),
			new Point(-296, -1504),
			new Point(-296, -1504),
			new Point(-440, -1472),
			new Point(-584, -1416),
			new Point(-720, -1360),
			new Point(-720, -1360),
			new Point(-856, -1280),
			new Point(-976, -1192),
			new Point(-1088, -1088),
			new Point(-1088, -1088),
			new Point(-1192, -976),
			new Point(-1280, -856),
			new Point(-1360, -720),
			new Point(-1360, -720),
			new Point(-1416, -584),
			new Point(-1472, -440),
			new Point(-1504, -296),
			new Point(-1504, -296),
			new Point(-1528, -152),
			new Point(-1536, 0),
			new Point(-1536, 0),
			new Point(-1528, 152),
			new Point(-1528, 152),
			new Point(-1504, 296),
			new Point(-1472, 440),
			new Point(-1416, 584),
			new Point(-1416, 584),
			new Point(-1360, 720),
			new Point(-1280, 856),
			new Point(-1192, 976),
			new Point(-1192, 976),
			new Point(-1088, 1088),
			new Point(-976, 1192),
			new Point(-856, 1280),
			new Point(-856, 1280),
			new Point(-720, 1360),
			new Point(-584, 1416),
			new Point(-440, 1472),
			new Point(-440, 1472),
			new Point(-296, 1504),
			new Point(-152, 1528),
        };
	
	public static Point[] shotAngles = new Point[256];
	public static int[] shotAngleCnt = new int[256];
	
	static
	{
		for(int i = 0; i < 256; i++)
		{
			double angle = i / 256.0 * Math.PI * 6.0;
			shotAngles[i] = new Point((int) (Math.sin(angle) * 64 + 0.5),
									(int) (Math.cos(angle) * 64 + 0.5));
		}
	}
	
	static class HitInfo implements Comparable<HitInfo>
	{
		State.GameObject obj1;
		State.GameObject obj2;
		double framesUntilHit;
		
		public HitInfo(State.GameObject obj1, State.GameObject obj2, 
					double framesUntilHit) 
		{
			super();
			this.obj1 = obj1;
			this.obj2 = obj2;
			this.framesUntilHit = framesUntilHit;
		}

		public int compareTo(HitInfo hi) 
		{
			return (int) (framesUntilHit - hi.framesUntilHit);
		}
	}
	
	static class CommData
	{
		long nanoTime = System.nanoTime();
		boolean send;
		int ping;
		int frameByte;
		int frame;
		
		public CommData(boolean send, int ping, int frameByte, int frame) 
		{
			this.send = send;
			this.ping = (ping + 256) % 256;
			this.frameByte = (frameByte + 256) % 256;
			this.frame = frame;
		}

		@Override
		public String toString() 
		{
			StringBuilder sb = new StringBuilder();
			
			long nanosSinceStart = nanoTime - nanoTimeStart;
			String nanosRest = "" + nanosSinceStart / 1000000 % 1000;
			sb.append(nanosSinceStart / 1000000000 + "." 
					+ "000".substring(nanosRest.length()) + nanosRest);
			
			if(send)
			{
				sb.append(" OUT: " + ping);
			}
			else
			{
				sb.append(" IN:  " + ping + " " + frameByte + " " + frame);
			}
			
			return sb.toString();
		}
	}
	
	static class FutureGameObject implements Cloneable
	{
		// type constants
		final static int ASTEROID = 1;
		final static int UFO = 2;
		
		double x;
		double y;
		double vx;
		double vy;
		int sinceFrame;
		int type;
		int size;
		
		/**
		 * id of the object or id of the parent, if it was hit
		 */
		int id;
		
		static FutureGameObject cre()
		{
			if(futureGameObjectCache.size() > 0)
			{
				return futureGameObjectCache.remove(futureGameObjectCache.size() - 1);
			}
			return new FutureGameObject();
		}
		
		void free()
		{
			futureGameObjectCache.add(this);
		}
		
		static FutureGameObject newUfo(State.Ufo u)
		{
			FutureGameObject fgo = cre();
			fgo.id = u.id;
			fgo.x = u.x;
			fgo.y = u.y;
			fgo.vx = u.vx;
			fgo.vy = u.vy;
			fgo.type = UFO;
			fgo.size = u.size;
			fgo.sinceFrame = u.sinceFrame;
			
			return fgo;
		}
		
		static FutureGameObject newAsteroid(State.Asteroid a)
		{
			FutureGameObject fgo = cre();
			fgo.id = a.id;
			fgo.x = a.x;
			fgo.y = a.y;
			fgo.vx = a.vx;
			fgo.vy = a.vy;
			fgo.type = ASTEROID;
			fgo.size = a.size;
			fgo.sinceFrame = a.sinceFrame;
			
			return fgo;
		}
		
		static FutureGameObject newAsteroidSmaller(FutureGameObject a, int frame)
		{
			FutureGameObject fgo = cre();
			fgo.id = a.id;
			fgo.x = a.x;
			fgo.y = a.y;
			fgo.vx = a.vx;
			fgo.vy = a.vy;
			fgo.type = ASTEROID;

			fgo.size = a.size - 1;
			fgo.sinceFrame = frame;
			
			return fgo;
		}
		
		int getRadius()
		{
			return 32 >> -size;
		}
		
		public FutureGameObject copy()
		{
			FutureGameObject fgo = cre();
			fgo.id = id;
			fgo.x = x;
			fgo.y = y;
			fgo.vx = vx;
			fgo.vy = vy;
			fgo.type = type;
			fgo.size = size;
			fgo.sinceFrame = sinceFrame;

			return fgo;
		}
		
		@Override
		public String toString() 
		{
			return "FGO[ id=" + (type == ASTEROID ? "A" : "U") + id + ", x/y=" + x + "/" + y + ", vx/vy=" + vx + "/" + vy
					+ ", sz=" + size + ", since=" + sinceFrame+ " ]";
		}
	}
	
	static Vector<FutureGameObject> futureGameObjectCache = new Vector<FutureGameObject>();
	
	static Vector<FutureState> futureStateCache = new Vector<FutureState>();
	
	static class FutureState implements Comparable<FutureState>
	{
		Vector<FutureGameObject> gameObjects = new Vector<FutureGameObject>();
		int[] shotEndTimes = new int[10];
		int shotEndTimesCnt = 0;
		int frame;
		int frameFirst;
		double eval;
		double evalAdd = 0;
		double shipAngle;
		double shipPosX;
		double shipPosY;
		HashMap<Integer, Integer> collisionMap = null;
		FutureGameObject fgoToAttack = null;
		
		static FutureState cre()
		{
			if(futureStateCache.size() > 0)
			{
				return futureStateCache.remove(futureStateCache.size() - 1);
			}
			return new FutureState();
		}
		
		void free()
		{
			for(FutureGameObject fgo : gameObjects)
			{
				fgo.free();
			}
			gameObjects.clear();
			futureStateCache.add(this);
			shotEndTimesCnt = 0;
		}
		
		FutureState init(State state)
		{
			frame = frameFirst = state.frame;
			shipPosX = state.ship.x;
			shipPosY = state.ship.y;
			return this;
		}
		
		FutureState init(FutureState fs, FutureGameObject fgoRemove, int deltaFrames)
		{
			frame = fs.frame + deltaFrames;
			frameFirst = fs.frameFirst;
			for(FutureGameObject fgo : fs.gameObjects)
			{
				if(fgo != fgoRemove)
				{
					addGo(fgo.copy());
				}
			}

			shotEndTimesCnt = 0;
			for(int i = 0; i < fs.shotEndTimesCnt; i++)
			{
				if(fs.shotEndTimes[i] > frame)
				{
					shotEndTimes[shotEndTimesCnt++] = fs.shotEndTimes[i];
				}
			}
			eval = fs.eval;
			evalAdd = fs.evalAdd;
			shipAngle = fs.shipAngle;
			shipPosX = fs.shipPosX;
			shipPosY = fs.shipPosY;
			collisionMap = fs.collisionMap;
			fgoToAttack = fs.fgoToAttack;
			return this;
		}
		
		public void addCollision(int frame, int id)
		{
			collisionMap.put(id, frame);
		}
		
		public int compareTo(FutureState fs)
		{
			return (int) Math.signum(eval - fs.eval);
		}
		
		public void addGo(FutureGameObject fgo)
		{
			gameObjects.add(fgo);
		}
		
		public void removeGo(FutureGameObject fgo)
		{
			fgo.free();
			if(!gameObjects.remove(fgo))
			{
				System.out.println("object not removed!");
			}
		}
		
		public void addShot(int frameHit)
		{
			shotEndTimesCnt++;
			int i = shotEndTimesCnt - 1;
			while(i > 0 && shotEndTimes[i - 1] > frameHit)
			{
				shotEndTimes[i] = shotEndTimes[i - 1];
				i--;
			}
			shotEndTimes[i] = frameHit;
		}
		
		@Override
		public String toString()
		{
			StringBuilder sb = new StringBuilder();
			for(int i = 0; i < shotEndTimesCnt; i++)
			{
				if(sb.length() > 0)
				{
					sb.append(", ");
				}
				sb.append(shotEndTimes[i]);
			}
			
			StringBuilder fgoList = new StringBuilder();
			for(FutureGameObject fgo : gameObjects)
			{
				if(fgoList.length() > 0)
				{
					fgoList.append(", ");
				}
				fgoList.append(fgo);
			}
			
			return "FS[ frame=" + frame + "; shots " + sb + "; attacked=" + fgoToAttack.id
					+ ", shipAngle=" + shipAngle + ", eval=" + eval + ", FGOs: " + fgoList + " ]";
		}
	}

	static class CollisionInfo implements Comparable<CollisionInfo>
	{
		FutureGameObject fgo;
		int collisionFrame;
		
		public CollisionInfo(FutureGameObject fgo, int collisionFrame) 
		{
			this.fgo = fgo;
			this.collisionFrame = collisionFrame;
		}

		public int compareTo(CollisionInfo ci) 
		{
			return collisionFrame - ci.collisionFrame;
		}
	}
	
	static Vector<State> states = new Vector<State>();
	static Vector<CommData> log = new Vector<CommData>();
	
	boolean doLog = true;
	boolean sendName = false;
	
	Player(String[] args) throws Exception
	{
		byte[] bufInSaved = null;
		
		String host = args[0];
		packetOut.setAddress(InetAddress.getByName(host));
		packetOut.setPort(1979);
		packetOutName.setAddress(InetAddress.getByName(host));
		packetOutName.setPort(1979);
		
		socket.setSoTimeout(1000);
		
		int a = 1;
		while(args.length > a)
		{
			if(args[a].equalsIgnoreCase("-visu"))
			{
				visu = new VisuFrame();
			}
			if(args[a].equalsIgnoreCase("-log"))
			{
				doLog = true;
			}
			if(args[a].equalsIgnoreCase("-name"))
			{
				sendName = true;
			}
			a++;
		}

		File fileShotAngles = new File("ShotAngles.txt");
		if(fileShotAngles.exists())
		{
			BufferedReader br = new BufferedReader(new FileReader(fileShotAngles));
			for(int i = 0; i < 256; i++)
			{
				String line = br.readLine();
				StringTokenizer st = new StringTokenizer(line, "\t");
				st.nextToken();
				int x = Integer.parseInt(st.nextToken());
				int y = Integer.parseInt(st.nextToken());
				int cnt = Integer.parseInt(st.nextToken());
				
				shotAngles[i] = new Point(x, y);
				shotAngleCnt[i] = cnt;
			}
		}
		
		byte[] str = "ctmame".getBytes();
		System.arraycopy(str, 0, bufOut, 0, str.length);
		
		str = "ctnameStefan Blauel".getBytes();
		System.arraycopy(str, 0, bufOutName, 0, str.length);
		
		Keys keys = new Keys();
		State stateLast = null;
		byte ping = 0;

		int packetCnt = 0;
		while(true)
		{
			bufOut[6] = keys.getVal();
			bufOut[7] = ping++;

			if(doLog)
			{
				log.add(new CommData(true, bufOut[7], 0, 0));
			}

			if(packetCnt++ == 1 && sendName)
			{
				socket.send(packetOutName);
			}
			else
			{
				socket.send(packetOut);
			}
			
			while(true)
			{
				try
				{
					socket.receive(packetIn);
					break;
				}
				catch(Exception exc)
				{
					socket.send(packetOut);
				}
			}
			
			if(packetIn.getLength() < 1024)
			{
				if(doLog)
				{
					log.add(new CommData(false, 0, 0, 0));
				}

				String text = new String(packetIn.getData(), 0, packetIn.getLength() - 1);
				if(text.contains("game over"))
				{
					break;
				}

				if(!text.startsWith("busy"))
				{
					System.out.println("ERROR MAME SERVER: " + text + " - " + new Date());
					break;
				}
				
				try
				{
					Thread.sleep(1000);
				}
				catch(Exception exc)
				{
				}
				continue;
			}
			else
			{
				if(doLog)
				{
					log.add(new CommData(false, bufIn[1025], bufIn[1024], 
									stateLast == null ? -1 : stateLast.frame));
				}
			}
			
			keys.reset();

			if(bufInSaved != null 
					&& ((bufIn[1024] - bufInSaved[1024] + 256) & 0xFF) > 192)
			{
				System.arraycopy(bufInSaved, 0, bufIn, 0, bufIn.length);
			}
			else
			{
				if(bufInSaved == null)
				{
					bufInSaved = new byte[bufIn.length];
				}
				System.arraycopy(bufIn, 0, bufInSaved, 0, bufIn.length);
			}
			
			State state = new State();
			state.fromBytes(bufIn, stateLast, ((int) bufOut[7] + 256) & 0xFF);

			states.add(state);
			if(!doLog && states.size() > 20)
			{
				states.remove(0);
			}
			
			state.match(stateLast);
			stateLast = state;
			
			if(state.timeGameStarted <= 0 && states.size() >= 2)
			{
				state.frame = 1;
				states.remove(0);
				if(visu != null)
				{
					visu.setState(state);
				}
				continue;
			}
			
			if(states.size() == 3)
			{
				state.frame = 1;
			}
			
			if(!determineAction(state, keys))
			{
				break;
			}

			state.keys = keys.getVal();
			if(keys.isJump())
			{
				state.jumps++;
			}
			
			if(visu != null)
			{
				visu.setState(state);
			}
			
			collectShotAngles(state);
		}

		State state = states.lastElement();
		System.out.println("Score: " + state.score + " " + state.shipsLost + " " + state.jumps
				+ " " + state.shotsFired + " " + state.shotsHit + " " + state.shotsMissed
				+ " " + state.asteroidsDestroyedLarge + " " + state.asteroidsDestroyedMedium
				+ " " + state.asteroidsDestroyedSmall
				+ " " + state.ufosDestroyedLarge + " " + state.ufosDestroyedSmall
				+ " " + state.sumFramesToHit * 100 / state.shotsHit / 100.0
				+ " " + state.sumShotsActive * 100 / state.framesActive / 100.0
				+ " " + state.sumShotsActive + " " + state.framesActive);

		ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream("game.log"));
		oos.writeObject(states);
		oos.close();
		
		PrintWriter pw = new PrintWriter(new FileWriter("comm.log"));
		for(CommData cd : log)
		{
			pw.println(cd.toString());
		}
		pw.close();
		
		pw = new PrintWriter(new FileWriter("ShotAngles.txt"));
		for(int i = 0; i < 256; i++)
		{
			Point v = shotAngles[i];
			pw.println(i + "\t" + v.x + "\t" + v.y + "\t" + shotAngleCnt[i]);
		}
		pw.close();
		
		System.exit(0);
	}
	
	private void collectShotAngles(State state)
	{
		for(State.Shot s : state.shots)
		{
			if(s.myShot && state.frame - s.sinceFrame == 16 && s.shipAngle >= 0)
			{
				Point v = new Point((int) Math.floor(s.vx * 8 + 0.5), (int) Math.floor(s.vy * 8 + 0.5));
				
				if(shotAngles[s.shipAngle].equals(v))
				{
					shotAngleCnt[s.shipAngle]++;
				}
				else if(shotAngleCnt[s.shipAngle] <= 5)
				{
					shotAngles[s.shipAngle] = v;
					shotAngleCnt[s.shipAngle] = 1;
				}
			}
		}
	}

	public static double calcHit(State.GameObject obj1, State.GameObject obj2, 
			double maxFrames, boolean small)
	{
		return calcHit(obj1, obj2, maxFrames,
						obj1.getRadius(small) + obj2.getRadius(small));
	}
	
	public static double calcHit(State.GameObject obj1, State.GameObject obj2, 
							double maxFrames, double size)
	{
		double minFramesUntilHit = maxFrames;
		for(int x = -1; x <= 1; x++)
		{
			for(int y = -1; y <= 1; y++)
			{
				double framesUntilHit = calcEarliestHit(obj1, obj2, 
												x * 1024, y * 768, size);
				
				if(framesUntilHit < minFramesUntilHit)
				{
					minFramesUntilHit = framesUntilHit;
				}
			}
		}
		
		return minFramesUntilHit >= maxFrames ? Double.MAX_VALUE : minFramesUntilHit;
	}

	public static double calcEarliestHit(State.GameObject obj1, State.GameObject obj2, 
									int offX, int offY, double size) 
	{
		double r = size;
		
		// solve t + at + b = 0 for t
		double px = obj1.x - obj2.x + offX;
		double py = obj1.y - obj2.y + offY;
		double vx = obj1.vx - obj2.vx;
		double vy = obj1.vy - obj2.vy;
		
		double pp = px * px + py * py;
		double pv = px * vx + py * vy;
		double vv = vx * vx + vy * vy;
		double rr = r * r;
		
		if(vv < 0.0001)
		{
			return Double.MAX_VALUE;
		}
		
		double a = 2 * pv / vv;
		double b = (pp - rr) / vv;
		
		double d = a * a / 4.0 - b;
		if(d < 0)
		{
			return Double.MAX_VALUE;
		}
		double s = Math.sqrt(d);
		
		double x1 = -a / 2.0 - s;
		double x2 = -a / 2.0 + s;
		
		if(x1 > 0)
		{
			return x1;
		}
		if(x2 > 0)
		{
			return x2;
		}
		return Double.MAX_VALUE;
	}

static long timeWorst = 0;
static long frameLastJump = 0;
	public static boolean determineAction(State state, Keys keys)
	{
		if(state.ship == null)
		{
			return true;
		}

		FutureState fs = FutureState.cre().init(state);

		// determine collisions of my ship
		HitInfo nextHitShip = null;
		
		for(State.Shot s : state.shots)
		{
			double framesUntilHit = calcHit(state.ship, s, s.sinceFrame + 73 - state.frame, false);
			if(framesUntilHit < 72 
					&& (nextHitShip == null 
							|| nextHitShip.framesUntilHit > framesUntilHit))
			{
				nextHitShip = new HitInfo(state.ship, s, framesUntilHit);
			}
		}
		fs.collisionMap = new HashMap<Integer, Integer>();
		for(State.Asteroid a : state.asteroids)
		{
			double framesUntilHit = calcHit(state.ship, a, 1000, false);
			if(framesUntilHit > 1000)
			{
				continue;
			}
			a.collides = true;
			if(nextHitShip == null 
					|| nextHitShip.framesUntilHit > framesUntilHit)
			{
				nextHitShip = new HitInfo(state.ship, a, framesUntilHit);
			}
			fs.addCollision((int) (state.frame + framesUntilHit), a.id);
		}
		if(state.ufo != null)
		{
			double framesUntilHit = calcHit(state.ship, state.ufo, 200, false);
			if(framesUntilHit < 100)
			{
				state.ufo.collides = true;
			}
			if(nextHitShip == null 
					|| nextHitShip.framesUntilHit > framesUntilHit)
			{
				nextHitShip = new HitInfo(state.ship, state.ufo, framesUntilHit);
			}
			fs.addCollision((int) (state.frame + framesUntilHit), state.ufo.id);
		}
		
		if(nextHitShip != null && nextHitShip.framesUntilHit < 4 + state.latency)
		{
			keys.jump();
			return true;
		}

		// if we are between two levels, then prepare ship position/rotation for
		// the next level
		if(state.asteroids.isEmpty() 
				&& state.ufo == null)
		{
			if(((state.ship.x > 192 && state.ship.x < 832)
					&& (state.ship.y > 320 && state.ship.y < 704))
				&& frameLastJump < state.frame - state.latency - 5
				&& state.score > 0
				&& state.ships > 2)
			{
				keys.jump();
				frameLastJump = state.frame;
				return true;
			}
			
			double dx = state.ship.x - 512;
			double dy = state.ship.y - 512;
			double l = Math.sqrt(dx * dx + dy * dy);
			dx /= l;
			dy /= l;
			
			if(state.ship.dx * dx + state.ship.dy * dy < 1400)
			{
				keys.right();
				return true;
			}
		}

		// Collect object list (asteroids, ufos) after all planned shots have
		// hit. For medium/large asteroids, create the next smaller object level
		addFutureObjects(state, fs);

		// determine the object to attack next
		determineShipAngle();
		int angleShot = determineShotAngle(state);
		fs.shipAngle = Math.atan2(shipAngles[angleShot].y, shipAngles[angleShot].x);

		long nanosStart = System.nanoTime();
		int[] asteroidSize = new int[1];
		State.GameObject go = determineObjectToAttack(state, fs, nanosStart + 5000000, asteroidSize);

		if(go != null)
		{
			int s = (asteroidSize[0] == -2 ? 3 : 1);
			attack(state, keys, go, 100, asteroidSize[0],
					fs.shotEndTimesCnt < s ? 2 :
						fs.shotEndTimes[fs.shotEndTimesCnt - s] - fs.frame + 2);
		}
		
		return true;
	}

	static int idToAttackLast = -1;
	static int idToAttackBeforeLast = -1;
	
	private static State.GameObject getGO(State state,
								FutureGameObject fgo, int[] asteroidSize) 
	{
		if(fgo == null)
		{
			return null;
		}
		
		if(state.ufo != null && state.ufo.id == fgo.id)
		{
			return state.ufo;
		}
		
		for(State.Asteroid a : state.asteroids)
		{
			if(a.id == fgo.id)
			{
				asteroidSize[0] = fgo.size;
				return a;
			}
		}
		
		return null;
	}

	private static State.GameObject determineObjectToAttack(State state, FutureState fsStart,
														long nanosEnd, int[] asteroidSize) 
	{
		Vector<Integer> collFrames = new Vector<Integer>();
		collFrames.addAll(fsStart.collisionMap.values());
		Collections.sort(collFrames);
		int maxFramesColl = 0;
		for(int i = collFrames.size() - 1; i >= 0; i--)
		{
			if(collFrames.get(i) < fsStart.frame + 40 * (i + 1) + 40)
			{
				maxFramesColl = 40 * (i + 1) + 40;
				break;
			}
		}

		FutureGameObject fgoColl = null;
		int nextCollisionFrame = Integer.MAX_VALUE;
		for(FutureGameObject fgo : fsStart.gameObjects)
		{
			Integer collisionFrame = fsStart.collisionMap.get(fgo.id);
			if(collisionFrame != null 
					&& collisionFrame - fsStart.frame < maxFramesColl
					&& collisionFrame < nextCollisionFrame)
			{
				nextCollisionFrame = collisionFrame;
				fgoColl = fgo;
			}
		}
		if(fgoColl != null)
		{
			return getGO(state, fgoColl, asteroidSize);
		}
		
		int cntAstOpen = 0;
		for(State.Asteroid a : state.asteroids)
		{
			if(!a.attacked && !a.willBeHit)
			{
				cntAstOpen++;
			}
		}
		
		if((cntAstOpen == 0 || cntAstOpen > 2) 
				&& state.ufo != null && !state.ufo.attacked && !state.ufo.willBeHit)
		{
			return state.ufo;
		}
		
		return getGO(state, determineObjectToAttackBg(state, fsStart, asteroidSize, nanosEnd), asteroidSize);
	}

	private static FutureGameObject determineObjectToAttackBg(State state,
										FutureState fsStart, int[] asteroidSize,
										long nanosEnd) 
	{
		PriorityQueue<FutureState> fsCurr = new PriorityQueue<FutureState>();
		PriorityQueue<FutureState> fsNext;
		fsCurr.offer(fsStart);

		int a = 10;
		int b = 2;
		
		if(fsStart.gameObjects.size() < 6)
		{
			a = 10;
			b = 4;
		}
		
		int maxFsPerStep = a;
		
		FutureGameObject fgoToAttack = null;
		double[] shipAngleNew = new double[1];
		int[] framesToShot = new int[1];
		for(int i = 0; fsCurr.size() > 0 && i < b; i++)
		{
			fsNext = new PriorityQueue<FutureState>();
			
			int n = maxFsPerStep;
			for(FutureState fs : fsCurr)
			{
				if(n-- == 0)
				{
					break;
				}

				for(FutureGameObject fgo : fs.gameObjects)
				{
					if(fgo.type == FutureGameObject.ASTEROID
							&& ((fs.gameObjects.size() >= 23 && fgo.size == -1)
								|| (fs.gameObjects.size() >= 20	&& fgo.size == 0)))
					{
						continue;
					}
					
					int minFramesToShot = fs.shotEndTimesCnt < 4 ? 2 :
									Math.max(2, fs.shotEndTimes[fs.shotEndTimesCnt - 4] - fs.frame + 2);
					int framesToHit = calcFramesToHit(fs.shipAngle,
											framesToShot,
											shipAngleNew,
											minFramesToShot,
											fgo.x - fs.shipPosX, fgo.y - fs.shipPosY,
											fgo.vx, fgo.vy,
											fgo.getRadius());
					
					if(fgo.sinceFrame > fs.frame
							&& framesToHit + fs.frame - fgo.sinceFrame > 5)
					{
						continue;
					}
					
					if(framesToHit > 200)
					{
						continue;
					}
					
					FutureState fsNew = nextFs(fs, fgo, framesToShot[0], shipAngleNew[0], framesToHit);
					
					assert fsNew.shotEndTimesCnt <= 4 : "too many shots: " + fsNew.shotEndTimesCnt;
					
					fsNext.offer(fsNew);
				}
			}
			fsCurr = fsNext;

			if(fsCurr.size() > 0)
			{
				fgoToAttack = fsCurr.peek().fgoToAttack;
			}
		}
		
		return fgoToAttack;
	}
	
	private static FutureState nextFs(FutureState fs, FutureGameObject fgo,
									int framesToShot, double shipAngleNew,
									int framesToHit) 
	{
		FutureState fsNew = FutureState.cre().init(fs, fgo, framesToShot);
		fsNew.shipAngle = shipAngleNew;
		if(fsNew.fgoToAttack == null)
		{
			fsNew.fgoToAttack = fgo;
		}
		
		if(fgo.type == FutureGameObject.ASTEROID && fgo.size > -2)
		{
			fsNew.addGo(FutureGameObject.newAsteroidSmaller(fgo, fs.frame + framesToHit));
			fsNew.addGo(FutureGameObject.newAsteroidSmaller(fgo, fs.frame + framesToHit));
		}

		for(FutureGameObject fgoNew : fsNew.gameObjects)
		{
			fgoNew.x += fgoNew.vx * framesToShot;
			fgoNew.y += fgoNew.vy * framesToShot;
			
			fgoNew.x -= Math.floor(fgoNew.x / 1024.0) * 1024.0;
			fgoNew.y -= Math.floor(fgoNew.x / 768.0) * 768.0;
		}
		
		int frameHit = fs.frame + framesToHit;
		fsNew.addShot(frameHit);
		
		int sumFrameHit = (4 - fsNew.shotEndTimesCnt) * fsNew.frame;
		int lastHit = 0;
		for(int j = 0; j < fsNew.shotEndTimesCnt; j++)
		{
			sumFrameHit += fsNew.shotEndTimes[j];
			lastHit = Math.max(lastHit, fsNew.shotEndTimes[j]);
		}
		
		FutureGameObject ufo = null;
		double frameUntilUfoHit = 0;
		for(FutureGameObject fgoCheck : fsNew.gameObjects)
		{
			if(fgoCheck.type == FutureGameObject.UFO)
			{
				ufo = fgoCheck;

				int minFramesToShot = fsNew.shotEndTimesCnt < 4 ? 2 :
					Math.max(2, fsNew.shotEndTimes[fsNew.shotEndTimesCnt - 4] - fsNew.frame);
				
				frameUntilUfoHit = calcFramesToHit(fsNew.shipAngle, new int[1], new double[1], minFramesToShot, 
													ufo.x - fsNew.shipPosX, ufo.y - fsNew.shipPosY,
													ufo.vx, ufo.vy,
													ufo.getRadius())
										+ fsNew.frame - fsNew.frameFirst;
				
				break;
			}
		}
		
		if(fgo.type == FutureGameObject.UFO)
		{
			fsNew.evalAdd += (frameHit - fsNew.frameFirst);
		}
		
		fsNew.eval = (fsNew.gameObjects.size() + fsNew.shotEndTimesCnt > 3 ? 
							(sumFrameHit / 4.0) : lastHit) 
				+ frameUntilUfoHit + fsNew.evalAdd;
		
		PriorityQueue<CollisionInfo> pqCollisions = new PriorityQueue<CollisionInfo>();
		for(FutureGameObject fgoCheck : fsNew.gameObjects)
		{
			Integer frameCollision = fsNew.collisionMap.get(fgoCheck.id);
			if(frameCollision != null)
			{
				int f = (fgoCheck.type == FutureGameObject.UFO ? 1 :
							new int[] { 7, 3, 1 } [-fgoCheck.size]);
				
				for(int i = 0; i < f; i++)
				{
					pqCollisions.offer(new CollisionInfo(fgoCheck, frameCollision));
				}
			}
		}
		
		int[] shotEndTimes = new int[fsNew.shotEndTimesCnt];
		System.arraycopy(fsNew.shotEndTimes, 0, shotEndTimes, 0, shotEndTimes.length);
		int coll = minFramesToCollision(fsNew, fsNew.frame, 
										fsNew.shipAngle, shotEndTimes,
										pqCollisions);

		fsNew.eval += 10 * (100 - Math.max(0, Math.min(100, coll)));
			
		return fsNew;
	}

	/**
	 * check, if the ship can avoid a collision with the asteroids/ufo
	 */
	private static int minFramesToCollision(FutureState fs, int frame, double shipAngle,
			int[] shotEndTimes, PriorityQueue<CollisionInfo> pqCollisions) 
	{
		if(pqCollisions.size() == 0)
		{
			return Integer.MAX_VALUE;
		}
		
		int framesToColl = Integer.MAX_VALUE;
		
		CollisionInfo ci = pqCollisions.poll();
		
		if(ci.collisionFrame - frame > 100)
		{
			return Integer.MAX_VALUE;
		}
		
		int minFramesToShot = shotEndTimes.length < 4 ? 5 : 
							Math.max(5, shotEndTimes[shotEndTimes.length - 4] - frame);

		int[] framesToShot = new int[1];
		double[] shipAngleNew = new double[1];
		
		int framesToHit = calcFramesToHit(shipAngle,
				framesToShot,
				shipAngleNew,
				minFramesToShot,
				ci.fgo.x - fs.shipPosX, ci.fgo.y - fs.shipPosY,
				ci.fgo.vx, ci.fgo.vy,
				ci.fgo.getRadius());

		framesToColl = ci.collisionFrame - (framesToHit + frame);
		
		int i = 0;
		for(; i < shotEndTimes.length; i++)
		{
			if(shotEndTimes[i] > framesToShot[0] + frame)
			{
				break;
			}
		}
		
		int[] shotEndTimesNew = new int[shotEndTimes.length - i + 1];
		System.arraycopy(shotEndTimes, i, shotEndTimesNew, 0, shotEndTimesNew.length - 1);
		
		int frameShotEnd = framesToHit + frame;
		i = 0;
		for(; shotEndTimesNew[i] < frameShotEnd && i < shotEndTimesNew.length - 1; i++);
		System.arraycopy(shotEndTimesNew, i, shotEndTimesNew, i + 1, shotEndTimesNew.length - i - 1);
		shotEndTimesNew[i] = framesToHit + frame;

		return Math.min(framesToColl, 
						minFramesToCollision(fs, framesToShot[0], shipAngleNew[0], 
											shotEndTimesNew, pqCollisions));
	}	
	
	/**
	 * determine the time it would take to hit an object with the given
	 * relative position, relative speed and radius
	 */
	private static int calcFramesToHit(double shipAngle,
									int[] framesToShot,
									double[] shipAngleNew,
									int minFramesToShot,
									double x, double y, double vx, double vy,
									int radius)
	{
		int i = minFramesToShot;
		int[] framesToTurn = new int[1];
		int[] framesShot = new int[1];
		double[] shipAngleHit = new double[1];
		
		boolean[][] checkXY = new boolean[3][3];
		boolean found = false;
		while(i < 150 && !found)
		{
			int minFramesToHit = Integer.MAX_VALUE;
			for(int ix = -1; ix <= 1; ix++)
			{
				for(int iy = -1; iy <= 1; iy++)
				{
					int framesToHit = calcFramesToHit2(shipAngle, framesToTurn, 
												framesShot, shipAngleHit,
												x, y, vx, vy, radius, i, ix, iy);

					if(0 < framesToHit && framesToHit < 1000)
					{
						minFramesToHit =
							Math.min(minFramesToHit, 
									framesToHit + Math.max(0, minFramesToShot - framesToTurn[0]));
					}

					if(framesToHit <= i && i - framesShot[0] >= minFramesToShot
							&& framesShot[0] <= 69)
					{
						shipAngleNew[0] = shipAngleHit[0];
						framesToShot[0] = i - framesShot[0];
						found = true;
						checkXY[ix + 1][iy + 1] = true;
					}
				}
			}
			
			if(i < minFramesToHit && minFramesToHit < 1000)
			{
				i = minFramesToHit + 2;
			}
			else
			{
				i += 8;
			}
		}

		if(!found)
		{
			return Integer.MAX_VALUE;
		}
		
		while(i > 0 && found)
		{
			found = false;
			i--;
			for(int ix = -1; ix <= 1; ix++)
			{
				for(int iy = -1; iy <= 1; iy++)
				{
					if(!checkXY[ix + 1][iy + 1])
					{
						continue;
					}
					
					int framesToHit = calcFramesToHit2(shipAngle, framesToTurn,
												framesShot, shipAngleHit, 
												x, y, vx, vy, radius, i, ix, iy);

					if(framesToHit <= i && i - framesShot[0] >= minFramesToShot
							&& framesShot[0] <= 69)
					{
						found = true;
						shipAngleNew[0] = shipAngleHit[0];
						framesToShot[0] = i - framesShot[0];
					}
					else
					{
						checkXY[ix + 1][iy + 1] = false;
					}
				}
			}
		}

		int framesToHit = i + 1;
		
		return framesToHit;
	}

	static int cntCalcFramesToHit2 = 0;
	private static int calcFramesToHit2(double shipAngle, int[] framesToTurn,
										int[] framesShot,
										double[] shipAngleNew,
										double x, double y, double vx, double vy, 
										int radius, int i, int ix, int iy) 
	{
		cntCalcFramesToHit2++;
		double px = x + vx * i + 1024 * ix;
		double py = y + vy * i + 768 * iy;

		double dist = Math.sqrt(px * px + py * py);
		int shotFrames = (int) Math.ceil((dist - radius - 20) / 8);
		
		if(shotFrames > 69)
		{
			return Integer.MAX_VALUE;
		}

		double angleHit = Math.atan2(py, px);
		double turn = Math.abs(angleHit - shipAngle);
		if(turn > Math.PI)
		{ 
			turn = 2 * Math.PI - turn;
		}
		
		int turnFrames = (int) Math.ceil(turn / 2.0 / Math.PI * 256.0 / 3.0);
		
		int framesToHit = turnFrames + shotFrames;
		framesToTurn[0] = turnFrames;
		framesShot[0] = shotFrames;
		shipAngleNew[0] = angleHit;
		
		return framesToHit;
	}

	private static void addFutureObjects(State state, FutureState fs) 
	{
		HashMap<State.GameObject, Vector<Integer>> attackedTimes 
			= new HashMap<State.GameObject, Vector<Integer>>();
		
		Vector<State.Shot> shots = new Vector<State.Shot>();
		shots.addAll(state.shots);
		shots.addAll(state.shotsLaunched);
		
		PriorityQueue<HitInfo> pqHits = new PriorityQueue<HitInfo>();
		for(State.Shot s : shots)
		{
			if(s.id >= 0 && s.hitAtFrame >= 0)
			{
				// avoid planned shots, which have been matched to real ones
				continue;
			}
			
			// use planned shot vector, if appropriate (is more precise)
			if(s.myShot)
			{
				for(State.Shot sl : state.shotsLaunched)
				{
					if(sl.id == s.id)
					{
						s.vx = sl.vx;
						s.vy = sl.vy;
					}
				}
			}
			
			int framesRemaining = s.sinceFrame + 68 - state.frame;
			
			for(State.Asteroid a : state.asteroids)
			{
				double framesUntilHit = calcHit(s, a, framesRemaining, false);
				if(framesUntilHit < framesRemaining)
				{
					pqHits.add(new HitInfo(s, a, framesUntilHit));
				}
			}
			
			if(state.ufo != null)
			{
				double framesUntilHit = calcHit(s, state.ufo, framesRemaining, false);
				if(framesUntilHit < framesRemaining)
				{
					pqHits.add(new HitInfo(s, state.ufo, framesUntilHit));
				}
			}
		}
		
		// Add smaller asteroids for those medium/large ones, which will be hit
		// by shots. Also add the shots, which are hits.
		HashSet<State.Shot> shotsConsumed = new HashSet<State.Shot>();
		while(pqHits.size() > 0)
		{
			HitInfo hit = pqHits.poll();
			int framesUntilHit = (int) Math.ceil(hit.framesUntilHit);
			
			State.Shot s = (State.Shot) hit.obj1;
			State.GameObject go = hit.obj2;
			
			int attackedMax = 1;
			if(go instanceof State.Asteroid)
			{
				State.Asteroid a = (State.Asteroid) go;
				attackedMax = new int[] { 4, 3, 1 } [-a.size];
			}
								
			if(shotsConsumed.contains(s) 
					|| (attackedTimes.containsKey(go)
							&& (attackedTimes.get(go).size() >= attackedMax)))
//									|| framesUntilHit - attackedTimes.get(go).firstElement() > 10)))
			{
				continue;
			}

			shotsConsumed.add(s);
			
			if(!attackedTimes.containsKey(go))
			{
				attackedTimes.put(go, new Vector<Integer>());
			}
			attackedTimes.get(go).add(framesUntilHit + fs.frame);
			
			if(s.hitAtFrame >= 0)
			{
				hit.obj2.attacked = true;
			}
			else
			{
				hit.obj2.willBeHit = true;
			}
			
			fs.addShot(state.frame + framesUntilHit);
		}
		
		// add ufo, if it was not attacked
		if(state.ufo != null && !attackedTimes.containsKey(state.ufo))
		{
			fs.addGo(FutureGameObject.newUfo(state.ufo));
		}

		// add asteroids, which were not attacked, and smaller ones for those
		// which were
		for(State.Asteroid a : state.asteroids)
		{
			if(!attackedTimes.containsKey(a))
			{
				fs.addGo(FutureGameObject.newAsteroid(a));
			}
			else
			{
				Vector<FutureGameObject> fgoNew = new Vector<FutureGameObject>();
				fgoNew.add(FutureGameObject.newAsteroid(a));
				
				for(int t : attackedTimes.get(a))
				{
					splitAsteroid(fgoNew, t);
				}
				
				fs.gameObjects.addAll(fgoNew);
			}
		}
		
		// add missing shots
		for(State.Shot s : shots)
		{
			if(!shotsConsumed.contains(s) && (s.id == 0 || s.hitAtFrame == 0))
			{
				fs.addShot((int) Math.ceil(fs.frame + 72 - s.sinceFrame));
			}
		}
	}

	private static void splitAsteroid(Vector<FutureGameObject> fgoNew, int f) 
	{
		if(fgoNew.size() == 0)
		{
			return;
		}
		
		FutureGameObject a = fgoNew.remove(0);
		if(a.size > -2)
		{
			fgoNew.add(FutureGameObject.newAsteroidSmaller(a, f));
			fgoNew.add(FutureGameObject.newAsteroidSmaller(a, f));
		}
	}

	private static int determineShotAngle(State state) 
	{
		int angleShot = state.ship.angle;
		
		for(int i = 0; i < state.latency; i++)
		{
			if(i > states.size() - 2)
			{
				continue;
			}
			byte turn = states.get(states.size() - 2 - i).keys;
			if((turn & 8) > 0)
			{
				angleShot++;
			}
			else if((turn & 16) > 0)
			{
				angleShot--;
			}
		}
		
		return (angleShot + 256) % 256;
	}
	
	public static boolean attack(State state, Keys keys, State.GameObject go, 
								double maxFrame, int asteroidSize,
								int minFrameNextShotAvail)
	{
		State.GameObject go2 = cloneGameObject(state, go);
		if(go2 instanceof State.Asteroid)
		{
			((State.Asteroid) go2).size = asteroidSize;
		}
		
		int angleShot = determineShotAngle(state);
		
//System.out.print("Attacking " + go.getClass().getName() + ", ID " + go.id + " - ");		
		
		int angleHit = -1;
		
		int i = 0;
		int[] d = new int[] { 5, 8, 10, 16, 32 };
		while(angleHit == -1 && i < d.length)
		{
			angleHit = calcAngleHit(state, go, angleShot, d[i]);
			i++;
		}

		int angleRight = (angleHit - angleShot + 256) & 0xFF;
		int angleLeft = (angleShot - angleHit + 256) & 0xFF;
		
		if(state.myShotCnt < 4 && keys.canShoot)
		{
			// check, if a shot would hit the object; then shoot
			double dx = shotAngles[angleShot].x;
			double dy = shotAngles[angleShot].y;

			double vx = state.ship.vx + dx / 8.0;
			double vy = state.ship.vy + dy / 8.0;
			
			State.Shot shot = new State.Shot(state.frame + state.latency, state.ship.x + vx * 1.4, state.ship.y + vy * 1.4);
			shot.vx = vx;
			shot.vy = vy;

			boolean small = (angleShot != angleHit);
			double frameHit = calcHit(shot, go2, 70, go2.getRadius(small));
			double shrink = frameHit * 0.5 / Math.max(state.frame - go.sinceFrame, 0.01);
			if(((frameHit = calcHit(shot, go2, 70, Math.max(0, go2.getRadius(small) - shrink))) < 70 
						|| (angleHit == angleShot && state.myShotCnt == 0))
					&& keys.shoot())
			{
				shot.hitAtFrame = frameHit + state.frame + state.latency;
				shot.shipAngle = angleShot;
				state.shotsLaunched.add(shot);

				go.nextAttacked = true;
			}
			else if(state.myShotCnt < 3
						|| (state.myShotCnt == 3
								&& minFrameNextShotAvail <= Math.min(angleLeft, angleRight))
						|| angleHit == -1)
			{
				// would it hit any asteroid?
				State.Asteroid aHit = null;
				double frameHitFirst = Double.MAX_VALUE;
				
				for(State.Asteroid a : state.asteroids)
				{
					if(a.attacked || a.willBeHit || a == go)
					{
						continue;
					}
					frameHit = calcHit(shot, a, 70, a.getRadius(true));
					shrink = frameHit * 1.0 / Math.max(state.frame - a.sinceFrame, 0.01);
					if((frameHit = calcHit(shot, a, 70, Math.max(0, a.getRadius(true) - shrink))) < 68
							&& frameHit < frameHitFirst)
					{
						frameHitFirst = frameHit;
						aHit = a;
					}
				}
				
				if(frameHitFirst < 69)
				{
					if((state.asteroids.size() >= 21 && aHit.size == -1)
							|| (state.asteroids.size() >= 16 && aHit.size == 0))
					{
						// no shot
					}
					else
					{
						if(keys.shoot())
						{
							shot.hitAtFrame = frameHitFirst + state.frame + state.latency;
							shot.shipAngle = angleShot;
							state.shotsLaunched.add(shot);
						}
					}
				}
			}
		}
		
		if(angleHit == -1)
		{
			return true;
		}
		
		if(angleHit == angleShot)
		{
			// do nothing
		}
		else if(angleLeft < angleRight)
		{
			keys.left();
		}
		else
		{
			keys.right();
		}
			
		go.nextAttacked = true;
		return true;
	}

	private static State.GameObject cloneGameObject(State state,
			State.GameObject go) 
	{
		State.GameObject go2 = null;
		try
		{
			go2 = (State.GameObject) go.clone();
		}
		catch(Exception exc)
		{
			exc.printStackTrace();
		}
		
		go2.x += state.latency * go2.vx + 0.5;
		go2.y += state.latency * go2.vy + 0.5;
		return go2;
	}

	private static int calcAngleHit(State state, State.GameObject go, int angleCurr, double size) 
	{
		State.GameObject go2 = cloneGameObject(state, go);
		
		int angleHit = -1;
		double[] framesUntilHitMin = new double[1];
		framesUntilHitMin[0] = Double.MAX_VALUE;
		
		int t = 0;
		for(; t < 50; t += 10)
		{
			int angleHitTest = calcAngleHitT(state, angleCurr, size, go2,
											framesUntilHitMin, t);
			if(angleHitTest > -1)
			{
				angleHit = angleHitTest;
				break;
			}
		}
		
		if(angleHit > -1)
		{
			int angleHitTest = 0;
			while(angleHitTest > -1)
			{
				angleHitTest = calcAngleHitT(state, angleCurr, size, go2,
												framesUntilHitMin, t);
				if(angleHitTest > -1)
				{
					angleHit = angleHitTest;
				}
			}
		}
		
		return angleHit;
	}

	private static int calcAngleHitT(State state, int angleCurr,
									double size, State.GameObject go2,
									double[] framesUntilHitMin, int t) 
	{
		int angleHit = -1;
		for(int i = -t; i <= t; i++)
		{
			int a = (angleCurr + i + 256) % 256;

			double dx = shotAngles[a].x;
			double dy = shotAngles[a].y;

			double vx = state.ship.vx + dx / 8.0;
			double vy = state.ship.vy + dy / 8.0;

			State.Shot shot = new State.Shot(state.frame + t + state.latency, 
										state.ship.x + vx, state.ship.y + vy);
			shot.vx = vx;
			shot.vy = vy;
			
			double framesUntilHit = calcHit(shot, go2, 70, size);
			if(framesUntilHit < 70 && framesUntilHit + t < framesUntilHitMin[0])
			{
				angleHit = a;
				framesUntilHitMin[0] = framesUntilHit + t;
				break;
			}
		}
		return angleHit;
	}
	
	/**
	 * determine the ship angle in the current frame received from the MAME server
	 */
	private static void determineShipAngle()
	{
		int i = states.size() - 1;
		
		State state = states.get(i);
		State.Ship ship = state.ship;
		
		HashMap<Integer, Integer> angleCandidates = new HashMap<Integer, Integer>();
		for(int a = 0; a < 255; a++)
		{
			if(shipAngles[a].x == ship.dx && shipAngles[a].y == ship.dy)
			{
				angleCandidates.put(a, a);
			}
		}
		
		while(i > 0 && angleCandidates.size() > 1)
		{
			state = states.get(i - 1);
			State.Ship shipBefore = state.ship;
			if(shipBefore == null || i - state.latency < 1)
			{
				break;
			}
			
			byte keysBefore = states.get(i - 1 - state.latency).keys;
			int delta = 0;
			if((keysBefore & 16) > 0)	// left
			{
				delta = -1;
			}
			else if((keysBefore & 8) > 0)	// right
			{
				delta = 1;
			}
			
			if(delta == 0)
			{
				i--;
				continue;
			}

			Integer[] v = angleCandidates.keySet().toArray(new Integer[0]);
			for(int a : v)
			{
				int x = angleCandidates.get(a);
				int aBefore = (x - delta + 256) % 256;
				angleCandidates.put(a, aBefore);
				if(shipAngles[aBefore].x != shipBefore.dx)
				{
					angleCandidates.remove(a);
				}
				
				if(angleCandidates.size() == 1)
				{
					break;
				}
			}
				
			i--;
		}
		
		ship.angle = angleCandidates.keySet().iterator().next();
	}
	
	static double calcAngle(double dx, double dy)
	{
		return Math.atan2(dy, dx);
	}
	
	static double calcAngleDiff(double a1, double a2)
	{
		double angleDiff = a1 - a2;
		if(angleDiff >= Math.PI)
		{
			angleDiff -= 2 * Math.PI;
		}
		if(angleDiff <= -Math.PI)
		{
			angleDiff += 2 * Math.PI;
		}
		return Math.abs(angleDiff);
	}
}
