import javax.swing.JPanel;
import javax.swing.JDialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.JSlider;

public class ReplayControlDialog extends JDialog
{
	class ReplayThread extends Thread
	{
		int slowFactor;
		
		ReplayThread(int slowFactor)
		{
			this.slowFactor = slowFactor;
		}
		
		public void run()
		{
			long frameTime = System.nanoTime();
			
			while(replayThread == this)
			{
				if(currentState >= states.size())
				{
					stopReplay();
					break;
				}
				
				visu.setState(states.get(currentState));
				frameTime += 16666666 * slowFactor;
				
				try
				{
					Thread.sleep((frameTime - System.nanoTime()) / 1000000);
				}
				catch(Exception exc)
				{
				}
				
				currentState++;
			}
		}
	}
	
	private ReplayThread replayThread = null;
	
	private static final long serialVersionUID = 1L;
	private JPanel jContentPane = null;
	private JButton pauseButton = null;
	private JButton rewindButton = null;
	private JButton skipButton = null;
	private JButton backStepButton = null;
	private JButton forwardStepButton = null;
	private JButton backStep10Button = null;
	private JButton forwardStep10Button = null;
	private JButton backStep100Button = null;
	private JButton forwardStep100Button = null;
	private JButton backStep1000Button = null;
	private JButton forwardStep1000Button = null;
	private JButton forwardShipLostButton = null;

	private Vector<State> states;  //  @jve:decl-index=0:
	private VisuFrame visu;
	
	int currentState = 0;
	private JToggleButton playButton = null;
	private JToggleButton playSlowButton = null;

	private JButton debugFrameButton = null;
	/**
	 * This is the default constructor
	 */
	public ReplayControlDialog() 
	{
		super();
		initialize();
	}

	public ReplayControlDialog(JFrame parent) 
	{
		super(parent);
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() 
	{
		this.setContentPane(getJContentPane());
		this.setTitle("Replay Control");
		pack();
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new JPanel();
			jContentPane.setLayout(new FlowLayout());
			jContentPane.add(getRewindButton());
			jContentPane.add(getPlayButton());
			jContentPane.add(getPlaySlowButton());
			jContentPane.add(getPauseButton());
			jContentPane.add(getSkipButton());
			jContentPane.add(getBackStepButton());
			jContentPane.add(getForwardStepButton());
			jContentPane.add(getBackStep10Button());
			jContentPane.add(getForwardStep10Button());
			jContentPane.add(getBackStep100Button());
			jContentPane.add(getForwardStep100Button());
			jContentPane.add(getBackStep1000Button());
			jContentPane.add(getForwardStep1000Button());
			jContentPane.add(getForwardShipLostButton());
			jContentPane.add(getDebugFrameButton(), null);
		}
		return jContentPane;
	}

	/**
	 * This method initializes pauseButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getPauseButton() 
	{
		if (pauseButton == null) 
		{
			pauseButton = new JButton();
			pauseButton.setText("||");
			pauseButton.setToolTipText("pause");
			pauseButton.addActionListener(
					new ActionListener()
					{
						public void actionPerformed(ActionEvent e) 
						{
							stopReplay();
						}
					});
		}
		return pauseButton;
	}

	/**
	 * This method initializes rewindButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getRewindButton() {
		if (rewindButton == null) {
			rewindButton = new JButton();
			rewindButton.setText("<<");
		}
		return rewindButton;
	}

	/**
	 * This method initializes skipButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getSkipButton() {
		if (skipButton == null) {
			skipButton = new JButton();
			skipButton.setText(">>");
		}
		return skipButton;
	}

	private JButton getBackStep10Button() {
		if (backStep10Button == null) {
			backStep10Button = new JButton();
			backStep10Button.setText("|< 10");
			backStep10Button.setToolTipText("rewind 10 frames");
			backStep10Button.addActionListener(
					new ActionListener()
					{
						public void actionPerformed(ActionEvent e) 
						{
							addToStep(-10);
						}
					});
		}
		return backStep10Button;
	}

	private JButton getForwardStep10Button() {
		if (forwardStep10Button == null) {
			forwardStep10Button = new JButton();
			forwardStep10Button.setText(">| 10");
			forwardStep10Button.setToolTipText("skip 10 frames");
			forwardStep10Button.addActionListener(
					new ActionListener()
					{
						public void actionPerformed(ActionEvent e) 
						{
							addToStep(10);
						}
					});
		}
		return forwardStep10Button;
	}

	private JButton getBackStep100Button() {
		if (backStep100Button == null) {
			backStep100Button = new JButton();
			backStep100Button.setText("|< 100");
			backStep100Button.setToolTipText("rewind 100 frames");
			backStep100Button.addActionListener(
					new ActionListener()
					{
						public void actionPerformed(ActionEvent e) 
						{
							addToStep(-100);
						}
					});
		}
		return backStep100Button;
	}

	private JButton getForwardStep100Button() {
		if (forwardStep100Button == null) {
			forwardStep100Button = new JButton();
			forwardStep100Button.setText(">| 100");
			forwardStep100Button.setToolTipText("skip 100 frames");
			forwardStep100Button.addActionListener(
					new ActionListener()
					{
						public void actionPerformed(ActionEvent e) 
						{
							addToStep(100);
						}
					});
		}
		return forwardStep100Button;
	}

	private JButton getBackStep1000Button() {
		if (backStep1000Button == null) {
			backStep1000Button = new JButton();
			backStep1000Button.setText("|< 1000");
			backStep1000Button.setToolTipText("rewind 1000 frames");
			backStep1000Button.addActionListener(
					new ActionListener()
					{
						public void actionPerformed(ActionEvent e) 
						{
							addToStep(-1000);
						}
					});
		}
		return backStep1000Button;
	}

	private JButton getForwardStep1000Button() {
		if (forwardStep1000Button == null) {
			forwardStep1000Button = new JButton();
			forwardStep1000Button.setText(">| 1000");
			forwardStep1000Button.setToolTipText("skip 1000 frames");
			forwardStep1000Button.addActionListener(
					new ActionListener()
					{
						public void actionPerformed(ActionEvent e) 
						{
							addToStep(1000);
						}
					});
		}
		return forwardStep1000Button;
	}

	private JButton getBackStepButton() {
		if (backStepButton == null) {
			backStepButton = new JButton();
			backStepButton.setText("|<");
			backStepButton.setToolTipText("rewind one frame");
			backStepButton.addActionListener(
					new ActionListener()
					{
						public void actionPerformed(ActionEvent e) 
						{
							addToStep(-1);
						}
					});
		}
		return backStepButton;
	}

	private JButton getForwardStepButton() {
		if (forwardStepButton == null) {
			forwardStepButton = new JButton();
			forwardStepButton.setText(">|");
			forwardStepButton.setToolTipText("skip one frame");
			forwardStepButton.addActionListener(
					new ActionListener()
					{
						public void actionPerformed(ActionEvent e) 
						{
							addToStep(1);
						}
					});
		}
		return forwardStepButton;
	}

	private JButton getForwardShipLostButton() {
		if (forwardShipLostButton == null) {
			forwardShipLostButton = new JButton();
			forwardShipLostButton.setText(">| X");
			forwardShipLostButton.setToolTipText("jump to next ship loss");
			forwardShipLostButton.addActionListener(
					new ActionListener()
					{
						public void actionPerformed(ActionEvent e) 
						{
							currentState++;
							while(currentState < states.size() - 1 
									&& states.get(currentState).ships <= states.get(currentState + 1).ships)
							{
								currentState++;
							}
							addToStep(0);
						}
					});
		}
		return forwardShipLostButton;
	}

	public void setStates(Vector<State> states)
	{
		this.states = states;
	}
	
	public void setVisu(VisuFrame visu)
	{
		this.visu = visu;
	}

	/**
	 * This method initializes playButton	
	 * 	
	 * @return javax.swing.JToggleButton	
	 */
	private JToggleButton getPlayButton() 
	{
		if (playButton == null) 
		{
			playButton = new JToggleButton();
			playButton.setText(">");
			playButton.setToolTipText("play");
			playButton.addActionListener(
					new ActionListener()
					{
						public void actionPerformed(ActionEvent e) 
						{
							stopReplay();
							startReplay(1);
						}
					});
		}
		return playButton;
	}

	private JToggleButton getPlaySlowButton() 
	{
		if (playSlowButton == null) 
		{
			playSlowButton = new JToggleButton();
			playSlowButton.setText(">-");
			playSlowButton.setToolTipText("play slow");
			playSlowButton.addActionListener(
					new ActionListener()
					{
						public void actionPerformed(ActionEvent e) 
						{
							stopReplay();
							startReplay(10);
						}
					});
		}
		return playSlowButton;
	}

	void startReplay(int slowFactor)
	{
		replayThread = new ReplayThread(slowFactor);
		replayThread.start();
	}
	
	void stopReplay()
	{
		replayThread = null;
		playButton.setSelected(false);
		playSlowButton.setSelected(false);
	}
	
	void addToStep(int delta)
	{
		currentState = Math.max(0, Math.min(states.size(), currentState + delta));
		visu.setState(states.get(currentState));
	}

	/**
	 * This method initializes debugFrameButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getDebugFrameButton() {
		if (debugFrameButton == null) {
			debugFrameButton = new JButton();
			debugFrameButton.setText("Debug");
			debugFrameButton.addActionListener(new java.awt.event.ActionListener() 
			{
				public void actionPerformed(java.awt.event.ActionEvent e) 
				{
					Player.states = new Vector<State>();
					for(int i = 0; i <= currentState; i++)
					{
						Player.states.add(states.get(i));
					}
					Player.determineAction(states.get(currentState), new Keys());
				}
			});
		}
		return debugFrameButton;
	}
}  //  @jve:decl-index=0:visual-constraint="10,10"
