import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.WindowConstants;


public class VisuFrame extends JFrame
{
	State currentState = null;
	
	VisuFrame()
	{
		setContentPane(new VisuPanel());
		pack();
		setVisible(true);
		setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
	}
	
	public void setState(State state)
	{
		currentState = state;
		
		SwingUtilities.invokeLater(
				new Runnable()
				{
					public void run()
					{
						((VisuPanel) getContentPane()).setState(currentState);
						getContentPane().repaint();
					}
				});
	}
}
