// connection.h: Beispielspieler fr Asteroids (Verbindung zu Mame)
// Harald Bgeholz / c't; Umstrukturierung Matthias Fuchs

#ifndef ConnectionH
#define ConnectionH

#include <stdint.h>

// 3 Includes fr sockaddr_in
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>


#define SOCKET  int
#define ADDRESS in_addr_t


#pragma pack(1)
// byteweise Ausrichtung der Datenstrukturen
struct FramePacket
{
      uint8_t vectorram[1024];

      // wird bei jedem Frame inkrementiert
      int8_t frameno;

      // Der Server schickt das letzte empfangene ping-Byte zurck
      int8_t ping;

      /* ctor */
      FramePacket(void);
};

class KeysPacket
{
  private:
   static const char KEY_HYPERSPACE = 0x01;
   static const char KEY_FIRE       = 0x02;
   static const char KEY_THRUST     = 0x04;
   static const char KEY_RIGHT      = 0x08;
   static const char KEY_LEFT       = 0x10;
   static const char KEY_START      = 0x20;

   char signature[6];
   char keys;

   void setclearbit(const bool b, const char mask);

  public:
   /* wird vom Server bei nchster Gelegenheit zurckgeschickt. Fr
    * Latenzmessung. */
   int8_t ping;

   KeysPacket(void);
   void clear(void);         // alle Tasten loslassen
   /* Startbutton drcken (true) oder loslassen (false) (nur mit
    * aktualisierter Mame) */
   void start(bool b);
   // Hyperspace drcken (true) oder loslassen (false)
   void hyperspace(bool b);
   // Feuerknopf drcken (true) oder loslassen (false)
   void fire(bool b);
   void thrust(bool b);      // Beschleunigen ...
   void right(bool b);       // rechts drehen ...
   void left(bool b);        // links drehen

   bool start(void) const;
   bool hyperspace(void) const;
   bool fire(void) const;
   bool thrust(void) const;
   bool right(void) const;
   bool left(void) const;
};
#pragma pack()


class connection_error
{
  public:
   connection_error(const char* format, ...);
   inline const char* what(void) const;

  private:
   char message[1024];
};


class Connection
{
  public:
   Connection(const char* server_ip_str);
   ~Connection();
   void ReceivePacket(FramePacket &packet);
   void SendPacket(const KeysPacket &packet);

  private:
   SOCKET  sd;
   ADDRESS server_ip;
};



inline const char* connection_error::what(void) const
{
   return message;
}

#endif
