// output.cpp: Gekapselte Ausgabefunktionen
// Matthias Fuchs

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>             // va_list

#include "output.h"

void OutputError    (const char* str)
{
   fprintf (stderr, "Error: %s", str);
}

void OutputError2   (const char* format, ...)
{
   char str[1024];

   va_list arglist;
   va_start(arglist, format);

   vsprintf(str, format, arglist);

   va_end(arglist);

   OutputError (str);
}

void OutputWarning  (const char* str)
{
   fprintf (stderr, "Warning: %s", str);
}

void OutputWarning2   (const char* format, ...)
{
   char str[1024];

   va_list arglist;
   va_start(arglist, format);

   vsprintf(str, format, arglist);

   va_end(arglist);

   OutputWarning (str);
}

void OutputInfo     (const char* str)
{
   fprintf (stdout, "%s", str);
}

void OutputInfo2    (const char* format, ...)
{
   char str[1024];

   va_list arglist;
   va_start(arglist, format);

   vsprintf(str, format, arglist);

   va_end(arglist);

   OutputInfo (str);
}

void OutputDebug    (const char* str)
{
   fprintf (stderr, "Debug: %s", str);
}

void OutputDebug2   (const char* format, ...)
{
   char str[1024];

   va_list arglist;
   va_start(arglist, format);

   vsprintf(str, format, arglist);

   va_end(arglist);

   OutputDebug (str);
}


