/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.analysis;

import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;
import de.caff.asteroid.analysis.DumpFile;
import de.caff.asteroid.analysis.FrameKeyInfoDisplay;
import de.caff.asteroid.analysis.TimeLine;
import java.awt.Component;
import java.io.IOException;
import javax.swing.JFrame;

public class AnalysisDisplay
extends JFrame {
    public AnalysisDisplay(final String filename) throws IOException {
        super("Analysis of " + filename);
        DumpFile dumpFile = new DumpFile(filename);
        final TimeLine timeLine = new TimeLine(dumpFile);
        FrameKeyInfoDisplay frameKeyInfoDisplay = new FrameKeyInfoDisplay(timeLine);
        timeLine.addFrameListener(new FrameListener(){

            @Override
            public void frameReceived(FrameInfo frame) {
                AnalysisDisplay.this.setTitle(String.format("%s [%d]", filename, timeLine.getCurrentIndex()));
            }
        });
        this.getContentPane().add((Component)frameKeyInfoDisplay, "Center");
        this.getContentPane().add((Component)timeLine, "South");
        this.setSize(1200, 800);
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Need dump file argument!");
            System.exit(1);
        }
        AnalysisDisplay dpy = new AnalysisDisplay(args[0]);
        dpy.setDefaultCloseOperation(3);
        dpy.setVisible(true);
    }
}

