/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.MovingGameObject;
import de.caff.asteroid.Property;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Collection;

public class Explosion
extends MovingGameObject {
    private static final GeneralPath SHAPE = new GeneralPath();
    private Type type;
    private int scale;

    static {
        SHAPE.moveTo(1.0, 0.6);
        SHAPE.curveTo(0.7, 0.6, 0.6, 0.7, 0.6, 1.0);
        SHAPE.moveTo(0.5, 1.0);
        SHAPE.curveTo(0.3, 0.9, -0.3, 0.9, -0.5, 1.0);
        SHAPE.append(SHAPE.createTransformedShape(AffineTransform.getRotateInstance(1.5707963267948966)), false);
        SHAPE.append(SHAPE.createTransformedShape(AffineTransform.getRotateInstance(Math.PI)), false);
    }

    public Explosion(int x, int y, int scale, Type type) {
        super(x, y);
        this.type = type;
        switch (scale) {
            case 0: {
                this.scale = 1;
                break;
            }
            case 15: {
                this.scale = 2;
                break;
            }
            case 14: {
                this.scale = 4;
                break;
            }
            case 13: {
                this.scale = 8;
                break;
            }
            case 12: {
                this.scale = 16;
                break;
            }
            case 11: {
                this.scale = 32;
                break;
            }
            default: {
                System.out.println("Unexpected explosion scaling: " + scale);
                this.scale = 1;
            }
        }
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public int getSize() {
        return this.type.size / this.scale;
    }

    public String toString() {
        return String.format("Explosion(%s)@(%d,%d)*%d", new Object[]{this.type, this.x, this.y, this.getSize()});
    }

    @Override
    public void draw(Graphics2D g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setColor(Color.red);
        AffineTransform trafo = new AffineTransform(this.type.size / this.scale, 0.0f, 0.0f, this.type.size / this.scale, this.x, this.y);
        g2.draw(trafo.createTransformedShape(SHAPE));
    }

    @Override
    public Collection<Property> getProperties() {
        Collection<Property> props = super.getProperties();
        props.add(new Property<Type>("Explosion Type", this.getType()));
        props.add(new Property<Integer>("Scale", this.scale));
        return props;
    }

    @Override
    public String getObjectType() {
        return "Explosion";
    }

    static enum Type {
        XXL(32),
        XL(24),
        L(16),
        S(8);

        int size;

        private Type(int size) {
            this.size = size;
        }
    }
}

