/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.GameData;
import de.caff.asteroid.MovingGameObject;
import de.caff.asteroid.Property;
import de.caff.asteroid.PropertyProvider;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.LinkedList;

public abstract class GameObject
implements GameData,
PropertyProvider {
    protected final int x;
    protected final int y;

    public GameObject(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getSquaredDistance(GameObject obj) {
        return this.getSquaredDistance(obj.getX(), obj.getY());
    }

    public int getSquaredDistance(Point obj) {
        return this.getSquaredDistance((int)obj.getX(), (int)obj.getY());
    }

    public int getSquaredDistanceInNextFrame(MovingGameObject obj) {
        return this.getSquaredDistance(obj.getX() + obj.getVelocityX(), obj.getY() + obj.getVelocityY());
    }

    public int getSquaredDistance(int px, int py) {
        int dx = px - this.x;
        if (dx < -512) {
            dx += 1024;
        } else if (dx >= 512) {
            dx -= 1024;
        }
        int dy = py - this.y;
        if (dy < -384) {
            dy += 768;
        } else if (dy >= 384) {
            dy -= 768;
        }
        return dx * dx + dy * dy;
    }

    public boolean isOverlappingWith(Rectangle rect) {
        Rectangle bounds = this.getBounds();
        return rect.intersects(bounds);
    }

    public abstract Rectangle getBounds();

    @Override
    public Collection<Property> getProperties() {
        LinkedList<Property> props = new LinkedList<Property>();
        props.add(new Property<String>("Type", this.getObjectType()));
        props.add(new Property<Point>("Position", this.getLocation()));
        return props;
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public abstract String getObjectType();
}

