unit U_Schuss;
interface


type TSchuss = class(TObject)
  private
    procedure ueberpruefe_schuss;
    procedure test_auf_treffer(var schritte,obj:integer);

  protected
  public
    Active:boolean;
    detect:boolean;

    xx,yy,id:integer;
    x0,y0,winkel:integer;
    alter:integer;
    obj,schritte:integer;
    check:integer;
    schussNr:integer;

    constructor Create(const aID:integer);
    destructor Destroy; override;
    procedure Idle;
    function sucheDaten(x,y:integer):boolean;
    procedure DatenBegin;
    procedure DatenEnd;
    function sucheDaten_neu(x,y:integer):boolean;
    procedure xSchuss(const o,s:integer);

  end;


implementation
Uses Tools,U_Spiel,U_Asteroid_Manager,U_Asteroid,U_Key,U_Mame,U_Schiff,U_UfoSchuss_Manager,U_UfoSchuss,unit1,
StrUtils, Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls,  ExtCtrls,Sockets,Konstanten,SyncObjs;

constructor TSchuss.Create(const aID:integer);
begin
  inherited Create;
  active:=false;
  id:=aID;
end;

destructor TSchuss.Destroy;
begin

  inherited Destroy;
end;

procedure Tschuss.Idle;
begin
  if (Spiel.idleCounter=9)and(alter>=2)and(check>=3) then ueberpruefe_schuss;
end;

procedure TSchuss.DatenBegin;
begin
  inc(alter,MameLatenz);
  detect:=false;
  inc(check);
end;

procedure TSchuss.DatenEnd;
begin
  if (alter<=1)and(not detect) then detect:=true;
  if (schussNr=1)and(alter<=11)and(not detect) then detect:=true;
end;


procedure Tschuss.test_auf_treffer(var schritte,obj:integer);
var o,i:integer;
    x,y:integer;
begin
  for i:=alter to 69 do begin
      x:=optimiereX(schuss_tabelle[winkel,i].x+x0);
      y:=optimiereY(schuss_tabelle[winkel,i].y+y0);
      for o:=0 to Asteroid.max do
          if (asteroid.Asteroid[o].Active)
             and ((asteroid.Asteroid[o].SchussCounter<=0)or(asteroid.Asteroid[o].SchussCounter>=i-alter))
              and (length(asteroid.Asteroid[o].Zeit)>asteroid.Asteroid[o].alter+i-alter)
                and (istreffer(x,y,asteroid.Asteroid[o].Zeit[asteroid.Asteroid[o].alter+i-alter].x,asteroid.Asteroid[o].Zeit[asteroid.Asteroid[o].alter+i-alter].y,asteroid.Asteroid[o].groesse)) then begin
                   // Treffer;
                   schritte:=i;
                   obj:=o;
                   exit;
      end;
  end;
  obj:=-1;schritte:=-1;
end;


procedure TSchuss.ueberpruefe_schuss;
var o,s:integer;
begin
   test_auf_treffer(s,o);
   check:=0;
   if (o>=0)and(o=obj)and(s=schritte) then exit;
   if (o>=0)and(o=obj) then begin
      // neuer SchussCounter
      schritte:=s;
      asteroid.Asteroid[o].SchussCounter:=s-alter+1;
      asteroid.Asteroid[o].Schussbegin:=s+1;
      exit;
   end;
   if (o<0)and(obj>=0) then begin
      // kein Treffer
      asteroid.Asteroid[obj].SchussCounter:=-1;
      obj:=-1;
      schritte:=-1;
      exit;
   end;
   if (o>=0)and(obj<0) then begin
      // neues obj
      asteroid.Asteroid[o].SchussCounter:=s-alter+1;
      asteroid.Asteroid[o].Schussbegin:=s+1;
      schritte:=s;
      obj:=o;
      exit;
   end;
   if (o>=0)and(obj>=0)and(o<>obj) then begin
      // anderes obj
      asteroid.Asteroid[obj].SchussCounter:=-1;
      asteroid.Asteroid[o].SchussCounter:=s-alter+1;
      schritte:=s;
      obj:=o;
      exit;
   end;
end;







function Tschuss.sucheDaten_neu(x,y:integer):boolean;
var w,s,a,b:integer;
begin
  a:=optimierex(x-schiff.xx);
  b:=optimierey(y-schiff.yy);
  for w:=0 to 255 do for s:=2 to Latenz+MameLatenz+altLatenz do begin // werte zwischen 3 und 5
      if (schuss_tabelle[w,s].x=a)and(schuss_tabelle[w,s].y=b) then begin
         result:=true;
         detect:=true;
         active:=true;
         x0:=schiff.xx;
         y0:=schiff.yy;
         winkel:=w;
         xx:=x;
         yy:=y;
         alter:=s;
         check:=999;
         exit;
      end;
  end;
  result:=false;
end;

function Tschuss.sucheDaten(x,y:integer):boolean;
var vx,vy,xd,yd,i,ii,j:integer;
begin
  result:=false;
  if alter<1 then exit;
  if alter>80 then exit;
  if alter>70 then begin
     xd:= optimiereX(schuss_Tabelle[winkel,70].x-schuss_Tabelle[winkel,70-8].x);
     yd:= optimiereY(schuss_Tabelle[winkel,70].y-schuss_Tabelle[winkel,70-8].y);
     vx:=optimiereX(xx+(xd*MameLatenz) div 8);
     vy:=optimiereY(yy+(yd*MameLatenz) div 8);
     if berechne_abstand(x,y,vx,vy)<10 then begin result:=true;detect:=true;xx:=x;yy:=y;exit;end;
     exit;
  end;
  if (optimierex(x0+schuss_Tabelle[winkel,alter].x)=x)and(optimierey(y0+schuss_Tabelle[winkel,alter].y)=y) then begin result:=true;detect:=true;xx:=x;yy:=y;exit;end;
  if (alter>=1)and(alter<=11) then begin
     if (optimierex(x0+schuss_Tabelle[winkel,alter+1].x)=x)and(optimierey(y0+schuss_Tabelle[winkel,alter+1].y)=y) then begin result:=true;detect:=true;xx:=x;yy:=y;alter:=alter+1;check:=999; exit;end;
     if (optimierex(x0+schuss_Tabelle[optimiereW(winkel-3),alter].x)=x)and(optimierey(y0+schuss_Tabelle[optimiereW(winkel-3),alter].y)=y) then begin result:=true;detect:=true;xx:=x;yy:=y;winkel:=optimiereW(winkel-3);check:=999;exit;end;
     if (optimierex(x0+schuss_Tabelle[optimiereW(winkel+3),alter].x)=x)and(optimierey(y0+schuss_Tabelle[optimiereW(winkel+3),alter].y)=y) then begin result:=true;detect:=true;xx:=x;yy:=y;winkel:=optimiereW(winkel+3);check:=999;exit;end;
  end;

  
     // Winkelbyte-korrecktur beim ersten schuss berprfen
     if (schussNr=1)and(alter>=2)and(alter<=12) then begin 
        for i:=1 to 127 do for ii:=-1 to 1 do if ii<>0 then begin
            if (optimierex(x0+schuss_Tabelle[optimiereW(winkel+i*ii),alter].x)=x)and(optimierey(y0+schuss_Tabelle[optimiereW(winkel+i*ii),alter].y)=y) then begin
               // schuss gefunden
               result:=true;
               detect:=true;
               xx:=x;yy:=y;
               winkel:=optimiereW(winkel+i*ii);
               check:=999;
               // neue richtung bestimmen
               schiff.winkel:=optimiereW(schiff.winkel+i*ii);
               //log('WB','WinkelByte Korektor: '+inttostr(i*ii)+'    SchussNr: '+inttostr(schussNr)+'    alter: '+inttostr(alter),true);{}

               exit;
            end;
        end;


  end;


end;



procedure Tschuss.xSchuss(const o,s:integer);
begin
  inc(schiff.gesamt_schuss_anz);
  if (o>=0)and(s>=2)then begin
     asteroid.Asteroid[o].SchussCounter:=s+1;
     asteroid.Asteroid[o].Schussbegin:=s+1;

     obj:=o;
     schritte:=s;
  end;
  x0:=schiff.xx;
  y0:=schiff.yy;
  winkel:=schiff.winkel;
  alter:=0;
  check:=0;
  detect:=true;
  active:=true;
  schussNr:=schiff.gesamt_schuss_anz;

end;

end.
