unit U_UfoSchuss;
interface
uses Konstanten;

type TUfoSchuss = class(TObject)
  private
    procedure setVorhersage(max:integer;const testMaxVorhersage:boolean=true);
    procedure teste_Hyperspace;
    procedure TrefferVorhersage;
    procedure Treffer_Ausweichrichtung_Vorhersage;
  protected
  public
var Active:boolean;
    detect:boolean;
    xx,yy,alter:integer;
    Treffer:integer;
    Treffer_Ausweichrichtung:integer;


    Zeit:array of TXY;

    constructor Create;
    destructor Destroy; override;
    procedure Idle;

    function sucheDaten(x,y:integer):boolean;
    procedure DatenBegin;
    procedure DatenEnd;
    function sucheDaten_neu(x,y:integer):boolean;


  end;


implementation
Uses Tools,U_Spiel,U_Asteroid_Manager,U_Asteroid,U_Key,U_Mame,U_Schiff,U_Schuss_Manager,U_Schuss,
     StrUtils, Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,unit1,
     Dialogs, StdCtrls,  ExtCtrls,Sockets,SyncObjs;

constructor TUfoSchuss.Create;
begin
  inherited Create;
  active:=false;
end;

destructor TUfoSchuss.Destroy;
begin
  inherited Destroy;
end;

procedure TUfoSchuss.Idle;
begin
  if (Mame.Daten=0)and(Spiel.IdleCounter=0)and(length(Zeit)<100) then setVorhersage(100);
end;

procedure TUfoSchuss.DatenBegin;
begin
  detect:=false;
  setVorhersage(alter+MameLatenz,false);
  inc(alter,MameLatenz);
end;

procedure TUfoSchuss.Treffer_Ausweichrichtung_Vorhersage;
var i:integer;
begin
  for i:=alter to length(Zeit)-1 do
      if berechne_abstand2(Schiff.xx,schiff.yy,Zeit[i].x,Zeit[i].y)<=schiff.breite*schiff.breite then exit;
  i:=alter+treffer-20;
  if i>alter then i:=alter;
  if i<0 then i:=0;
  Treffer_Ausweichrichtung:=berechne_richtung_winkel(schiff.xx,schiff.yy,Zeit[i].x,Zeit[i].y);
end;


procedure TUfoSchuss.TrefferVorhersage;
  var i:integer;
begin
  treffer:=-1;
  Treffer_Ausweichrichtung:=-1;
  if not schiff.detect then exit;

  for i:=alter to length(Zeit)-1 do
      if berechne_abstand(Schiff.xx,schiff.yy,Zeit[i].x,Zeit[i].y)<=Schiff.Groesse then begin Treffer:=i-alter;Treffer_Ausweichrichtung_Vorhersage;exit;end;
end;

procedure TUfoSchuss.teste_Hyperspace;
  var d:integer;
begin
  if (schiff.detect)and(alter>=2)and(treffer>=0)and(treffer<=HyperspaceTest+2) then begin

     if Treffer_Ausweichrichtung<0 then begin key.HyperSpace;log('','UFO-Schuss: HyperSpace '+inttostr(Treffer_Ausweichrichtung));{}exit;end;

     d:=schiff.winkel-Treffer_Ausweichrichtung;
     while d>127 do dec(d,256);
     while d<-128 do inc(d,256);
     if abs(d)<25 then begin {log('','UFO-Schuss: Schiff breite OK '+inttostr(Treffer_Ausweichrichtung));{}exit;end;

     key.HyperSpace;
    { log('','UFO-Schuss: HyperSpace '+inttostr(Treffer_Ausweichrichtung));{}
     exit;
  end;
end;

procedure TUfoSchuss.setVorhersage(max:integer;const testMaxVorhersage:boolean=true);
var i,start:integer;
    dx,dy:integer;
begin
  if testMaxVorhersage then begin
     case alter of
          0..0:  if max>2 then max:=2;
          1..3:  if max>alter+5 then max:=alter+5;
          4..7:  if max>alter+10 then max:=alter+10;
          8..999:if max>alter+100 then max:=alter+100;
     end;
  end;
  if max<=length(Zeit) then exit;

  start:=length(zeit);
  setlength(zeit,max+1);
  if alter<=0 then begin
     for i:=start to max do begin
         Zeit[i].x:=XX;
         Zeit[i].y:=YY;
     end;
     exit;
  end;
  if alter>=8 then begin
     dx:=Optimierex(Zeit[alter].x-Zeit[alter-8].x);
     dy:=Optimierey(Zeit[alter].y-Zeit[alter-8].y);
     for i:=start to max do  begin
         Zeit[i].x:=OptimiereX(Zeit[i-8].x+dx);
         Zeit[i].y:=OptimiereY(Zeit[i-8].y+dy);
     end;
     exit;
  end;
  if alter<8 then begin
     dx:=Optimierex(Zeit[alter].x-Zeit[0].x);
     dy:=Optimierey(Zeit[alter].y-Zeit[0].y);
     for i:=start to max do  begin
         Zeit[i].x:=OptimiereX(xx+dx*(i-alter) div alter);
         Zeit[i].y:=OptimiereY(yy+dy*(i-alter) div alter);
      end;
  end;
end;


procedure TUfoSchuss.DatenEnd;
begin
  TrefferVorhersage;
  teste_Hyperspace;
end;

function TUfoSchuss.sucheDaten(x,y:integer):boolean;
begin
  result:=false;
  if (alter<1)then exit;
  if (alter<=MameLatenz)and(berechne_abstand(x,y,xx,yy)<15) then result:=true;
  if (alter>MameLatenz)and(berechne_abstand(Zeit[alter].x,Zeit[alter].y,x,y)<5) then result:=true;
  if not result then exit;

  detect:=true;
  xx:=x;
  yy:=y;
  if (Zeit[alter].x<>x)or(Zeit[alter].y<>y)then begin
     setlength(zeit,alter+1);
     Zeit[alter].x:=x;
     Zeit[alter].y:=y;
  end;
  if length(zeit)<alter+5 then setVorhersage(alter+6);
end;

function TUfoSchuss.sucheDaten_neu(x,y:integer):boolean;
begin

//  if not asteroid.Asteroid[0].Active then begin result:=false;exit;end; // wenn kein ufo, dann kein neuer ufo-schuss

  detect:=true;
  active:=true;
  alter:=0;
  xx:=x;
  yy:=y;
  setlength(zeit,1);
  Zeit[0].x:=x;
  Zeit[0].y:=y;
  result:=true;

end;



end.

