unit U_Spiel;
interface
uses SyncObjs;


type TSpiel = class(TObject)
  private
  protected
  public
    ende:boolean;
    IdleCounter:integer;
    Punkte,leben,level:integer;
    startzeit:double;
    spielzeit:integer;
    levelZeit:integer;

    constructor Create;
    destructor Destroy; override;
    procedure Idle;
    procedure Go;
    procedure DatenBegin;
    procedure DatenEnd;
    procedure neuesLevel;
    procedure setPunkte(const p:integer);
    procedure setLeben(const l:integer);
  end;


implementation
Uses U_Asteroid_Manager,U_Key,U_Mame,U_Schiff,U_Schuss_Manager,U_UfoSchuss_Manager,U_Explosion_Manager,
     Unit1,tools,U_Ki_Manager,  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
     Dialogs, StdCtrls, ExtCtrls;


constructor TSpiel.Create;
begin
  inherited Create;

  IdleCounter:=0;
  startzeit:=0;
  punkte:=0;
  spielzeit:=0;
  Level:=-1;
  LevelZeit:=-1000;
  ende:=false;

  Asteroid:=TAsteroid_Manager.Create;
  Schuss:=TSchuss_Manager.Create;
  UfoSchuss:=TUfoSchuss_Manager.Create;
  Schiff:=TSchiff.Create;
  Explosion:=TExplosion_Manager.create;
  Key:=TKey.Create;
  KI:=TKi_Manager.Create;
  Mame:=TMame.Create;

end;

destructor TSpiel.Destroy;
begin
  ende:=true;
  Mame.Daten:=99;
  Mame.Free;
  Ki.free;
  Key.Free;
  Explosion.free;
  Schiff.Free;
  UfoSchuss.Free;
  Schuss.Free;
  Asteroid.Free;
  inherited Destroy;
end;

procedure TSpiel.Idle;
begin
  if Mame.Daten<>0 then exit;
  inc(IdleCounter);

  if Mame.Daten=0 then Schiff.Idle;
  if Mame.Daten=0 then Schuss.Idle;
  if Mame.Daten=0 then UfoSchuss.Idle;
  if Mame.Daten=0 then Asteroid.Idle;
  if Mame.Daten=0 then Explosion.Idle;
  if Mame.Daten=0 then KI.Idle;
  if Mame.Daten=0 then Mame.Idle;
  if Mame.Daten=0 then Key.Idle;


  if (Mame.Daten=0)and((IdleCounter=200)or(IdleCounter>1000000)) then application.ProcessMessages;

end;

procedure TSpiel.Go;
begin
  idle;
  if (Mame.Daten=1)or(Mame.Daten=2) then begin
     Mame.Analyse;
     Schiff.go;
     Ki.Go;
     Key.senden;

     IdleCounter:=-1;
     idle;
  end;
end;

procedure TSpiel.DatenBegin;
begin
end;

procedure TSpiel.neuesLevel;
begin
  inc(level);
  Levelzeit:=0;
end;
procedure TSpiel.setLeben(const l:integer);
begin
  if l=leben-1 then log('','Schiff getroffen');
  leben:=l;
end;


procedure TSpiel.setPunkte(const p:integer);
var t,e:integer;
begin
  t:=(punkte div 100000)*100000;
  e:=punkte-t;
  if (p<10000)and(e>90000) then t:=t+100000;
  if level<2 then t:=0;
  punkte:=t+p;
end;


procedure TSpiel.DatenEnd;
begin
  if startzeit>0 then inc(spielzeit,MameLatenz);
  inc(levelZeit,MameLatenz);
end;




end.
