/*
 * Decompiled with CFR 0.152.
 */
package io;

import gui.StatusPanel;
import io.CombatAI;
import io.CombatControl;
import io.CombatState;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class CombatConnection {
    public static final String DEFAULT_HOST = "127.0.0.1";
    public static final int DEFAULT_PORT = 1979;
    public static final int RECEIVE_TIMEOUT = 5000;
    public static final int RETRY_DELAY = 2000;
    private byte[] inBuffer = new byte[1026];
    private byte[] outBuffer;
    private String host;
    private int port;
    private DatagramSocket socket;
    private boolean isConnected;
    private boolean isAlive;
    private CombatState state;
    private CombatControl control;
    private CombatAI listener;
    private boolean stop;
    private Runnable communicationCycle;
    private Thread communicationThread;
    private StatusPanel guiOut;

    public CombatConnection(String host, int port, CombatAI listener) {
        byte[] byArray = new byte[8];
        byArray[0] = 99;
        byArray[1] = 116;
        byArray[2] = 109;
        byArray[3] = 97;
        byArray[4] = 109;
        byArray[5] = 101;
        this.outBuffer = byArray;
        this.host = DEFAULT_HOST;
        this.port = 1979;
        this.socket = null;
        this.isConnected = false;
        this.isAlive = false;
        this.state = new CombatState();
        this.control = new CombatControl();
        this.stop = false;
        this.communicationCycle = new Runnable(){

            @Override
            public void run() {
                while (!CombatConnection.this.stop) {
                    if (!CombatConnection.this.stop) {
                        CombatConnection.this.connect();
                        while (!(CombatConnection.this.isConnected || CombatConnection.this.isAlive || CombatConnection.this.stop)) {
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            CombatConnection.this.connect();
                        }
                        CombatConnection.this.updateStatus();
                    }
                    if (!CombatConnection.this.stop) {
                        CombatConnection.this.sendControl(CombatConnection.this.control);
                        CombatConnection.this.receiveState(CombatConnection.this.state);
                        while (CombatConnection.this.isConnected && !CombatConnection.this.isAlive && !CombatConnection.this.stop) {
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            CombatConnection.this.sendControl(CombatConnection.this.control);
                            CombatConnection.this.receiveState(CombatConnection.this.state);
                            CombatConnection.this.updateStatus();
                        }
                    }
                    if (CombatConnection.this.stop) continue;
                    while (CombatConnection.this.isConnected && CombatConnection.this.isAlive && !CombatConnection.this.stop) {
                        if (!CombatConnection.this.receiveState(CombatConnection.this.state)) continue;
                        if (CombatConnection.this.listener.isActivated()) {
                            CombatConnection.this.listener.handleState(CombatConnection.this.state, CombatConnection.this.control);
                        } else {
                            CombatConnection.this.listener.watchState(CombatConnection.this.state, CombatConnection.this.control);
                        }
                        CombatConnection.this.sendControl(CombatConnection.this.control);
                    }
                    CombatConnection.this.state.reset();
                    CombatConnection.this.control.reset();
                    CombatConnection.this.listener.reset();
                }
                CombatConnection.this.disconnect();
            }
        };
        this.communicationThread = new Thread(this.communicationCycle);
        this.guiOut = null;
        this.host = host;
        this.port = port;
        this.listener = listener;
    }

    private void connect() {
        try {
            this.disconnect();
            InetAddress adress = InetAddress.getByName(this.host);
            this.socket = new DatagramSocket();
            this.socket.setSoTimeout(5000);
            this.socket.connect(adress, this.port);
            this.isConnected = true;
            System.out.println("connected to " + this.host + " at port " + this.port);
        }
        catch (UnknownHostException uhe) {
            this.isConnected = false;
            System.out.println("unable to connect: " + uhe);
        }
        catch (IOException ioe) {
            this.isConnected = false;
            System.out.println("unable to connect: " + ioe);
        }
    }

    private void disconnect() {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    private boolean receiveState(CombatState state) {
        try {
            DatagramPacket packet = new DatagramPacket(this.inBuffer, this.inBuffer.length);
            this.socket.receive(packet);
            state.update(this.inBuffer);
            if (state.isValid()) {
                this.control.onApproval(this.inBuffer[1025] & 0xFF);
                state.update(this.control);
                this.isAlive = true;
            } else {
                this.isAlive = false;
            }
        }
        catch (IOException e) {
            this.isAlive = false;
        }
        return this.isAlive;
    }

    public void selectHost(String server) {
        String[] values = server.split(":");
        if (values.length < 3) {
            if (values.length > 0) {
                this.host = values[0];
            }
            this.port = values.length > 1 ? Integer.parseInt(values[1]) : 1979;
            this.disconnect();
            this.updateConnection();
        }
    }

    private void sendControl(CombatControl control) {
        try {
            this.outBuffer[6] = control.getControl();
            control.onSend();
            this.outBuffer[7] = control.getPacketCount();
            DatagramPacket packet = new DatagramPacket(this.outBuffer, this.outBuffer.length);
            this.socket.send(packet);
            this.isConnected = true;
        }
        catch (IOException e) {
            this.isConnected = false;
        }
    }

    public void setGUIOutput(StatusPanel guiOut) {
        this.guiOut = guiOut;
        this.updateConnection();
        this.updateStatus();
    }

    public void startCommunication() {
        this.communicationThread.setName("Connection Cycle Thread");
        this.communicationThread.setPriority(10);
        this.communicationThread.start();
    }

    public void stopCommunication() {
        this.stop = true;
        try {
            this.communicationThread.interrupt();
            this.communicationThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String toString() {
        String serverFormat = "%s:%d";
        return String.format(serverFormat, this.host, this.port);
    }

    public void updateConnection() {
        if (this.guiOut != null) {
            this.guiOut.updateConnection(this.getHost(), this.getPort());
        }
    }

    public void updateStatus() {
        if (this.guiOut != null) {
            if (this.isConnected) {
                if (this.isAlive) {
                    if (this.listener != null && this.listener.isActivated()) {
                        this.guiOut.updateState(3);
                    } else {
                        this.guiOut.updateState(2);
                    }
                } else {
                    this.guiOut.updateState(1);
                }
            } else {
                this.guiOut.updateState(0);
            }
        }
    }
}

