package objects;

public class PreAsteroid extends Asteroid {
	
	public int timeToSpawn;
	
	public PreAsteroid(int x, int y, int type, int scale, int timeToSpawn)
	{
		super(x, y, type, scale);
		this.timeToSpawn = timeToSpawn;
		id = -1;
	}
	
	public void update(int newX, int newY, int frameDif) {
		posX = newX;
		posY = newY;
		timeToSpawn = Math.max(0, timeToSpawn - frameDif);
	}
	
	public int getTimeToSpawn()
	{
		return timeToSpawn;
	}
}
