///////////////////////////////////////////////////////////////////////////////
// @ Eduard Heidt                                                            //
///////////////////////////////////////////////////////////////////////////////


#pragma once

#include <windows.h>

static void gotoxy(short x, short y)
{
	HANDLE hConsole = GetStdHandle ( STD_OUTPUT_HANDLE );

	if ( INVALID_HANDLE_VALUE != hConsole )
	{
		COORD pos = {x, y};
		SetConsoleCursorPosition ( hConsole, pos );
	}
}

static void clrscr()
{
	DWORD n; /* Number of characters written */
	DWORD size; /* number of visible characters */
	COORD coord = {0}; /* Top left screen position */
	CONSOLE_SCREEN_BUFFER_INFO csbi;
	
	HANDLE h = GetStdHandle ( STD_OUTPUT_HANDLE );
	GetConsoleScreenBufferInfo ( h, &csbi );
	size = csbi.dwSize.X * csbi.dwSize.Y;
	FillConsoleOutputCharacter ( h, TEXT ( ' ' ), size, coord, &n );
	GetConsoleScreenBufferInfo ( h, &csbi );
	FillConsoleOutputAttribute ( h, csbi.wAttributes, size, coord, &n );
	SetConsoleCursorPosition ( h, coord );
}