///////////////////////////////////////////////////////////////////////////////
// @ Eduard Heidt                                                            //
///////////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "game.h"
#include "statistics.h"
#include "console.h"
#include "fps.h"

unsigned int GameStatus::t = 0;         // Anzahl Durchlufe
unsigned int GameStatus::frameno = 0;   // aktuelle Framezahl; ohne Frameverlust == t

GameStatus::GameStatus (void)
:
	nAsteroids(0),
	nshots(0),
	score(0),
	lifes(0),
	hash(0),
	new_shots(0),
	new_shots_by_ufo(0),
	new_aster(0)
{
   ship.present = false;
	saucer.present = false;
   saucer.size = 0;
}

void Asteroid::set(int _x, int _y, int _type, int _sf)
{
	type = _type;
	sf = _sf;

	Object::set(_x, _y);

	switch (sf)
	{
		case 0:  rad = 32.f; break;
		case 15: rad = 16.f; break;
		case 14: rad = 8.f; break;
	}
}

void Saucer::set(int _x, int _y, int sf)
{
	Object::set(_x, _y);

	size = sf;
	is_ufo = true;

	switch (sf)
	{
		case 0:  rad = 32.f; break;
		case 15: rad = 16.f; break;
		case 14: rad = 8.f; break;
	}
}


void GameStatus::clear(void)
{
	ship.present = false;
	saucer.present = false;

	saucer.size = 0;
	nObjects = 0;
	nAsteroids = 0;
	nSmallAsteroids = 0;
	nshots = 0;
	score = 0;
	nNotReal = 0;
	nexplosions = 0;

	lifes = 0;
}


//#include "d:\development\zlib\include\zlib.h"
	
void Game::PlayRecord(char* file)
{
#if 0

	state.t = 0;
	gzFile f = gzopen(file, "rb");

	FramePacket frame;
	KeysPacket keys;

	char info[0x39+1];
	gzread(f, &info, 0x38);

	while(!gzeof(f))
	{
		gzread(f, &keys.keys, 1);
		gzread(f, &frame.vectorram, 1024);		
		state.t++;
		InterpretScreen(frame, state);
		MakeStat(state);
	}

	gzclose(f);
#endif
}

void Game::End()
{
	stat_gameover(*this->GetState());
	
	this->GetState()->nAsteroids =
	this->GetState()->nshots  =
	this->GetState()->score =
	this->GetState()->lifes =
	this->GetState()->hash =
	this->GetState()->new_shots =
	this->GetState()->new_shots_by_ufo =
	this->GetState()->new_aster = 0;
}

void Game::Run(void)
{
   FramePacket frame;
   KeysPacket keys;
   __int8 prevframe = 0;

   	
   running = true;

   for (unsigned int t = 1; /*endlos*/; ++t)
   {
	  if(!running)
		  return;

      ++keys.ping;
      connection.SendPacket(keys);

		/* nachtrgliche, optionale Protokollerweiterung: Einmalig den Spielernamen schicken
   Bringt die ursprngliche MAME-Version zum Abbruch; ist zum Spielen bers Internet gegen
   den Server asteroids.heise.de gedacht.
*/	
		if(t==10)
			connection.SendPlayerName();

      connection.ReceivePacket(frame);

      // jedes gesendete Pckchen erhlt eine individuelle Nummer zur Latenzmessung
      ++state.frameno;
      if (frame.frameno != ++prevframe || frame.ping != keys.ping)
      {
         int ping = keys.ping - frame.ping;
         if (ping < 0)
            ping += 256;
         int lostframes = frame.frameno - prevframe;
         if (lostframes < 0)
            lostframes += 256;
         prevframe = frame.frameno;
         state.frameno += lostframes;

         printf("\nLatenz %d. %d Frames verloren.", ping, lostframes);
      }

			InterpretScreen(frame, state);
			
			if(state.score < 100 && !state.ship.IsPresent())
				t = 1;

			state.t = t;
			keys.clear();   // alle Tasten loslassen
			player.MakeTurn (state, keys);


   }
}

GameStatus Game::state;


bool earlier_s(const Shot& a, const Shot& b) {return a.id<b.id;}
bool earlier_o(const Object* a, const Object* b) {return a->id<b->id;}


static unsigned int wombat(const unsigned char *data, int len)
{
    unsigned int        result;
    int                 i,j;
    unsigned char       octet;
    
    result = -1;
    
    for (i=0; i<len; i++)
    {
        octet = *(data++);
        for (j=0; j<8; j++)
        {
            if ((octet >> 7) ^ (result >> 31))
            {
                result = (result << 1) ^ 0x04c11db7;
            }
            else
            {
                result = (result << 1);
            }
            octet <<= 1;
        }
    }
    
    return ~result;             /* The complement of the remainder */
}


void Game::InterpretScreen(const FramePacket &packet, GameStatus& game)
{
	unsigned short vector_ram[512];
	int dx, dy, sf, vx, vy, vz, vs;
	int v1x = 0;
	int v1y = 0;
	int shipdetect = 0;

	int nshots = game.nshots;
	int nAsteroids = game.nAsteroids;
	game.clear();
	Shot shots[6]; 
	ZeroMemory(shots, sizeof(Shot)*6); memcpy(shots, game.shots, sizeof(Shot)*nshots);
	Asteroid asteroids[MAX_ASTEROIDS]; 
	ZeroMemory(asteroids, sizeof(Asteroid)*MAX_ASTEROIDS); memcpy(asteroids, game.asteroids, sizeof(Asteroid)*nAsteroids);


	game.ping = packet.ping-2;
	game.crc = wombat((unsigned char*)&packet.vectorram[0], 1024);

	/* Vektor-RAM in 16-Bit-Worte konvertieren. War in der ersten Version mal ein sportlicher
	Typecast: unsigned short *vector_ram = (unsigned short*)packet.vectorram;
	Das klappt aber nur auf Little-Endian-Systemen, daher besser portabel: */
	for (int i=0; i<512; ++i)
		vector_ram[i] = (unsigned char)packet.vectorram[2*i] | (unsigned char)packet.vectorram[2*i+1] << 8;

	//memcpy(vector_ram, packet.vectorram, 512);


	if (vector_ram[0] != 0xe001 && vector_ram[0] != 0xe201)
		return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL

	int  nscore = 0;
	char score[255];
	ZeroMemory(score, 255);




	int atyp = 0;

	int pc = 1;
	while (pc < 512)
	{
		int op = vector_ram[pc] >> 12;
		switch (op)
		{
		case 0xa: // LABS
			vy = vector_ram[pc] & 0x3ff;
			vx = vector_ram[pc+1] & 0x3ff;
			vs = vector_ram[pc+1] >> 12;
			break;
		case 0xb: // HALT
			goto END;
		case 0xc: // JSRL
			atyp = -1;
			switch (vector_ram[pc] & 0xfff)
			{
			case 0x880:    // Explosion gro (3)
                  game.explosions[game.nexplosions++].set(vx, vy, 3, vs);
                  break;
            case 0x896:    // Explosion (2)
                  game.explosions[game.nexplosions++].set(vx, vy, 2, vs);
                  break;
            case 0x8B5:    // Explosion (1)
                  game.explosions[game.nexplosions++].set(vx, vy, 1, vs);
                  break;
          case 0x8D0:    // Explosion klein (0)
                  game.explosions[game.nexplosions++].set(vx, vy, 0, vs);
                  break;
			case 0x8f3: 
			case 0x8ff: 
			case 0x90d: 
			case 0x91a: atyp = op;
							{
							switch(vs)
							{
							case 14: //Small
								game.nSmallAsteroids++;
							case 0:	//Big	
							case 15: //Middle
								
								//game.asteroids[game.nAsteroids++].set(vx, vy, atyp, vs);
								bool found = false;
								for(int an = 0; an < nAsteroids && found == false; an++)
								{
									if(asteroids[an].old>=0)
									if(asteroids[an].SameObject(vx,vy) && asteroids[an].type == atyp && asteroids[an].sf == vs)
									{
										game.asteroids[game.nAsteroids] = asteroids[an];
										game.asteroids[game.nAsteroids++].set(vx, vy, atyp, vs);
										found = true;

										asteroids[an].old = -1;
										game.asteroids[game.nAsteroids-1].hit = false;
										game.asteroids[game.nAsteroids-1].kill = INT_MAX;

										//int k = 0;
										//if(vs == 0) k = 0;
										//if(vs == 15) k = 0;

										////VDC fdeg = asteroids[an].GetDir().DegreeBetween180(asteroids[an].GetRelativePos());
										//if(asteroids[an].s_start+k >= game.t)// && (fdeg < 80 || fdeg > 100))
										//{
										//	game.notreal[game.nNotReal] = game.asteroids[game.nAsteroids];
										//	game.notreal[game.nNotReal].s_start = 0;
										//	game.notreal[game.nNotReal].hit = false;
										//	game.notreal[game.nNotReal++].set(vx, vy, 0, 14);
										//}


									}
								}

								if(!found)
								{
									//printf("\n%d new Asteroid found", game.t);
									game.asteroids[game.nAsteroids].Reset();
									game.asteroids[game.nAsteroids++].set(vx, vy, atyp, vs);
									game.new_aster++;
								}		

								break;
							}
							break;
							}
			case 0x929:
				game.saucer.present = true;
				game.saucer.set(vx, vy, vs);
				break;

				//B2E	B32	B3A	B41	B48	B4F	B56	B5B	B63
			case 0xadd: score[nscore++] = '0'; break;
			case 0xb2e: score[nscore++] = '1'; break;
			case 0xb32: score[nscore++] = '2'; break;
			case 0xb3a: score[nscore++] = '3'; break;
			case 0xb41: score[nscore++] = '4'; break;
			case 0xb48: score[nscore++] = '5'; break;
			case 0xb4f: score[nscore++] = '6'; break;
			case 0xb56: score[nscore++] = '7'; break;
			case 0xb5b: score[nscore++] = '8'; break;
			case 0xb63: score[nscore++] = '9'; break;
			case 0xb2c: score[nscore++] = ' '; break;	//leerzeichen
			
			case 0xa6d: ++game.lifes; break;
			}  
			break;
		case 0xd: // RTSL
			goto END;
		case 0xe: // JMPL
			/*
			pc = vector_ram[pc] & 0xfff;
			break;
			*/
			goto END;
		case 0xf: // SVEC
			/*
			dy = vector_ram[pc] & 0x300;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = (vector_ram[pc] & 3) << 8;
			if ((vector_ram[pc] & 4) != 0)
				dx = -dx;
			sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
			vz = (vector_ram[pc] & 0xf0) >> 4;
			*/
			break;
		default:
			dy = vector_ram[pc] & 0x3ff;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = vector_ram[pc+1] & 0x3ff;
			if ((vector_ram[pc+1] & 0x400) != 0)
				dx = -dx;
			sf = op;
			vz = vector_ram[pc+1] >> 12;
			if (dx == 0 && dy == 0 && vz == 15)
			{
				//game.shots[game.nshots++].set(vx, vy);
				bool found = false;
				for(int sn = 0; sn < nshots && found == false; sn++)
					if(shots[sn].SameObject(vx,vy))
					{
						game.shots[game.nshots] = shots[sn];
						game.shots[game.nshots].set(vx, vy);
						game.nshots++;
						found = true;
					}

				if(!found)
				{
					game.shots[game.nshots++].set(vx, vy);
					game.shots[game.nshots-1].old = 0;
					//printf("\nNew Shot found [%f]", game.shots[game.nshots-1].GetRelativePos().Len());
				}
			}
			if (op == 6 && vz == 12 && dx != 0 && dy != 0)
			{
				switch (shipdetect)
				{
				case 0:
					v1x = dx;
					v1y = dy;
					++shipdetect;
					break;
				case 1:
					game.ship.present = true;
					game.ship.set(vx, vy);
					game.ship.SetDir(v1x - dx, v1y - dy);
					++shipdetect;
					break;
				}
			}
			else if (shipdetect == 1)
				shipdetect = 0;

			break;
		}
		if (op <= 0xa)
			++pc;
		if (op != 0xe) // JMPL
			++pc;
	} 

END:

	score[strlen(score)-5] = 0;
	game.score = atoi(score);

	if(game.t > 10000 && game.score < 20000)
		game.score += 100000;

	std::stable_sort(&game.shots[0], &game.shots[game.nshots],  earlier_s);


	for(int n = 0; n < game.nshots; n++)
	{
		if(game.shots[n].old == 0)
		{
			if(!game.saucer.IsPresent())
				game.shots[n].ufo = false;
			else
				game.shots[n].ufo = game.shots[n].pos.SqDistanceTo(game.saucer.pos) < game.shots[n].pos.SqDistanceTo(game.ship.pos);

			if(game.shots[n].ufo)
				game.new_shots_by_ufo++;
			else
				game.new_shots++;

		}
	}

	for(int n = 0; n < game.nAsteroids; n++)
	{
		game.asteroids[n].mask = 1<<game.nObjects;
		game.pObjects[game.nObjects++] = &game.asteroids[n];	
	}

	for(int n = 0; n < game.nNotReal; n++)
	{
		game.notreal[n].mask = 1<<game.nObjects;
		game.pObjects[game.nObjects++] = &game.notreal[n];	
	}

	if(game.saucer.IsPresent())
	{
		game.saucer.mask = 1<<game.nObjects;
		game.pObjects[game.nObjects++] = &game.saucer;
	}

	//std::stable_sort(&game.pObjects[0], &game.pObjects[game.nshots],  earlier_o);
	
	MakeStat(game);

}																			

