///////////////////////////////////////////////////////////////////////////////
// @ Eduard Heidt                                                            //
///////////////////////////////////////////////////////////////////////////////



#include <stdio.h>
#include <atlstr.h>

#include "fps.h"
#include "connection.h"
#include "game.h"
#include "player.h"

#include "glout.h"
#include "console.h"
#include "emu.h"


static bool ZEON = 0;
static bool MAME = 0;
static bool EMU = 0;
static bool PLAY_REC = 0;

//static char* MAME_PARAM = " asteroid -window -beam 4 -skip_gameinfo -resolution 640x480 -speed 1 -sleep -nosound -seconds_to_run 400"; // -state_directory .\\states -state 1"; //0.2", //1 -cheat", 
static char* MAME_PARAM = " asteroid -skip_gameinfo -speed 20 -nosound -sleep -video none -seconds_to_run 400"; //0.2", //1 -cheat", 
bool OPENGL = 0;


int main(int argc, char** argv)
{
	CString param;
	CString param2;
	CString ip = "127.0.0.1";

	if(argc >= 2)
		param = CString(argv[1]).MakeUpper();
		
	if(argc >= 3)
		param2 = CString(argv[2]).MakeUpper();

	if(param.Find("EMU")>=0) EMU = true;
	else if(param.Find(".GZ")>=0) PLAY_REC = true;
	else if(param.Find("MAME")>=0) MAME = true;
	else if(!param.IsEmpty()) ip = param;
	else
	{
		fprintf(stderr, "Aufruf: asteroid <IP-Adresse>|MAME|*.gz\n");
		return 1;
	}
	
	if(!param2.IsEmpty())
		OPENGL = true;

	_argc = argc; _argv = argv;

	HANDLE hGl = NULL;

/////////////////////////////////

	PROCESS_INFORMATION pi = {0};
	STARTUPINFO si = {sizeof(si)};
	si.wShowWindow = SW_HIDE;
	si.dwFlags = STARTF_USEPOSITION;
	si.dwX = 10;
	si.dwY = 10;

AGAIN:

	if(MAME && !PLAY_REC && !EMU)
	{

		::CreateProcess("D:\\heise\\mame\\mameaster.exe", 
						MAME_PARAM,
						NULL, 
						NULL, 
						FALSE, 
						0, 
						NULL, 
						"D:\\heise\\mame",  
						&si, 
						&pi);
		::WaitForSingleObject( pi.hProcess, 1000); 

		::SetPriorityClass(pi.hProcess, BELOW_NORMAL_PRIORITY_CLASS);
	}
	else if(ZEON && !EMU && !MAME)
		ip = "192.168.0.190";

///////////////////////////////////////////////////////////////////////////////

	if(hGl == NULL && OPENGL)
	{
		DWORD dwThreadID = 0;
		hGl = ::CreateThread(NULL, 0,  glOutProc, 0, THREAD_PRIORITY_NORMAL, &dwThreadID);
	}
		
	Connection con(ip);
	Player player;
	Game game(con, player);
	
	try
	{
		if(PLAY_REC)
			game.PlayRecord(argv[1]);
		else if(EMU)
		{
			FPSCounter fps; 
			Emulator(&game).prog();
		}
		else
		{
			game.Run();
		}
	}
	catch (connection_error &ce)
	{
		//fprintf(stderr, ce.what());
	}
	//catch (...)
	//{
	//	//fprintf(stderr, "Unerwarteter Fehler.");
	//}


	game.End();

	if(PLAY_REC)
		return 0;


	Sleep(2000);

	if(pi.hProcess)	TerminateProcess(pi.hProcess,0);
	
	//goto AGAIN;

	if(hGl) { TerminateThread(hGl,0); CloseHandle(hGl); }
	
	return 0;
}
