///////////////////////////////////////////////////////////////////////////////
// @ Eduard Heidt                                                            //
///////////////////////////////////////////////////////////////////////////////

#ifndef PLAYERH
#define PLAYERH

#include <memory.h>
#include "math2d.h"

class GameStatus;
class KeysPacket;
class Object;

class Turn
{
	Turn(int n, int w, int f, int t):navigate(n), wait(w), fire(f),o(NULL), ts(INT_MAX), thrust(t){}
public:
	int navigate;
	int wait;
	int fire;
	int thrust;

	static Turn Wait()
	{
		Turn t(0,1,0,0);
		return t;
	}

	static Turn Fire(int n, int w, Object* o, int _ts)
	{
		Turn t(n,w,1, 0);
		t.o = o;
		t.ts = _ts;
		return t;
	}

	static Turn Thrust()
	{
		return Turn(0,0,0,1);
	}
	
	Object* o;
	int ts;

	Turn(){}
};


class Player
{
	static const char INITL = 0;
	static const char INITR = 1;
	static const char SCAN  = 2;
	static const char MOVE  = 3;
	static const char FIRE  = 4;
	static const char WAIT  = 5;

	bool SyncWinkelByte(GameStatus& s, KeysPacket &turn);

	int memxy[8][2];
	unsigned sync;
	unsigned m;

public:
	char state;


	Player():state(INITL),m(0),sync(0){memset(memxy, sizeof(int)*16,0);}

	void MakeTurn(GameStatus& gamestate, KeysPacket &turn);

	int CanFlayAway(GameStatus&s, Object& o);
	bool CanShootAt(GameStatus&s, Object& o);
	Turn CalcTurn(GameStatus& s, byte curr_deg, unsigned t_offset, unsigned mask);
	unsigned GetTimeToNextShot(GameStatus& gamestate);
	void CheckDeg(GameStatus &s);
	int NavigateTo(GameStatus &s, Vector& pos, bool away = false);
	


};


#endif

